/*
 * Decompiled with CFR 0.152.
 */
package net.tapaal.gui.petrinet.editor;

import dk.aau.cs.model.CPN.Variable;
import java.awt.Component;
import java.awt.FontMetrics;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JSeparator;
import javax.swing.ListCellRenderer;

public class ColorComboBoxRenderer
extends JLabel
implements ListCellRenderer {
    final JComboBox comboBox;
    final int adjust;

    public ColorComboBoxRenderer(JComboBox comboBox) {
        this(comboBox, 0);
    }

    public ColorComboBoxRenderer(JComboBox comboBox, int adjust) {
        this.comboBox = comboBox;
        this.adjust = adjust;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (value instanceof JSeparator) {
            return new JSeparator(0);
        }
        if (value instanceof Variable) {
            String text = ((Variable)value).getName();
            this.setText(ColorComboBoxRenderer.ellipsis(text, this.maxChars(text, list, this.adjust)));
            this.setFont(list.getFont());
        } else if (value != null) {
            String text = value.toString();
            this.setText(ColorComboBoxRenderer.ellipsis(text, this.maxChars(text, list, this.adjust)));
            this.setFont(list.getFont());
        }
        return this;
    }

    private int maxChars(String text, JList list, int adjust) {
        FontMetrics metrics = list.getFontMetrics(list.getFont());
        int width = 0;
        int comboBoxWidth = this.comboBox.getWidth();
        for (int i = 0; i < text.length(); ++i) {
            int cWidth = metrics.charWidth(text.charAt(i));
            if (width + cWidth > comboBoxWidth) {
                return i - adjust;
            }
            width += cWidth;
        }
        return text.length();
    }

    public static String ellipsis(String text, int length) {
        if (length > 3 && text.length() > length) {
            return text.substring(0, length - 3) + "...";
        }
        return text;
    }
}

