/*
 * Decompiled with CFR 0.152.
 */
package net.tapaal.gui.petrinet.dialog;

import dk.aau.cs.model.tapn.TimedPlace;
import dk.aau.cs.model.tapn.TimedTransition;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import net.tapaal.gui.petrinet.Template;
import net.tapaal.gui.petrinet.undo.DeleteTimedPlaceCommand;
import net.tapaal.gui.petrinet.undo.DeleteTimedTransitionCommand;
import pipe.gui.petrinet.PetriNetTab;
import pipe.gui.petrinet.graphicElements.tapn.TimedPlaceComponent;
import pipe.gui.petrinet.graphicElements.tapn.TimedTransitionComponent;
import pipe.gui.petrinet.undo.UndoManager;

public class StatisticsPanel
extends JPanel {
    private final int topBottomMargin = 3;
    private final int rightMargin = 10;
    private Point location;
    private JButton removeOrphanTransitions;
    private JButton removeOrphanPlaces;
    private static final String REMOVE_ORPHAN_TRANSITIONS_TOOL_TIP = "<html>Remove all orphan transitions<br /> (transitions with no arcs attached)<br /> in all components</html>";
    private static final String REMOVE_ORPHAN_PLACES_TOOL_TIP = "<html>Remove all orphan places<br /> (transitions with no arcs attached)<br /> in all components</html>";
    private static final String DIALOG_TITLE = "Statistics";
    final String[] headLines = new String[]{"", "Shown component", "Active components", "All components"};
    private static JDialog dialog;
    private Object[][] contents;
    private final PetriNetTab tab;

    private StatisticsPanel(Object[][] statistics, PetriNetTab tab) {
        super(new GridBagLayout());
        this.contents = statistics;
        this.tab = tab;
        this.init();
    }

    public static void showStatisticsPanel(Object[][] statistics, PetriNetTab tab) {
        StatisticsPanel panel = new StatisticsPanel(statistics, tab);
        JOptionPane optionPane = new JOptionPane(panel, 1);
        dialog = optionPane.createDialog(DIALOG_TITLE);
        dialog.pack();
        dialog.setVisible(true);
    }

    private JPanel init() {
        this.addRow(this.headLines, 0, true);
        for (int i = 0; i < this.contents.length - 2; ++i) {
            this.addRow(this.contents[i], (i + 1) * 2, false);
        }
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.gridwidth = this.headLines.length;
        gbc.insets = new Insets(3, 0, 3, 10);
        for (int i = 3; i < this.contents.length * 2 - 2; i += 2) {
            JSeparator jSep = new JSeparator();
            jSep.setPreferredSize(new Dimension(1, 3));
            gbc.gridy = i;
            this.add((Component)jSep, gbc);
        }
        this.addOrphanButtons(gbc);
        this.setVisible(true);
        return null;
    }

    private void addRow(Object[] row, int rowNumber, boolean isHeadLine) {
        for (int i = 0; i < row.length; ++i) {
            JLabel current;
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = i;
            gbc.gridy = rowNumber;
            gbc.anchor = i == 0 ? 17 : 13;
            gbc.insets = new Insets(0, 0, 0, 10);
            if (row[i] == null) continue;
            if (isHeadLine) {
                current = new JLabel(row[i].toString());
                current.setFont(new Font(current.getFont().getName(), 1, current.getFont().getSize()));
                this.add((Component)current, gbc);
                continue;
            }
            current = new JLabel(row[i].toString());
            this.add((Component)current, gbc);
        }
    }

    private boolean checkIfOrphan(int contentNumber, GridBagConstraints gbc, boolean orphanTransitions) {
        boolean isOrphan = false;
        for (int i = 1; i < this.contents[this.contents.length - contentNumber].length; ++i) {
            if (this.contents[this.contents.length - contentNumber][i].toString().equals("0")) continue;
            isOrphan = true;
        }
        if (isOrphan) {
            int rowNumber = contentNumber == 1 && orphanTransitions ? this.contents.length * 2 - 2 : this.contents.length * 2;
            JSeparator jSep = new JSeparator();
            jSep.setPreferredSize(new Dimension(1, 3));
            gbc.gridy = this.contents.length * 2 - 1;
            this.add((Component)jSep, gbc);
            this.addRow(this.contents[this.contents.length - contentNumber], rowNumber, false);
            jSep = new JSeparator();
            jSep.setPreferredSize(new Dimension(1, 3));
            gbc.gridy = this.contents.length * 2 + 1;
            this.add((Component)jSep, gbc);
        }
        return isOrphan;
    }

    private void addOrphanButtons(GridBagConstraints gbc) {
        boolean orphanTransition = this.checkIfOrphan(2, gbc, false);
        boolean orphanPlace = this.checkIfOrphan(1, gbc, orphanTransition);
        this.removeOrphanTransitions = new JButton("Remove orphan transitions");
        this.removeOrphanTransitions.setToolTipText(REMOVE_ORPHAN_TRANSITIONS_TOOL_TIP);
        this.removeOrphanPlaces = new JButton("Remove orphan places");
        this.removeOrphanPlaces.setToolTipText(REMOVE_ORPHAN_PLACES_TOOL_TIP);
        JPanel buttonsPanel = new JPanel(new FlowLayout(2));
        if (orphanTransition) {
            this.addTransitionAction();
            buttonsPanel.add(this.removeOrphanTransitions);
        }
        if (orphanPlace) {
            this.addPlaceAction();
            buttonsPanel.add(this.removeOrphanPlaces);
        }
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = this.contents.length * 2 + 2;
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.gridwidth = this.headLines.length;
        this.add((Component)buttonsPanel, gbc);
    }

    private void addTransitionAction() {
        this.removeOrphanTransitions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Iterable<Template> templates = StatisticsPanel.this.tab.allTemplates();
                UndoManager undoManager = StatisticsPanel.this.tab.getUndoManager();
                boolean first = true;
                for (Template template : templates) {
                    List<TimedTransition> orphans = template.model().getOrphanTransitions();
                    for (TimedTransition trans : orphans) {
                        TimedTransitionComponent t = (TimedTransitionComponent)template.guiModel().getTransitionByName(trans.name());
                        DeleteTimedTransitionCommand cmd = new DeleteTimedTransitionCommand(t, t.underlyingTransition().model(), template.guiModel());
                        if (first) {
                            undoManager.addNewEdit(cmd);
                            first = false;
                        } else {
                            undoManager.addEdit(cmd);
                        }
                        cmd.redo();
                    }
                }
                StatisticsPanel.this.contents = StatisticsPanel.this.tab.currentTemplate().model().getStatistics();
                StatisticsPanel.this.tab.drawingSurface().repaint();
                StatisticsPanel.this.location = dialog.getLocationOnScreen();
                StatisticsPanel.this.removeAll();
                StatisticsPanel.this.init();
                JOptionPane optionPane = new JOptionPane(StatisticsPanel.this, 1);
                dialog.dispose();
                dialog = optionPane.createDialog(StatisticsPanel.DIALOG_TITLE);
                dialog.setLocation(StatisticsPanel.this.location);
                dialog.pack();
                dialog.setVisible(true);
            }
        });
    }

    private void addPlaceAction() {
        this.removeOrphanPlaces.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Iterable<Template> templates = StatisticsPanel.this.tab.allTemplates();
                UndoManager undoManager = StatisticsPanel.this.tab.getUndoManager();
                boolean first = true;
                for (Template template : templates) {
                    List<TimedPlace> orphans = template.model().getOrphanPlaces();
                    for (TimedPlace place : orphans) {
                        TimedPlaceComponent timedPlace = (TimedPlaceComponent)template.guiModel().getPlaceByName(place.name());
                        DeleteTimedPlaceCommand cmd = new DeleteTimedPlaceCommand(timedPlace, template.model(), template.guiModel());
                        if (first) {
                            undoManager.addNewEdit(cmd);
                            first = false;
                        } else {
                            undoManager.addEdit(cmd);
                        }
                        cmd.redo();
                    }
                }
                StatisticsPanel.this.contents = StatisticsPanel.this.tab.currentTemplate().model().getStatistics();
                StatisticsPanel.this.tab.drawingSurface().repaint();
                StatisticsPanel.this.location = dialog.getLocationOnScreen();
                StatisticsPanel.this.removeAll();
                StatisticsPanel.this.init();
                JOptionPane optionPane = new JOptionPane(StatisticsPanel.this, 1);
                dialog.dispose();
                dialog = optionPane.createDialog(StatisticsPanel.DIALOG_TITLE);
                dialog.setLocation(StatisticsPanel.this.location);
                dialog.pack();
                dialog.setVisible(true);
            }
        });
    }
}

