/*
 * Decompiled with CFR 0.152.
 */
package net.tapaal.gui.petrinet.dialog;

import javax.swing.JSlider;
import javax.swing.JTextField;

public class QuerySlider
extends JSlider {
    private double realValue;
    private double desiredMin;
    private double desiredMax;

    public QuerySlider(int value, double desiredMin, double desiredMax) {
        this(value, desiredMin, desiredMax, 100);
    }

    public QuerySlider(int value, double desiredMin, double desiredMax, int resolution) {
        super(0, resolution, value);
        this.desiredMin = desiredMin;
        this.desiredMax = desiredMax;
    }

    public void setRealValue(double realValue) {
        this.realValue = realValue;
    }

    public double getRealValue() {
        return this.realValue;
    }

    public double getDesiredMin() {
        return this.desiredMin;
    }

    public double getDesiredMax() {
        return this.desiredMax;
    }

    public void updateValue(JTextField textField, int precision) {
        int value = this.getValue();
        double desiredMin = this.getDesiredMin();
        double desiredMax = this.getDesiredMax();
        double proportion = (double)value / (double)this.getMaximum();
        double interpretedValue = desiredMin + proportion * (desiredMax - desiredMin);
        double scale = Math.pow(10.0, precision);
        double roundedValue = (double)Math.round(interpretedValue * scale) / scale;
        textField.setText("" + roundedValue);
        this.setRealValue(roundedValue);
        this.setToolTipText(String.format("Value: %." + precision + "f", roundedValue));
    }
}

