/*
 * Decompiled with CFR 0.152.
 */
package net.tapaal.gui.petrinet.dialog;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import net.tapaal.swinghelpers.SwingHelper;
import pipe.gui.GuiFrame;
import pipe.gui.TAPAALGUI;
import pipe.gui.petrinet.PetriNetTab;
import pipe.gui.swingcomponents.EscapableDialog;

public class NewTAPNPanel
extends EscapableDialog {
    private final JRootPane rootPane;
    private final GuiFrame frame;
    private JTextField nameTextBox;
    private JRadioButton timedNet;
    private JRadioButton untimedNet;
    private JRadioButton gameNet;
    private JRadioButton nonGameNet;
    private JRadioButton coloredNet;
    private JRadioButton nonColorNet;
    private JRadioButton stochasticNet;
    private static int newNameCounter = 1;
    static NewTAPNPanel newTAPNPanel;
    private static final String COLORED_GAMES_NOT_SUPPORTED = "There exists no verification engine for colored games, we only allow modelling.\n\n Do you wish to continue?";

    public static void showNewTapnPanel(GuiFrame frame) {
        if (newTAPNPanel == null) {
            newTAPNPanel = new NewTAPNPanel(frame, "New Net", true);
            newTAPNPanel.pack();
            newTAPNPanel.setPreferredSize(newTAPNPanel.getSize());
            newTAPNPanel.setMinimumSize(new Dimension(newTAPNPanel.getWidth(), newTAPNPanel.getHeight() - 150));
            newTAPNPanel.setLocationRelativeTo(null);
            newTAPNPanel.setResizable(true);
        }
        String defaultName = String.format("New Petri net %1$d", newNameCounter);
        newTAPNPanel.setName(defaultName);
        newTAPNPanel.setVisible(true);
    }

    private NewTAPNPanel(GuiFrame frame, String title, boolean modal) {
        super(frame, title, modal);
        this.frame = frame;
        this.rootPane = this.getRootPane();
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        this.initNamePanel();
        this.initSelectionPanel();
        this.initButtonPanel();
    }

    private void initButtonPanel() {
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        JButton okButton = new JButton("OK");
        okButton.setMaximumSize(new Dimension(100, 25));
        okButton.setMinimumSize(new Dimension(100, 25));
        okButton.setPreferredSize(new Dimension(100, 25));
        okButton.setMnemonic(79);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 5, 5, 5);
        buttonPanel.add((Component)okButton, gbc);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.setMaximumSize(new Dimension(100, 25));
        cancelButton.setMinimumSize(new Dimension(100, 25));
        cancelButton.setPreferredSize(new Dimension(100, 25));
        cancelButton.setMnemonic(67);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = -1;
        gbc.anchor = 13;
        buttonPanel.add((Component)cancelButton, gbc);
        okButton.addActionListener(e -> this.createNewTAPNBasedOnSelection(this.nameTextBox.getText(), this.timedNet.isSelected(), this.gameNet.isSelected(), this.coloredNet.isSelected(), this.stochasticNet.isSelected()));
        this.rootPane.setDefaultButton(okButton);
        cancelButton.addActionListener(e -> this.exit());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.insets = new Insets(0, 8, 5, 8);
        gbc.anchor = 13;
        this.add((Component)buttonPanel, gbc);
    }

    protected void exit() {
        this.rootPane.getParent().setVisible(false);
    }

    protected void createNewTAPNBasedOnSelection(String name, boolean isTimed, boolean isGame, boolean isColored, boolean isStochastic) {
        if (!((String)name).endsWith(".tapn")) {
            name = (String)name + ".tapn";
        }
        if (((String)name).isEmpty()) {
            JOptionPane.showMessageDialog(TAPAALGUI.getApp(), "You must provide a name for the net.", "Error", 1);
            return;
        }
        try {
            PetriNetTab tab = PetriNetTab.createNewEmptyTab((String)name, isTimed, isGame, isColored, isStochastic);
            TAPAALGUI.openNewTabFromStream(tab);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(TAPAALGUI.getApp(), "Something went wrong while creating a new model. Please try again.", "Error", 1);
            e.printStackTrace();
            return;
        }
        ++newNameCounter;
        this.exit();
    }

    private void initNamePanel() {
        JPanel namePanel = new JPanel(new GridBagLayout());
        JLabel nameLabel = new JLabel("Name:");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.anchor = 13;
        gbc.insets = new Insets(3, 3, 3, 3);
        namePanel.add((Component)nameLabel, gbc);
        String defaultName = String.format("New Petri net %1$d", newNameCounter);
        this.nameTextBox = new JTextField(defaultName);
        SwingHelper.setPreferredWidth(this.nameTextBox, 330);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = new Insets(3, 3, 3, 3);
        namePanel.add((Component)this.nameTextBox, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.add((Component)namePanel, gbc);
    }

    private void initSelectionPanel() {
        JPanel selectionPanel = new JPanel(new GridBagLayout());
        this.initTimeOptions(selectionPanel);
        this.initGameOptions(selectionPanel);
        this.initColorOptions(selectionPanel);
        this.initStochasticOptions(selectionPanel);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 0.0;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.add((Component)selectionPanel, gbc);
    }

    private void initTimeOptions(JPanel selectionPanel) {
        JPanel isTimedPanel = new JPanel(new GridBagLayout());
        ButtonGroup isTimedRadioButtonGroup = new ButtonGroup();
        JLabel timedText = new JLabel("Use time semantics: ");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.anchor = 17;
        gbc.insets = new Insets(3, 3, 3, 3);
        isTimedPanel.add((Component)timedText, gbc);
        this.untimedNet = new JRadioButton("No");
        this.untimedNet.setSelected(true);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.anchor = 17;
        gbc.insets = new Insets(3, 3, 3, 3);
        isTimedPanel.add((Component)this.untimedNet, gbc);
        isTimedRadioButtonGroup.add(this.untimedNet);
        this.timedNet = new JRadioButton("Yes");
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.anchor = 17;
        gbc.insets = new Insets(3, 3, 3, 3);
        isTimedPanel.add((Component)this.timedNet, gbc);
        isTimedRadioButtonGroup.add(this.timedNet);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 0.0;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 5, 5, 5);
        selectionPanel.add((Component)isTimedPanel, gbc);
    }

    private void initGameOptions(JPanel selectionPanel) {
        JPanel isGamePanel = new JPanel(new GridBagLayout());
        ButtonGroup isGameRadioButtonGroup = new ButtonGroup();
        JLabel gameText = new JLabel("Use game semantics:");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.anchor = 17;
        gbc.insets = new Insets(3, 3, 3, 3);
        isGamePanel.add((Component)gameText, gbc);
        this.nonGameNet = new JRadioButton("No");
        this.nonGameNet.setSelected(true);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.anchor = 17;
        gbc.insets = new Insets(3, 3, 3, 3);
        isGamePanel.add((Component)this.nonGameNet, gbc);
        isGameRadioButtonGroup.add(this.nonGameNet);
        this.gameNet = new JRadioButton("Yes");
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.anchor = 17;
        gbc.insets = new Insets(3, 3, 3, 3);
        isGamePanel.add((Component)this.gameNet, gbc);
        isGameRadioButtonGroup.add(this.gameNet);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 5, 5, 5);
        selectionPanel.add((Component)isGamePanel, gbc);
    }

    private void initColorOptions(JPanel selectionPanel) {
        JPanel isColorPanel = new JPanel(new GridBagLayout());
        ButtonGroup isColorRadioButtonGroup = new ButtonGroup();
        JLabel colorText = new JLabel("Use color semantics:");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.anchor = 17;
        gbc.insets = new Insets(3, 3, 3, 3);
        isColorPanel.add((Component)colorText, gbc);
        this.nonColorNet = new JRadioButton("No");
        this.nonColorNet.setSelected(true);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.anchor = 17;
        gbc.insets = new Insets(3, 3, 3, 3);
        isColorPanel.add((Component)this.nonColorNet, gbc);
        isColorRadioButtonGroup.add(this.nonColorNet);
        this.coloredNet = new JRadioButton("Yes");
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.anchor = 17;
        gbc.insets = new Insets(3, 3, 3, 3);
        isColorPanel.add((Component)this.coloredNet, gbc);
        isColorRadioButtonGroup.add(this.coloredNet);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 5, 5, 5);
        selectionPanel.add((Component)isColorPanel, gbc);
    }

    private void initStochasticOptions(JPanel selectionPanel) {
        JPanel isStochasticPanel = new JPanel(new GridBagLayout());
        ButtonGroup isStochasticRadioButtonGroup = new ButtonGroup();
        JLabel colorText = new JLabel("Use stochastic semantics :");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.anchor = 17;
        gbc.insets = new Insets(3, 3, 3, 3);
        isStochasticPanel.add((Component)colorText, gbc);
        final JRadioButton nonStochasticNet = new JRadioButton("No");
        nonStochasticNet.setSelected(true);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.anchor = 17;
        gbc.insets = new Insets(3, 3, 3, 3);
        isStochasticPanel.add((Component)nonStochasticNet, gbc);
        isStochasticRadioButtonGroup.add(nonStochasticNet);
        this.stochasticNet = new JRadioButton("Yes");
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.anchor = 17;
        gbc.insets = new Insets(3, 3, 3, 3);
        isStochasticPanel.add((Component)this.stochasticNet, gbc);
        isStochasticRadioButtonGroup.add(this.stochasticNet);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 5, 5, 5);
        selectionPanel.add((Component)isStochasticPanel, gbc);
        ActionListener refreshOthers = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (NewTAPNPanel.this.stochasticNet.isSelected()) {
                    NewTAPNPanel.this.nonGameNet.setSelected(true);
                    NewTAPNPanel.this.timedNet.setSelected(true);
                }
            }
        };
        ActionListener refreshStochastic = new ActionListener(){
            final /* synthetic */ NewTAPNPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (this.this$0.gameNet.isSelected()) {
                    nonStochasticNet.setSelected(true);
                }
                if (this.this$0.untimedNet.isSelected()) {
                    nonStochasticNet.setSelected(true);
                }
            }
        };
        this.stochasticNet.addActionListener(refreshOthers);
        this.untimedNet.addActionListener(refreshStochastic);
        this.gameNet.addActionListener(refreshStochastic);
    }

    @Override
    public void setName(String name) {
        this.nameTextBox.setText(name);
    }
}

