/*
 * Decompiled with CFR 0.152.
 */
package net.tapaal.gui.petrinet.dialog;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import net.tapaal.gui.petrinet.undo.ChangeAllNamesVisibilityCommand;
import pipe.gui.petrinet.PetriNetTab;
import pipe.gui.petrinet.graphicElements.PetriNetObject;

public class NameVisibilityPanel
extends JPanel {
    private static final String DIALOG_TITLE = "Change Name Visibility";
    private static JDialog dialog;
    private JRadioButton showNames;
    private JRadioButton hideNames;
    private JRadioButton placeOption;
    private JRadioButton transitionOption;
    private JRadioButton bothOption;
    private JRadioButton selectedComponent;
    private JRadioButton allComponents;
    ButtonGroup visibilityRadioButtonGroup;
    ButtonGroup objectRadioButtonGroup;
    ButtonGroup componentRadioButtonGroup;
    JPanel visibilityPanel;
    JPanel placeTransitionPanel;
    JPanel componentPanel;
    private final PetriNetTab tab;

    public NameVisibilityPanel(PetriNetTab tab) {
        super(new GridBagLayout());
        this.tab = tab;
        this.init();
    }

    public void showNameVisibilityPanel() {
        JOptionPane optionPane = new JOptionPane(this, 1);
        dialog = optionPane.createDialog(DIALOG_TITLE);
        dialog.pack();
        dialog.setVisible(true);
        Object selectedValue = optionPane.getValue();
        if (selectedValue != null) {
            this.ChangeNameVisibilityBasedOnSelection();
        }
    }

    public void showNameVisibilityPanel(boolean isVisible, boolean isPlace, boolean isTransition, boolean isSelectedComponent) {
        JOptionPane optionPane = new JOptionPane(this, 1);
        this.showNames.setSelected(isVisible);
        this.hideNames.setSelected(!isVisible);
        this.placeOption.setSelected(isPlace && !isTransition);
        this.transitionOption.setSelected(isTransition && !isPlace);
        this.bothOption.setSelected(isPlace && isTransition);
        this.selectedComponent.setSelected(isSelectedComponent);
        this.allComponents.setSelected(!isSelectedComponent);
        dialog = optionPane.createDialog(DIALOG_TITLE);
        dialog.pack();
        dialog.setVisible(true);
        Object selectedValue = optionPane.getValue();
        if (selectedValue != null) {
            this.ChangeNameVisibilityBasedOnSelection();
        }
    }

    private void init() {
        this.visibilityPanel = this.initVisibilityOptions();
        this.placeTransitionPanel = this.initPlaceTransitionOptions();
        this.componentPanel = this.initComponentOptions();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.gridwidth = 3;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.visibilityPanel, gbc);
        gbc.gridy = 1;
        this.add((Component)this.placeTransitionPanel, gbc);
        gbc.gridy = 2;
        this.add((Component)this.componentPanel, gbc);
        this.setVisible(true);
    }

    private JPanel initVisibilityOptions() {
        JPanel panel = new JPanel(new GridBagLayout());
        this.visibilityRadioButtonGroup = new ButtonGroup();
        JLabel text = new JLabel("Choose visibility:       ");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.anchor = 17;
        gbc.insets = new Insets(3, 3, 3, 3);
        panel.add((Component)text, gbc);
        this.showNames = new JRadioButton("Show");
        this.showNames.setSelected(true);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.anchor = 17;
        gbc.insets = new Insets(3, 3, 3, 3);
        panel.add((Component)this.showNames, gbc);
        this.visibilityRadioButtonGroup.add(this.showNames);
        this.hideNames = new JRadioButton("Hide");
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.anchor = 17;
        gbc.insets = new Insets(3, 3, 3, 3);
        panel.add((Component)this.hideNames, gbc);
        this.visibilityRadioButtonGroup.add(this.hideNames);
        return panel;
    }

    private JPanel initPlaceTransitionOptions() {
        JPanel panel = new JPanel(new GridBagLayout());
        this.objectRadioButtonGroup = new ButtonGroup();
        JLabel text = new JLabel("Choose group:           ");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.anchor = 17;
        gbc.insets = new Insets(3, 3, 3, 3);
        panel.add((Component)text, gbc);
        this.placeOption = new JRadioButton("Places");
        this.placeOption.setSelected(true);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.anchor = 17;
        gbc.insets = new Insets(3, 3, 3, 3);
        panel.add((Component)this.placeOption, gbc);
        this.objectRadioButtonGroup.add(this.placeOption);
        this.transitionOption = new JRadioButton("Transitions");
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.anchor = 17;
        gbc.insets = new Insets(3, 3, 3, 3);
        panel.add((Component)this.transitionOption, gbc);
        this.objectRadioButtonGroup.add(this.transitionOption);
        this.bothOption = new JRadioButton("Both");
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.anchor = 17;
        gbc.insets = new Insets(3, 3, 3, 3);
        panel.add((Component)this.bothOption, gbc);
        this.objectRadioButtonGroup.add(this.bothOption);
        return panel;
    }

    private JPanel initComponentOptions() {
        JPanel panel = new JPanel(new GridBagLayout());
        this.componentRadioButtonGroup = new ButtonGroup();
        JLabel text = new JLabel("Choose components: ");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.anchor = 17;
        gbc.insets = new Insets(3, 3, 3, 3);
        panel.add((Component)text, gbc);
        this.selectedComponent = new JRadioButton("Selected component");
        this.selectedComponent.setSelected(true);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.anchor = 17;
        gbc.insets = new Insets(3, 3, 3, 3);
        panel.add((Component)this.selectedComponent, gbc);
        this.componentRadioButtonGroup.add(this.selectedComponent);
        this.allComponents = new JRadioButton("All components");
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.anchor = 17;
        gbc.insets = new Insets(3, 3, 3, 3);
        panel.add((Component)this.allComponents, gbc);
        this.componentRadioButtonGroup.add(this.allComponents);
        return panel;
    }

    protected void ChangeNameVisibilityBasedOnSelection() {
        HashMap<PetriNetObject, Boolean> places = new HashMap();
        Map<PetriNetObject, Boolean> transitions = new HashMap<PetriNetObject, Boolean>();
        if (this.placeOption.isSelected() || this.bothOption.isSelected()) {
            places = this.tab.showNames(this.showNames.isSelected(), true, this.selectedComponent.isSelected());
        }
        if (this.transitionOption.isSelected() || this.bothOption.isSelected()) {
            transitions = this.tab.showNames(this.showNames.isSelected(), false, this.selectedComponent.isSelected());
        }
        ChangeAllNamesVisibilityCommand changeVisibilityCommand = new ChangeAllNamesVisibilityCommand(this.tab, places, transitions, this.showNames.isSelected());
        this.tab.getUndoManager().addNewEdit(changeVisibilityCommand);
    }

    public boolean isShowNamesOption() {
        return this.showNames.isSelected();
    }

    public boolean isSelectedComponentOption() {
        return this.selectedComponent.isSelected();
    }

    public boolean isPlaceOption() {
        return this.placeOption.isSelected() || this.bothOption.isSelected();
    }

    public boolean isTransitionOption() {
        return this.transitionOption.isSelected() || this.bothOption.isSelected();
    }
}

