/*
 * Decompiled with CFR 0.152.
 */
package net.tapaal.gui.petrinet.dialog;

import dk.aau.cs.util.Require;
import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;

public class ExportBatchResultTableModel
extends AbstractTableModel {
    static final long serialVersionUID = 959574725280211159L;
    private final String[] HEADINGS = new String[]{"File name", "Destination", "Status"};
    private final ArrayList<String[]> results = new ArrayList();

    public void addResult(String[] result) {
        int lastRow = this.results.size();
        this.results.add(result);
        this.fireTableRowsInserted(lastRow, lastRow);
    }

    @Override
    public String getColumnName(int column) {
        return this.HEADINGS[column];
    }

    @Override
    public int getColumnCount() {
        return this.HEADINGS.length;
    }

    @Override
    public int getRowCount() {
        if (this.results == null) {
            return 0;
        }
        return this.results.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex >= this.results.size()) {
            return null;
        }
        String[] result = this.results.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return result[0];
            }
            case 1: {
                return result[1];
            }
            case 2: {
                return result[2];
            }
        }
        return null;
    }

    public void clear() {
        this.results.clear();
        this.fireTableDataChanged();
    }

    public String[] getResult(int index) {
        Require.that(index >= 0 && index < this.results.size(), "Index out of range");
        return this.results.get(index);
    }
}

