/*
 * Decompiled with CFR 0.152.
 */
package net.tapaal.gui.petrinet.dialog;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import pipe.gui.TAPAALGUI;
import pipe.gui.petrinet.PetriNetTab;

public class ColoredSimulationDialog
extends JDialog {
    private static final String TOOL_TIP_PARTITIONING = "Partitions the colors into logically equivalent groups before unfolding";
    private static final String TOOL_TIP_COLOR_FIXPOINT = "Explores the possible colored markings and only unfolds for those";
    private static final String TOOL_TIP_SYMMETRIC_VARIABLES = "Finds variables with equivalent behavior and treats them as the same variable";
    private JCheckBox usePartition;
    private JCheckBox useColorFixpoint;
    private JCheckBox useSymmetricvars;
    private static boolean cancelled;
    private static boolean explicitSimulationMode;
    private static PetriNetTab currentTab;
    public static ColoredSimulationDialog coloredSimDialog;

    private ColoredSimulationDialog(Frame frame, String title, boolean modal) {
        super(frame, title, modal);
        this.initComponents();
    }

    public static void showSimulationDialog(PetriNetTab tab, boolean explicit) {
        int unfoldAnswer = 0;
        if (explicit) {
            Object[] options = new String[]{"Cancel", "Unfold", "Explicit"};
            unfoldAnswer = JOptionPane.showOptionDialog(TAPAALGUI.getApp(), "Simulate the net explicitly or unfolded", "Simulation Mode", 1, 3, null, options, options[2]);
        } else {
            Object[] options = new String[]{"Cancel", "Unfold"};
            unfoldAnswer = JOptionPane.showOptionDialog(TAPAALGUI.getApp(), "The net will need to be unfolded before entering simulation mode", "Unfolding Required", 2, 3, null, options, options[1]);
        }
        if (unfoldAnswer == 2) {
            explicitSimulationMode = true;
        } else if (unfoldAnswer == 1) {
            ColoredSimulationDialog.showUnfoldDialog(tab);
        } else {
            cancelled = true;
        }
    }

    public static void showUnfoldDialog(PetriNetTab tab) {
        currentTab = tab;
        if (tab.getLens().isTimed()) {
            currentTab.createNewAndUnfoldColor(false, false, false);
            return;
        }
        if (coloredSimDialog == null) {
            coloredSimDialog = new ColoredSimulationDialog(TAPAALGUI.getApp(), "Unfold", true);
            coloredSimDialog.pack();
            coloredSimDialog.setPreferredSize(coloredSimDialog.getSize());
            coloredSimDialog.setMinimumSize(new Dimension(coloredSimDialog.getWidth(), coloredSimDialog.getHeight()));
            coloredSimDialog.setLocationRelativeTo(TAPAALGUI.getApp());
            coloredSimDialog.setResizable(false);
        }
        coloredSimDialog.setEnabled(true);
        coloredSimDialog.setVisible(true);
    }

    public static boolean wasCancelled() {
        return cancelled;
    }

    public static boolean explicitSimulationMode() {
        return explicitSimulationMode;
    }

    private void initComponents() {
        this.setLayout(new FlowLayout());
        JPanel mainPanel = new JPanel(new GridBagLayout());
        JPanel checkboxPanel = this.createCheckboxPanel();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(0, 8, 5, 8);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.anchor = 17;
        mainPanel.add((Component)checkboxPanel, gbc);
        JPanel buttonPanel = this.createButtonPanel();
        gbc.insets = new Insets(0, 8, 5, 8);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.anchor = 17;
        mainPanel.add((Component)buttonPanel, gbc);
        this.setContentPane(mainPanel);
    }

    private JPanel createCheckboxPanel() {
        JPanel checkboxPanel = new JPanel();
        checkboxPanel.setLayout(new GridBagLayout());
        this.usePartition = new JCheckBox("Partition");
        this.usePartition.setToolTipText(TOOL_TIP_PARTITIONING);
        this.usePartition.setSelected(true);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 8, 0, 8);
        checkboxPanel.add((Component)this.usePartition, gbc);
        this.useColorFixpoint = new JCheckBox("Color Fixpoint");
        this.useColorFixpoint.setToolTipText(TOOL_TIP_COLOR_FIXPOINT);
        this.useColorFixpoint.setSelected(true);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 8, 0, 8);
        checkboxPanel.add((Component)this.useColorFixpoint, gbc);
        this.useSymmetricvars = new JCheckBox("Symmetric Variables");
        this.useSymmetricvars.setToolTipText(TOOL_TIP_SYMMETRIC_VARIABLES);
        this.useSymmetricvars.setSelected(true);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 8, 0, 8);
        checkboxPanel.add((Component)this.useSymmetricvars, gbc);
        return checkboxPanel;
    }

    private JPanel createButtonPanel() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridBagLayout());
        JButton okButton = new JButton("OK");
        okButton.setMaximumSize(new Dimension(100, 25));
        okButton.setMinimumSize(new Dimension(100, 25));
        okButton.setPreferredSize(new Dimension(100, 25));
        okButton.setMnemonic(79);
        GridBagConstraints gbcOk = new GridBagConstraints();
        gbcOk.gridx = 1;
        gbcOk.gridy = 0;
        gbcOk.anchor = 17;
        gbcOk.insets = new Insets(5, 5, 5, 5);
        okButton.addActionListener(actionEvent -> this.onOK());
        JButton cancelButton = new JButton("Cancel");
        cancelButton.setMaximumSize(new Dimension(100, 25));
        cancelButton.setMinimumSize(new Dimension(100, 25));
        cancelButton.setPreferredSize(new Dimension(100, 25));
        cancelButton.setMnemonic(67);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = -1;
        gbc.anchor = 13;
        cancelButton.addActionListener(e -> this.onCancel());
        buttonPanel.add((Component)cancelButton, gbc);
        buttonPanel.add((Component)okButton, gbcOk);
        return buttonPanel;
    }

    private void exit() {
        coloredSimDialog.setVisible(false);
    }

    private void onCancel() {
        cancelled = true;
        this.exit();
    }

    private void onOK() {
        this.exit();
        currentTab.createNewAndUnfoldColor(this.usePartition.isSelected(), this.useColorFixpoint.isSelected(), this.useSymmetricvars.isSelected());
    }

    public static void resetFlags() {
        cancelled = false;
        explicitSimulationMode = false;
    }
}

