/*
 * Decompiled with CFR 0.152.
 */
package net.tapaal.gui.petrinet.dialog;

import dk.aau.cs.model.CPN.Color;
import dk.aau.cs.model.CPN.Variable;
import dk.aau.cs.model.tapn.TimedTransition;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import pipe.gui.TAPAALGUI;
import pipe.gui.petrinet.Searcher;
import pipe.gui.swingcomponents.EscapableDialog;

public class ColoredBindingSelectionDialog {
    public static Map<Variable, Color> showDialog(TimedTransition transition, List<Map<Variable, Color>> validBindings) {
        String title = "Select binding for transition: " + transition.name();
        EscapableDialog dialog = new EscapableDialog(TAPAALGUI.getApp(), title, true);
        JPanel panel = new JPanel(new BorderLayout());
        ArrayList<Variable> variables = new ArrayList<Variable>();
        if (!validBindings.isEmpty()) {
            variables.addAll(validBindings.get(0).keySet());
            variables.sort((v1, v2) -> v1.getName().compareTo(v2.getName()));
        }
        JPanel searchPanel = new JPanel(new GridBagLayout());
        LinkedHashMap<Variable, JTextField> searchFields = new LinkedHashMap<Variable, JTextField>();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.gridy = 0;
        gbc.anchor = 17;
        for (Variable var : variables) {
            gbc.gridx = 0;
            gbc.weightx = 0.0;
            gbc.anchor = 13;
            JLabel label = new JLabel(var.getName() + ":");
            label.setHorizontalAlignment(4);
            searchPanel.add((Component)label, gbc);
            gbc.gridx = 1;
            gbc.weightx = 1.0;
            gbc.fill = 2;
            JTextField jTextField = new JTextField(16);
            searchFields.put(var, jTextField);
            searchPanel.add((Component)jTextField, gbc);
            ++gbc.gridy;
        }
        JScrollPane searchScroll = new JScrollPane(searchPanel);
        searchScroll.setPreferredSize(new Dimension(350, Math.min(200, variables.size() * 28)));
        panel.add((Component)searchScroll, "North");
        DefaultListModel<Map> listModel = new DefaultListModel<Map>();
        for (Map map : validBindings) {
            listModel.addElement(map);
        }
        JList<Object> bindingList = new JList<Object>(listModel);
        bindingList.setSelectionMode(0);
        bindingList.setSelectedIndex(0);
        bindingList.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                Map binding = (Map)value;
                StringBuilder sb = new StringBuilder();
                binding.entrySet().stream().sorted((e1, e2) -> ((Variable)e1.getKey()).getName().compareTo(((Variable)e2.getKey()).getName())).forEach(entry -> {
                    if (sb.length() > 0) {
                        sb.append(", ");
                    }
                    sb.append(((Variable)entry.getKey()).getName()).append(" = ").append(((Color)entry.getValue()).getName());
                });
                this.setText(sb.toString());
                return this;
            }
        });
        JScrollPane jScrollPane = new JScrollPane(bindingList);
        panel.add((Component)jScrollPane, "Center");
        HashMap<Variable, Searcher<Map>> searchers = new HashMap<Variable, Searcher<Map>>();
        for (Variable variable : variables) {
            searchers.put(variable, new Searcher<Map>(validBindings, binding -> {
                Color c = (Color)binding.get(variable);
                return c == null ? "" : c.getName();
            }));
        }
        final Runnable filterList = () -> {
            listModel.clear();
            block0: for (Map binding : validBindings) {
                for (Map.Entry entry : searchFields.entrySet()) {
                    Color c;
                    String filter = ((JTextField)entry.getValue()).getText().trim().toLowerCase();
                    if (filter.isEmpty() || (c = (Color)binding.get(entry.getKey())) != null && c.getName().toLowerCase().contains(filter)) continue;
                    continue block0;
                }
                listModel.addElement(binding);
            }
            if (!listModel.isEmpty()) {
                bindingList.setSelectedIndex(0);
            }
        };
        for (JTextField field : searchFields.values()) {
            field.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    filterList.run();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    filterList.run();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    filterList.run();
                }
            });
        }
        JPanel jPanel = new JPanel();
        AtomicReference<Object> selectedBindingRef = new AtomicReference<Object>(null);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(e -> dialog.setVisible(false));
        JButton selectButton = new JButton("Select");
        selectButton.addActionListener(e -> {
            int selectedIndex = bindingList.getSelectedIndex();
            if (selectedIndex != -1) {
                selectedBindingRef.set(((Map)bindingList.getModel().getElementAt(selectedIndex)));
                dialog.setVisible(false);
            }
        });
        dialog.getRootPane().setDefaultButton(selectButton);
        jPanel.add(cancelButton);
        jPanel.add(selectButton);
        panel.add((Component)jPanel, "South");
        dialog.add(panel);
        dialog.pack();
        FontMetrics fm = dialog.getFontMetrics(dialog.getFont());
        int titleWidth = fm.stringWidth(title);
        int decorationsWidth = 225;
        int requiredWidth = titleWidth + decorationsWidth;
        if (dialog.getWidth() < requiredWidth) {
            dialog.setSize(requiredWidth, dialog.getHeight());
        }
        Point point = MouseInfo.getPointerInfo().getLocation();
        int yOffset = 30;
        dialog.setLocation(point.x - dialog.getWidth() / 2, point.y + yOffset);
        SwingUtilities.invokeLater(() -> bindingList.requestFocusInWindow());
        dialog.setVisible(true);
        return selectedBindingRef.get();
    }
}

