/*
 * Decompiled with CFR 0.152.
 */
package net.tapaal.gui.petrinet.dialog;

import dk.aau.cs.io.batchProcessing.BatchProcessingResultsExporter;
import dk.aau.cs.model.tapn.TimedPlace;
import dk.aau.cs.translations.ReductionOption;
import dk.aau.cs.util.MemoryMonitor;
import dk.aau.cs.util.StringComparator;
import dk.aau.cs.verification.VerifyTAPN.VerifyDTAPN;
import dk.aau.cs.verification.VerifyTAPN.VerifyPN;
import dk.aau.cs.verification.VerifyTAPN.VerifyTAPN;
import dk.aau.cs.verification.batchProcessing.BatchProcessingListener;
import dk.aau.cs.verification.batchProcessing.BatchProcessingVerificationOptions;
import dk.aau.cs.verification.batchProcessing.BatchProcessingVerificationResult;
import dk.aau.cs.verification.batchProcessing.BatchProcessingWorker;
import dk.aau.cs.verification.batchProcessing.FileChangedEvent;
import dk.aau.cs.verification.batchProcessing.StatusChangedEvent;
import dk.aau.cs.verification.batchProcessing.VerificationTaskCompleteEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListModel;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import net.tapaal.gui.petrinet.dialog.BatchProcessingResultsTableModel;
import net.tapaal.gui.petrinet.dialog.FileNameCellRenderer;
import net.tapaal.gui.petrinet.undo.AddFileBatchProcessingCommand;
import net.tapaal.gui.petrinet.undo.RemoveFileBatchProcessingCommand;
import net.tapaal.gui.petrinet.verification.InclusionPlaces;
import net.tapaal.gui.petrinet.verification.TAPNQuery;
import net.tapaal.gui.petrinet.widgets.QueryPane;
import net.tapaal.gui.swingcomponents.MultiLineAutoWrappingToolTip;
import net.tapaal.swinghelpers.CustomJSpinner;
import pipe.gui.FileFinder;
import pipe.gui.MessengerImpl;
import pipe.gui.TAPAALGUI;
import pipe.gui.petrinet.undo.UndoManager;
import pipe.gui.swingcomponents.filebrowser.FileBrowser;

public class BatchProcessingDialog
extends JDialog {
    private static final String name_verifyTAPN = "TAPAAL Continuous Engine (VerifyTAPN)";
    private static final String name_verifyTAPNDiscreteVerificationTimeDartPTrie = "TAPAAL Discrete Engine w. Time Darts and PTrie";
    private static final String name_verifyTAPNDiscreteVerificationTimeDart = "TAPAAL Discrete Engine w. Time Darts";
    private static final String name_verifyTAPNDiscreteVerificationPTrie = "TAPAAL Discrete Engine w. PTries";
    private static final String name_verifyTAPNDiscreteVerificationNone = "TAPAAL Discrete Engine (VerifyDTAPN) w. no Optimizations";
    private static final String name_COMBI = "UPPAAL: Optimized Broadcast Reduction";
    private static final String name_STANDARD = "UPPAAL: Standard Reduction";
    private static final String name_OPTIMIZEDSTANDARD = "UPPAAL: Optimised Standard Reduction";
    private static final String name_BROADCAST = "UPPAAL: Broadcast Reduction";
    private static final String name_BROADCASTDEG2 = "UPPAAL: Broadcast Degree 2 Reduction";
    private static final String name_UNTIMED = "TAPAAL Untimed CTL Engine (VerifyPN)";
    private static final String name_BFS = "Breadth first search";
    private static final String name_DFS = "Depth first search";
    private static final String name_HEURISTIC = "Heuristic search";
    private static final String name_Random = "Random search";
    private static final String name_NONE_APPROXIMATION = "None";
    private static final String name_OVER_APPROXIMATION = "Over-approximation";
    private static final String name_UNDER_APPROXIMATION = "Under-approximation";
    private static final String TOOL_TIP_AddFilesButton = "Press to add nets to batch processing";
    private static final String TOOL_TIP_RemoveFilesButton = "Press to remove the currently selected nets";
    private static final String TOOL_TIP_ClearFilesButton = "Press to remove all nets from list";
    private static final String TOOL_TIP_Help = "See the options available for the specific engine";
    private static final String TOOL_TIP_TimeoutLabel = null;
    private static final String TOOL_TIP_TimeoutValue = "Enter the timeout in seconds";
    private static final String TOOL_TIP_NoTimeoutCheckBox = "Choose whether to use timeout";
    private static final String TOOL_TIP_OOMLabel = null;
    private static final String TOOL_TIP_OOMValue = "<html>Enter the maximum amount of available memory to the verification.<br>Verification is skipped as soon as it is detected that this amount of memory is exceeded.</html>";
    private static final String TOOL_TIP_NoOOMCheckBox = "Choose whether to use memory restrictions";
    private static final String TOOL_TIP_FileLabel = "Currently verified net";
    private static final String TOOL_TIP_StatusLabel = "Currently verified query";
    private static final String TOOL_TIP_ProgressLabel = "Progress of the currently running batch";
    private static final String TOOL_TIP_TimeLabel = null;
    private static final String TOOL_TIP_StartButton = "Press to start batch processing";
    private static final String TOOL_TIP_CancelButton = "Press to cancel the whole currently running batch";
    private static final String TOOL_TIP_SkipFileButton = "Press to skip the currently running verification";
    private static final String TOOL_TIP_ExportButton = "Press to export batch results into a CVS file";
    private static final String TOOL_TIP_CloseButton = "Press to close the batch processing dialog";
    private static final String NOT_SATISFIED_STRING_STRONG_SOUNDNESS = "Not Strongly Sound";
    private static final String NOT_SATISFIED_STRING_SOUNDNESS = "Not Sound";
    private static final String NOT_SATISFIED_STRING = "Not Satisfied";
    private static final String SATISFIED_STRING = "Satisfied";
    private static final String PROBABILITY_STRING = "P = ";
    private static final String INCONCLUSIVE_STRING = "Inconclusive";
    private static final String SATISFIED_SOUNDNESS_STRING = "Sound";
    private static final String SATISFIED_STRONG_SOUNDNESS_STRING = "Strongly Sound";
    private static String lastPath = null;
    private JSplitPane splitpane;
    private JPanel topPanel;
    private JPanel bottomPanel;
    private JPanel monitorPanel;
    private JPanel filesButtonsPanel;
    private JButton addFilesButton;
    private JButton clearFilesButton;
    private JButton removeFileButton;
    private JList<File> fileList;
    private DefaultListModel<File> listModel;
    private JPanel optionsPanel;
    private DefaultTableModel optionsTable;
    private JTable verificationTable;
    private JComboBox<String> engines;
    private HelpDialog helpDialogPN;
    private HelpDialog helpDialogDTAPN;
    private HelpDialog helpDialogTAPN;
    private JLabel statusLabel;
    private JLabel fileStatusLabel;
    private JButton startButton;
    private JButton cancelButton;
    private JButton skipFileButton;
    private JLabel progressLabel;
    private JLabel timerLabel;
    private JLabel memory;
    private long startTimeMs = 0L;
    private JButton exportButton;
    private JButton closeButton;
    private JPanel verificationOptionsPanel;
    private JCheckBox noTimeoutCheckbox;
    private JCheckBox noOOMCheckbox;
    private CustomJSpinner timeoutValue;
    private CustomJSpinner oomValue;
    private final JList<TAPNQuery> ListOfQueries;
    private final Timer timeoutTimer = new Timer(30000, e -> this.timeoutCurrentVerificationTask());
    private BatchProcessingResultsTableModel tableModel;
    private final List<File> files = new ArrayList<File>();
    private BatchProcessingWorker currentWorker;
    private final UndoManager undoManager = new UndoManager(null);
    private final Timer timer = new Timer(1000, new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            BatchProcessingDialog.this.timerLabel.setText((System.currentTimeMillis() - BatchProcessingDialog.this.startTimeMs) / 1000L + " s");
            BatchProcessingDialog.this.memory.setText((String)(peakMemory >= 0 ? peakMemory + " MB" : "N/A"));
        }
    });
    private static int memoryTimerCount = 0;
    private static int memoryTimerMode = 0;
    private static int peakMemory = -1;
    private final Timer memoryTimer = new Timer(50, new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (MemoryMonitor.isAttached()) {
                MemoryMonitor.getUsage();
                peakMemory = MemoryMonitor.getPeakMemoryValue();
                if (BatchProcessingDialog.this.useOOM() && MemoryMonitor.getPeakMemoryValue() > (Integer)BatchProcessingDialog.this.oomValue.getValue()) {
                    BatchProcessingDialog.this.oomCurrentVerificationTask();
                }
            }
            if (memoryTimerMode == 0 && memoryTimerCount == 2) {
                memoryTimerCount = 0;
                ++memoryTimerMode;
                BatchProcessingDialog.this.memoryTimer.setDelay(100);
            } else if (memoryTimerMode == 1 && memoryTimerCount == 4) {
                memoryTimerCount = 0;
                ++memoryTimerMode;
                BatchProcessingDialog.this.memoryTimer.setDelay(200);
            } else if (memoryTimerMode == 2 && memoryTimerCount == 5) {
                memoryTimerCount = 0;
                ++memoryTimerMode;
                BatchProcessingDialog.this.memoryTimer.setDelay(1000);
            } else if (memoryTimerMode < 3) {
                ++memoryTimerCount;
            }
        }
    });
    static BatchProcessingDialog batchProcessingDialog;

    private void startMemoryTimer() {
        if (this.memoryTimer.isRunning()) {
            this.memoryTimer.stop();
        }
        this.memoryTimer.setDelay(50);
        memoryTimerCount = 0;
        memoryTimerMode = 0;
        peakMemory = -1;
        this.memoryTimer.start();
    }

    private void stopMemoryTimer() {
        if (this.memoryTimer.isRunning()) {
            this.memoryTimer.stop();
        }
        MemoryMonitor.detach();
    }

    public static void showBatchProcessingDialog(JList<TAPNQuery> ListOfQueries) {
        if (ListOfQueries.getModel().getSize() != 0) {
            batchProcessingDialog = null;
        }
        if (batchProcessingDialog == null) {
            batchProcessingDialog = new BatchProcessingDialog((Frame)TAPAALGUI.getApp(), "Batch Processing", true, ListOfQueries);
            batchProcessingDialog.pack();
            batchProcessingDialog.setPreferredSize(batchProcessingDialog.getSize());
            batchProcessingDialog.setMinimumSize(new Dimension(batchProcessingDialog.getWidth(), batchProcessingDialog.getHeight() - 150));
            batchProcessingDialog.setLocationRelativeTo(null);
            batchProcessingDialog.setResizable(true);
        }
        batchProcessingDialog.setVisible(true);
    }

    private BatchProcessingDialog(Frame frame, String title, boolean modal, JList<TAPNQuery> ListOfQueries) {
        super(frame, title, modal);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                if (!BatchProcessingDialog.this.isQueryListEmpty()) {
                    batchProcessingDialog = null;
                }
                BatchProcessingDialog.this.terminateBatchProcessing();
            }
        });
        this.ListOfQueries = ListOfQueries;
        this.initComponents();
        this.makeShortcuts();
        if (!this.isQueryListEmpty()) {
            this.process();
        }
    }

    private void initComponents() {
        this.setLayout(new FlowLayout());
        this.topPanel = new JPanel(new GridBagLayout());
        this.bottomPanel = new JPanel(new GridBagLayout());
        this.initFileListPanel();
        this.initVerificationOptionsPanel();
        this.initMonitorPanel();
        this.initResultTablePanel();
        this.setFileListToTempFile();
        this.splitpane = new JSplitPane(0, this.topPanel, this.bottomPanel);
        this.splitpane.setResizeWeight(0.0);
        this.splitpane.setDividerSize(10);
        this.splitpane.setContinuousLayout(true);
        this.setContentPane(this.splitpane);
    }

    private void setFileListToTempFile() {
        if (!this.isQueryListEmpty()) {
            this.files.add(QueryPane.getTemporaryFile());
        }
    }

    private boolean isQueryListEmpty() {
        return this.ListOfQueries.getModel().getSize() == 0;
    }

    private void initFileListPanel() {
        JPanel fileListPanel = new JPanel(new GridBagLayout());
        fileListPanel.setBorder(BorderFactory.createTitledBorder("Models"));
        this.listModel = new DefaultListModel();
        this.fileList = new JList<File>(this.listModel);
        this.fileList.setSelectionMode(2);
        this.fileList.setSelectedIndex(0);
        this.fileList.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127) {
                    BatchProcessingDialog.this.removeSelectedFiles();
                }
            }
        });
        this.fileList.addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                if (this.fileList.getSelectedIndex() == -1) {
                    this.removeFileButton.setEnabled(false);
                } else {
                    this.removeFileButton.setEnabled(true);
                }
            }
        });
        this.fileList.setCellRenderer(new FileNameCellRenderer());
        JScrollPane scrollpane = new JScrollPane(this.fileList);
        scrollpane.setMinimumSize(new Dimension(175, 225));
        scrollpane.setPreferredSize(new Dimension(175, 225));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 1;
        gbc.gridwidth = 3;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(0, 0, 10, 0);
        fileListPanel.add((Component)scrollpane, gbc);
        this.filesButtonsPanel = new JPanel(new GridBagLayout());
        this.addFilesButton = new JButton("Add models");
        this.addFilesButton.setToolTipText(TOOL_TIP_AddFilesButton);
        this.addFilesButton.addActionListener(arg0 -> this.addFiles());
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(0, 0, 0, 5);
        this.filesButtonsPanel.add((Component)this.addFilesButton, gbc);
        this.removeFileButton = new JButton("Remove models");
        this.removeFileButton.setToolTipText(TOOL_TIP_RemoveFilesButton);
        this.removeFileButton.setEnabled(false);
        this.removeFileButton.addActionListener(arg0 -> this.removeSelectedFiles());
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 0, 0, 5);
        this.filesButtonsPanel.add((Component)this.removeFileButton, gbc);
        this.clearFilesButton = new JButton("Clear");
        this.clearFilesButton.setToolTipText(TOOL_TIP_ClearFilesButton);
        this.clearFilesButton.setEnabled(false);
        this.clearFilesButton.addActionListener(e -> {
            this.clearFiles();
            this.enableButtons();
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.anchor = 17;
        this.filesButtonsPanel.add((Component)this.clearFilesButton, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.fill = 2;
        gbc.anchor = 12;
        fileListPanel.add((Component)this.filesButtonsPanel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        gbc.anchor = 12;
        gbc.gridheight = 4;
        gbc.insets = new Insets(10, 5, 0, 5);
        this.topPanel.add((Component)fileListPanel, gbc);
        if (!this.isQueryListEmpty()) {
            fileListPanel.setVisible(false);
        }
    }

    private void addFiles() {
        FileBrowser browser = FileBrowser.constructor("Timed-Arc Petri Nets", "tapn", "xml", lastPath);
        File[] filesArray = browser.openFiles();
        if (filesArray.length > 0) {
            this.undoManager.newEdit();
            for (File file : filesArray) {
                lastPath = file.getParent();
                if (this.files.contains(file)) continue;
                AddFileBatchProcessingCommand c = new AddFileBatchProcessingCommand(this.listModel, file, this.files, this);
                c.redo();
                this.undoManager.addEdit(c);
            }
        }
    }

    private void removeSelectedFiles() {
        this.undoManager.newEdit();
        Iterator<File> iterator = this.fileList.getSelectedValuesList().iterator();
        while (iterator.hasNext()) {
            File o;
            File file = o = iterator.next();
            RemoveFileBatchProcessingCommand c = new RemoveFileBatchProcessingCommand(this.listModel, file, this.files, this);
            c.redo();
            this.undoManager.addEdit(c);
        }
    }

    private void initVerificationOptionsPanel() {
        this.verificationOptionsPanel = new JPanel(new GridBagLayout());
        this.verificationOptionsPanel.setBorder(BorderFactory.createTitledBorder("Override Verification Options for the Batch"));
        this.initOptionsTable();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 12;
        gbc.fill = 2;
        gbc.weighty = 0.0;
        gbc.weightx = 0.0;
        gbc.insets = new Insets(10, 0, 0, 5);
        this.topPanel.add((Component)this.verificationOptionsPanel, gbc);
        if (!this.isQueryListEmpty()) {
            this.verificationOptionsPanel.setVisible(false);
        }
    }

    private void initOptionsTable() {
        this.optionsPanel = new JPanel(new GridBagLayout());
        String[] engineNames = new String[]{"Default", "VerifyPN", "VerifyDTAPN", "VerifyTAPN"};
        this.engines = new JComboBox<String>(engineNames);
        Object[] columnNames = new Object[]{"Run", "Option", "Verification options", "Keep k-bound", "Engine"};
        Object[][] data = new Object[][]{{Boolean.TRUE, 0, "Default", Boolean.TRUE, "Default"}};
        this.optionsTable = new DefaultTableModel(data, columnNames){

            @Override
            public Class<?> getColumnClass(int column) {
                return this.getValueAt(0, column).getClass();
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return column != 1;
            }
        };
        this.verificationTable = new JTable(this.optionsTable);
        this.verificationTable.getTableHeader().setOpaque(true);
        this.verificationTable.getTableHeader().setBackground(Color.white);
        this.verificationTable.setPreferredScrollableViewportSize(this.verificationTable.getPreferredSize());
        this.verificationTable.getColumn(columnNames[0]).setMinWidth(30);
        this.verificationTable.getColumn(columnNames[0]).setMaxWidth(30);
        this.verificationTable.getColumn(columnNames[1]).setMinWidth(50);
        this.verificationTable.getColumn(columnNames[1]).setMaxWidth(50);
        this.verificationTable.getColumn(columnNames[3]).setMinWidth(100);
        this.verificationTable.getColumn(columnNames[3]).setMaxWidth(100);
        this.verificationTable.getColumn(columnNames[4]).setMinWidth(100);
        this.verificationTable.getColumn(columnNames[4]).setMaxWidth(100);
        this.verificationTable.changeSelection(0, 0, false, false);
        this.optionsTable.addTableModelListener(e -> {
            if (e.getType() == 1) {
                this.verificationTable.scrollRectToVisible(this.verificationTable.getCellRect(e.getLastRow(), e.getLastRow(), true));
            }
        });
        this.verificationTable.getColumnModel().getColumn(4).setCellEditor(new DefaultCellEditor(this.engines));
        JScrollPane scrollPane = new JScrollPane(this.verificationTable);
        scrollPane.setVerticalScrollBarPolicy(20);
        scrollPane.setHorizontalScrollBarPolicy(30);
        Dimension scrollPanePrefDims = new Dimension(850, 250);
        Dimension scrollPaneMinDims = new Dimension(850, 100);
        scrollPane.setMinimumSize(scrollPaneMinDims);
        scrollPane.setPreferredSize(scrollPanePrefDims);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 6;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.optionsPanel.add((Component)scrollPane, gbc);
        this.initVerificationButtons();
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(0, 5, 5, 5);
        this.verificationOptionsPanel.add((Component)this.optionsPanel, gbc);
    }

    private void initVerificationButtons() {
        JButton addOptionButton = new JButton("Add");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.optionsPanel.add((Component)addOptionButton, gbc);
        addOptionButton.addActionListener(e -> this.optionsTable.addRow(new Object[]{Boolean.TRUE, this.optionsTable.getRowCount(), "-x 1", Boolean.TRUE, "VerifyPN"}));
        JButton copyOptionButton = new JButton("Copy");
        gbc.gridx = 1;
        this.optionsPanel.add((Component)copyOptionButton, gbc);
        copyOptionButton.addActionListener(e -> {
            int selectedRow = this.verificationTable.getSelectedRow();
            if (selectedRow != -1) {
                this.optionsTable.addRow(new Object[]{this.verificationTable.getValueAt(selectedRow, 0), this.optionsTable.getRowCount(), this.verificationTable.getValueAt(selectedRow, 2), this.verificationTable.getValueAt(selectedRow, 3), this.verificationTable.getValueAt(selectedRow, 4)});
            }
        });
        JButton removeOptionButton = new JButton("Remove");
        gbc.gridx = 2;
        this.optionsPanel.add((Component)removeOptionButton, gbc);
        removeOptionButton.addActionListener(e -> {
            int selectedRow = this.verificationTable.getSelectedRow();
            if (selectedRow != -1) {
                this.optionsTable.removeRow(selectedRow);
                for (int rowIndex = 0; rowIndex < this.verificationTable.getRowCount(); ++rowIndex) {
                    this.verificationTable.setValueAt(rowIndex, rowIndex, 1);
                }
            }
        });
        this.helpDialogPN = new HelpDialog(this, "Options for VerifyPN", Dialog.ModalityType.MODELESS, new VerifyPN(new FileFinder(), new MessengerImpl()).getHelpOptions());
        JButton helpPN = new JButton("Help VerifyPN");
        gbc.gridx = 3;
        this.optionsPanel.add((Component)helpPN, gbc);
        helpPN.setToolTipText(TOOL_TIP_Help);
        helpPN.addActionListener(e -> this.helpDialogPN.setVisible(true));
        this.helpDialogDTAPN = new HelpDialog(this, "Options for VerifyDTAPN", Dialog.ModalityType.MODELESS, new VerifyDTAPN(new FileFinder(), new MessengerImpl()).getHelpOptions());
        JButton helpDTAPN = new JButton("Help VerifyDTAPN");
        gbc.gridx = 4;
        this.optionsPanel.add((Component)helpDTAPN, gbc);
        helpDTAPN.setToolTipText(TOOL_TIP_Help);
        helpDTAPN.addActionListener(e -> this.helpDialogDTAPN.setVisible(true));
        this.helpDialogTAPN = new HelpDialog(this, "Options for VerifyTAPN", Dialog.ModalityType.MODELESS, new VerifyTAPN(new FileFinder(), new MessengerImpl()).getHelpOptions());
        JButton helpTAPN = new JButton("Help VerifyTAPN");
        gbc.gridx = 5;
        this.optionsPanel.add((Component)helpTAPN, gbc);
        helpTAPN.setToolTipText(TOOL_TIP_Help);
        helpTAPN.addActionListener(e -> this.helpDialogTAPN.setVisible(true));
    }

    private void initTimeoutComponents() {
        JLabel timeoutLabel = new JLabel("Timeout (in seconds): ");
        timeoutLabel.setToolTipText(TOOL_TIP_TimeoutLabel);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 0, 5, 0);
        this.monitorPanel.add((Component)timeoutLabel, gbc);
        this.timeoutValue = new CustomJSpinner(30, 5, Integer.MAX_VALUE);
        this.timeoutValue.setToolTipText(TOOL_TIP_TimeoutValue);
        this.timeoutValue.setMaximumSize(new Dimension(70, 30));
        this.timeoutValue.setMinimumSize(new Dimension(70, 30));
        this.timeoutValue.setPreferredSize(new Dimension(70, 30));
        this.timeoutValue.setEnabled(true);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 0, 5, 10);
        this.monitorPanel.add((Component)this.timeoutValue, gbc);
        this.noTimeoutCheckbox = new JCheckBox("Do not use timeout");
        this.noTimeoutCheckbox.setToolTipText(TOOL_TIP_NoTimeoutCheckBox);
        this.noTimeoutCheckbox.setSelected(false);
        this.noTimeoutCheckbox.addActionListener(e -> {
            if (this.noTimeoutCheckbox.isSelected()) {
                this.timeoutValue.setEnabled(false);
            } else {
                this.timeoutValue.setEnabled(true);
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 4;
        gbc.gridy = 1;
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 0, 5, 0);
        this.monitorPanel.add((Component)this.noTimeoutCheckbox, gbc);
    }

    private void initOOMComponents() {
        JLabel oomLabel = new JLabel("Max memory (in MB): ");
        oomLabel.setToolTipText(TOOL_TIP_OOMLabel);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 0, 5, 0);
        this.monitorPanel.add((Component)oomLabel, gbc);
        this.oomValue = new CustomJSpinner(2048, 1, Integer.MAX_VALUE);
        this.oomValue.setToolTipText(TOOL_TIP_OOMValue);
        this.oomValue.setMaximumSize(new Dimension(70, 30));
        this.oomValue.setMinimumSize(new Dimension(70, 30));
        this.oomValue.setPreferredSize(new Dimension(70, 30));
        this.oomValue.setEnabled(true);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 0, 5, 10);
        this.monitorPanel.add((Component)this.oomValue, gbc);
        this.noOOMCheckbox = new JCheckBox("Do not limit memory usage");
        this.noOOMCheckbox.setToolTipText(TOOL_TIP_NoOOMCheckBox);
        this.noOOMCheckbox.setSelected(false);
        this.noOOMCheckbox.addActionListener(e -> {
            if (this.noOOMCheckbox.isSelected()) {
                this.oomValue.setEnabled(false);
            } else {
                this.oomValue.setEnabled(true);
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 4;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 0, 5, 0);
        this.monitorPanel.add((Component)this.noOOMCheckbox, gbc);
    }

    private void disableVerificationOptionsButtons() {
        this.verificationOptionsPanel.setEnabled(false);
        for (Component c : this.verificationOptionsPanel.getComponents()) {
            c.setEnabled(false);
        }
    }

    private void enabledVerificationOptionButtons() {
        this.verificationOptionsPanel.setEnabled(true);
        for (Component c : this.verificationOptionsPanel.getComponents()) {
            c.setEnabled(true);
        }
        this.timeoutValue.setEnabled(this.useTimeout());
    }

    private List<BatchProcessingVerificationOptions> getVerificationOptions() {
        ArrayList<BatchProcessingVerificationOptions> data = new ArrayList<BatchProcessingVerificationOptions>();
        for (int i = 0; i < this.verificationTable.getRowCount(); ++i) {
            ReductionOption reductionOption;
            String engine;
            if (this.verificationTable.getValueAt(i, 0) == Boolean.FALSE) continue;
            switch (engine = (String)this.verificationTable.getValueAt(i, 4)) {
                case "VerifyPN": {
                    reductionOption = ReductionOption.VerifyPN;
                    break;
                }
                case "VerifyDTAPN": {
                    reductionOption = ReductionOption.VerifyDTAPN;
                    break;
                }
                case "VerifyTAPN": {
                    reductionOption = ReductionOption.VerifyTAPN;
                    break;
                }
                default: {
                    reductionOption = null;
                }
            }
            data.add(new BatchProcessingVerificationOptions((Integer)this.verificationTable.getValueAt(i, 1), (String)this.verificationTable.getValueAt(i, 2), (Boolean)this.verificationTable.getValueAt(i, 3), reductionOption));
        }
        return data;
    }

    private void exit() {
        this.terminateBatchProcessing();
        this.rootPane.getParent().setVisible(false);
        if (!this.isQueryListEmpty()) {
            batchProcessingDialog = null;
        }
    }

    private void initResultTablePanel() {
        JPanel resultTablePanel = new JPanel(new GridBagLayout());
        resultTablePanel.setBorder(BorderFactory.createTitledBorder("Results"));
        this.exportButton = new JButton("Export as spreadsheet");
        this.exportButton.setToolTipText(TOOL_TIP_ExportButton);
        this.exportButton.setEnabled(false);
        this.exportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                this.exportResults();
            }

            private void exportResults() {
                String filename = FileBrowser.constructor("CSV file", "csv", lastPath).saveFile("results");
                if (filename != null) {
                    File exportFile = new File(filename);
                    lastPath = exportFile.getParent();
                    BatchProcessingResultsExporter exporter = new BatchProcessingResultsExporter();
                    try {
                        exporter.exportToCSV(BatchProcessingDialog.this.tableModel.getResults(), exportFile);
                    }
                    catch (Exception e1) {
                        JOptionPane.showMessageDialog(TAPAALGUI.getApp(), "An error occurred while trying to export the results. Please try again", "Error Exporting Results", 0);
                        e1.printStackTrace();
                    }
                }
            }
        });
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.insets = new Insets(5, 0, 0, 0);
        gbc.anchor = 16;
        resultTablePanel.add((Component)this.exportButton, gbc);
        this.closeButton = new JButton("Close");
        this.closeButton.setToolTipText(TOOL_TIP_CloseButton);
        this.closeButton.addActionListener(e -> this.exit());
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.insets = new Insets(5, 0, 0, 0);
        gbc.anchor = 14;
        resultTablePanel.add((Component)this.closeButton, gbc);
        this.tableModel = new BatchProcessingResultsTableModel();
        JTable table = new JTable(this.tableModel){

            @Override
            public JToolTip createToolTip() {
                ToolTipManager.sharedInstance().setDismissDelay(Integer.MAX_VALUE);
                ToolTipManager.sharedInstance().setInitialDelay(200);
                return new MultiLineAutoWrappingToolTip();
            }
        };
        ResultTableCellRenderer renderer = new ResultTableCellRenderer(true);
        table.getTableHeader().setBackground(Color.white);
        table.getColumnModel().getColumn(0).setMinWidth(70);
        table.getColumnModel().getColumn(0).setPreferredWidth(70);
        table.getColumnModel().getColumn(0).setMaxWidth(85);
        table.getColumnModel().getColumn(4).setMinWidth(100);
        table.getColumnModel().getColumn(4).setMaxWidth(150);
        table.getColumnModel().getColumn(5).setMinWidth(100);
        table.getColumnModel().getColumn(5).setMaxWidth(150);
        table.getColumn("Option").setCellRenderer(renderer);
        table.getColumn("Model").setCellRenderer(renderer);
        table.getColumn("Query").setCellRenderer(renderer);
        table.getColumn("Result").setCellRenderer(renderer);
        table.getColumn("Verification Time").setCellRenderer(renderer);
        table.getColumn("Memory Usage").setCellRenderer(renderer);
        table.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                String rawOutput;
                JTable source = (JTable)mouseEvent.getSource();
                Point point = mouseEvent.getPoint();
                int row = source.rowAtPoint(point);
                if (mouseEvent.getClickCount() == 2 && source.getSelectedRow() != -1 && (rawOutput = BatchProcessingDialog.this.tableModel.getResult(row).getRawOutput()) != null && !rawOutput.equals("")) {
                    JPanel panel = new JPanel(new GridBagLayout());
                    JOptionPane.showMessageDialog(panel, BatchProcessingDialog.this.createRawQueryPanel(BatchProcessingDialog.this.tableModel.getResult(row).getRawOutput()), "Raw results", 1);
                }
            }
        });
        this.tableModel.addTableModelListener(e -> {
            if (e.getType() == 1) {
                table.scrollRectToVisible(table.getCellRect(e.getLastRow(), e.getLastRow(), true));
            }
        });
        StringComparator comparator = new StringComparator();
        TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(table.getModel());
        for (int i = 0; i < table.getColumnCount(); ++i) {
            sorter.setComparator(i, comparator);
        }
        table.setRowSorter(sorter);
        JScrollPane scrollPane = new JScrollPane(table);
        scrollPane.setVerticalScrollBarPolicy(20);
        scrollPane.setHorizontalScrollBarPolicy(30);
        Dimension scrollPanePrefDims = new Dimension(850, 250);
        Dimension scrollPaneMinDims = new Dimension(850, 100);
        scrollPane.setMinimumSize(scrollPaneMinDims);
        scrollPane.setPreferredSize(scrollPanePrefDims);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        resultTablePanel.add((Component)scrollPane, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(0, 5, 5, 5);
        this.bottomPanel.add((Component)resultTablePanel, gbc);
    }

    private JPanel createRawQueryPanel(String rawOutput) {
        final JPanel fullPanel = new JPanel(new GridBagLayout());
        JTextArea rawQueryLabel = new JTextArea(rawOutput);
        rawQueryLabel.setEditable(false);
        JScrollPane scroll = new JScrollPane(rawQueryLabel);
        scroll.setHorizontalScrollBarPolicy(32);
        scroll.setPreferredSize(new Dimension(640, 400));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        fullPanel.add((Component)scroll, gbc);
        fullPanel.addHierarchyListener(new HierarchyListener(){
            final /* synthetic */ BatchProcessingDialog this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                Window window = SwingUtilities.getWindowAncestor(fullPanel);
                if (window instanceof Dialog) {
                    Dialog dialog = (Dialog)window;
                    dialog.setMinimumSize(dialog.getPreferredSize());
                    if (!dialog.isResizable()) {
                        dialog.setResizable(true);
                    }
                }
            }
        });
        return fullPanel;
    }

    private void initMonitorPanel() {
        this.monitorPanel = new JPanel(new GridBagLayout());
        this.monitorPanel.setBorder(BorderFactory.createTitledBorder("Monitor"));
        this.initOOMComponents();
        this.initTimeoutComponents();
        JLabel file = new JLabel("Net:");
        file.setToolTipText(TOOL_TIP_FileLabel);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.anchor = 17;
        this.monitorPanel.add((Component)file, gbc);
        this.fileStatusLabel = new JLabel("");
        Dimension fileStatusLabelDim = new Dimension(250, 25);
        this.fileStatusLabel.setPreferredSize(fileStatusLabelDim);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.gridwidth = 3;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.anchor = 17;
        this.monitorPanel.add((Component)this.fileStatusLabel, gbc);
        JLabel status = new JLabel("Query:");
        status.setToolTipText(TOOL_TIP_StatusLabel);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.anchor = 17;
        this.monitorPanel.add((Component)status, gbc);
        this.statusLabel = new JLabel("");
        Dimension statusLabelDim = new Dimension(250, 25);
        this.statusLabel.setPreferredSize(statusLabelDim);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        this.monitorPanel.add((Component)this.statusLabel, gbc);
        JLabel memoryLabel = new JLabel("Memory: ");
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 3;
        gbc.anchor = 13;
        gbc.insets = new Insets(0, 5, 0, 0);
        this.monitorPanel.add((Component)memoryLabel, gbc);
        this.memory = new JLabel("");
        Dimension timerLabelDim = new Dimension(70, 25);
        this.memory.setMinimumSize(timerLabelDim);
        this.memory.setPreferredSize(timerLabelDim);
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 3;
        gbc.anchor = 13;
        gbc.insets = new Insets(0, 5, 0, 5);
        this.monitorPanel.add((Component)this.memory, gbc);
        JLabel progress = new JLabel("Progress: ");
        progress.setToolTipText(TOOL_TIP_ProgressLabel);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.anchor = 17;
        this.monitorPanel.add((Component)progress, gbc);
        this.progressLabel = new JLabel("");
        Dimension dim = new Dimension(210, 25);
        this.progressLabel.setPreferredSize(dim);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 4;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 0, 0, 10);
        this.monitorPanel.add((Component)this.progressLabel, gbc);
        JLabel time = new JLabel("Time: ");
        time.setToolTipText(TOOL_TIP_TimeLabel);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 4;
        gbc.anchor = 13;
        gbc.insets = new Insets(0, 5, 0, 0);
        this.monitorPanel.add((Component)time, gbc);
        this.timerLabel = new JLabel("");
        Dimension memoryLabelDim = new Dimension(70, 25);
        this.timerLabel.setMinimumSize(memoryLabelDim);
        this.timerLabel.setPreferredSize(memoryLabelDim);
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 4;
        gbc.anchor = 13;
        gbc.insets = new Insets(0, 5, 0, 5);
        this.monitorPanel.add((Component)this.timerLabel, gbc);
        this.startButton = new JButton("Start");
        this.startButton.setToolTipText(TOOL_TIP_StartButton);
        this.startButton.setMaximumSize(new Dimension(85, 25));
        this.startButton.setMinimumSize(new Dimension(85, 25));
        this.startButton.setPreferredSize(new Dimension(85, 25));
        this.startButton.setEnabled(false);
        this.startButton.addActionListener(e -> this.process());
        gbc = new GridBagConstraints();
        gbc.gridx = 4;
        gbc.gridy = 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 0, 0, 10);
        this.monitorPanel.add((Component)this.startButton, gbc);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setToolTipText(TOOL_TIP_CancelButton);
        this.cancelButton.setMaximumSize(new Dimension(85, 25));
        this.cancelButton.setMinimumSize(new Dimension(85, 25));
        this.cancelButton.setPreferredSize(new Dimension(85, 25));
        this.cancelButton.setEnabled(false);
        this.cancelButton.addActionListener(e -> {
            this.terminateBatchProcessing();
            this.fileStatusLabel.setText("");
            this.statusLabel.setText("Batch processing cancelled");
            this.enableButtons();
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 4;
        gbc.gridy = 3;
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 0, 0, 10);
        this.monitorPanel.add((Component)this.cancelButton, gbc);
        this.skipFileButton = new JButton("Skip");
        this.skipFileButton.setToolTipText(TOOL_TIP_SkipFileButton);
        this.skipFileButton.setMaximumSize(new Dimension(85, 25));
        this.skipFileButton.setMinimumSize(new Dimension(85, 25));
        this.skipFileButton.setPreferredSize(new Dimension(85, 25));
        this.skipFileButton.setEnabled(false);
        this.skipFileButton.addActionListener(e -> this.skipCurrentFile());
        gbc = new GridBagConstraints();
        gbc.gridx = 4;
        gbc.gridy = 4;
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 0, 0, 10);
        this.monitorPanel.add((Component)this.skipFileButton, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.anchor = 18;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(10, 0, 0, 5);
        this.topPanel.add((Component)this.monitorPanel, gbc);
    }

    private void process() {
        this.tableModel.clear();
        this.currentWorker = new BatchProcessingWorker(this.files, this.tableModel, this.getVerificationOptions());
        this.currentWorker.addPropertyChangeListener(evt -> {
            if (evt.getPropertyName().equals("state")) {
                if (evt.getNewValue() == SwingWorker.StateValue.DONE) {
                    this.enableButtons();
                    this.cancelButton.setEnabled(false);
                    this.skipFileButton.setEnabled(false);
                    this.timerLabel.setText("");
                    this.timer.stop();
                    this.stopMemoryTimer();
                    this.timeoutTimer.stop();
                } else if (evt.getNewValue() == SwingWorker.StateValue.STARTED) {
                    this.disableButtonsDuringProcessing();
                    this.cancelButton.setEnabled(true);
                    this.skipFileButton.setEnabled(true);
                    this.memory.setText("");
                    this.timerLabel.setText("");
                    this.progressLabel.setText("0 verification tasks completed");
                }
            }
        });
        this.currentWorker.addBatchProcessingListener(new BatchProcessingListener(){

            @Override
            public void fireVerificationTaskStarted() {
                if (BatchProcessingDialog.this.timer.isRunning()) {
                    BatchProcessingDialog.this.timer.restart();
                } else {
                    BatchProcessingDialog.this.timer.start();
                }
                BatchProcessingDialog.this.startMemoryTimer();
                if (BatchProcessingDialog.this.useTimeout()) {
                    if (BatchProcessingDialog.this.timeoutTimer.isRunning()) {
                        BatchProcessingDialog.this.timeoutTimer.restart();
                    } else {
                        BatchProcessingDialog.this.timeoutTimer.start();
                    }
                }
                BatchProcessingDialog.this.startTimeMs = System.currentTimeMillis();
            }

            @Override
            public void fireVerificationTaskComplete(VerificationTaskCompleteEvent e) {
                if (BatchProcessingDialog.this.timer.isRunning()) {
                    BatchProcessingDialog.this.timer.stop();
                }
                BatchProcessingDialog.this.stopMemoryTimer();
                if (BatchProcessingDialog.this.timeoutTimer.isRunning()) {
                    BatchProcessingDialog.this.timeoutTimer.stop();
                }
                int tasksCompleted = e.verificationTasksCompleted();
                BatchProcessingDialog.this.progressLabel.setText(e.verificationTasksCompleted() + " verification task" + (tasksCompleted > 1 ? "s" : "") + " completed");
                BatchProcessingDialog.this.timerLabel.setText("");
                BatchProcessingDialog.this.memory.setText("");
            }

            @Override
            public void fireStatusChanged(StatusChangedEvent e) {
                BatchProcessingDialog.this.statusLabel.setText(e.status());
            }

            @Override
            public void fireFileChanged(FileChangedEvent e) {
                if (!BatchProcessingDialog.this.isQueryListEmpty()) {
                    BatchProcessingDialog.this.fileStatusLabel.setText(TAPAALGUI.getAppGui().getCurrentTabName());
                } else {
                    BatchProcessingDialog.this.fileStatusLabel.setText(e.fileName());
                }
            }
        });
        if (this.useTimeout()) {
            this.setupTimeoutTimer();
        }
        this.currentWorker.execute();
    }

    private void setupTimeoutTimer() {
        int timeout = (Integer)this.timeoutValue.getValue();
        this.timeoutTimer.setInitialDelay(timeout *= 1000);
        this.timeoutTimer.setDelay(timeout);
        this.timeoutTimer.setRepeats(false);
    }

    private boolean useTimeout() {
        return !this.noTimeoutCheckbox.isSelected();
    }

    private boolean useOOM() {
        return !this.noOOMCheckbox.isSelected();
    }

    private void terminateBatchProcessing() {
        if (this.currentWorker != null && !this.currentWorker.isDone()) {
            boolean cancelled = false;
            do {
                this.currentWorker.notifyExiting();
            } while (!(cancelled = this.currentWorker.cancel(true)));
        }
    }

    private void skipCurrentFile() {
        if (this.currentWorker != null && !this.currentWorker.isDone()) {
            this.currentWorker.notifySkipCurrentVerification();
        }
    }

    private void timeoutCurrentVerificationTask() {
        if (this.currentWorker != null && !this.currentWorker.isDone()) {
            this.currentWorker.notifyTimeoutCurrentVerificationTask();
        }
    }

    private void oomCurrentVerificationTask() {
        if (this.currentWorker != null && !this.currentWorker.isDone()) {
            this.currentWorker.notifyOOMCurrentVerificationTask();
        }
    }

    private void clearFiles() {
        this.undoManager.newEdit();
        for (Object o : this.listModel.toArray()) {
            File file = (File)o;
            RemoveFileBatchProcessingCommand c = new RemoveFileBatchProcessingCommand(this.listModel, file, this.files, this);
            c.redo();
            this.undoManager.addEdit(c);
        }
    }

    private void disableButtonsDuringProcessing() {
        this.addFilesButton.setEnabled(false);
        this.removeFileButton.setEnabled(false);
        this.clearFilesButton.setEnabled(false);
        this.startButton.setEnabled(false);
        this.exportButton.setEnabled(false);
        this.fileList.setEnabled(false);
        this.disableVerificationOptionsButtons();
    }

    public void enableButtons() {
        this.fileList.setEnabled(true);
        this.addFilesButton.setEnabled(true);
        if (!this.isQueryListEmpty() || this.listModel.size() > 0) {
            this.clearFilesButton.setEnabled(true);
            this.startButton.setEnabled(true);
        } else {
            this.clearFilesButton.setEnabled(false);
            this.startButton.setEnabled(false);
        }
        this.removeFileButton.setEnabled(this.fileList.getSelectedIndices().length > 0);
        this.exportButton.setEnabled(this.tableModel.getRowCount() > 0);
        this.enabledVerificationOptionButtons();
    }

    private void makeShortcuts() {
        int shortcutkey = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        ActionMap am = this.splitpane.getActionMap();
        am.put("undo", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BatchProcessingDialog.this.undoManager.undo();
            }
        });
        am.put("redo", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BatchProcessingDialog.this.undoManager.redo();
            }
        });
        InputMap im = this.splitpane.getInputMap(2);
        im.put(KeyStroke.getKeyStroke(90, shortcutkey), "undo");
        im.put(KeyStroke.getKeyStroke(89, shortcutkey), "redo");
    }

    public class HelpDialog
    extends JDialog {
        private JPanel content;
        private JScrollPane scroll;
        private JTextArea helpInfo;

        public HelpDialog(JDialog dialog, String string, Dialog.ModalityType modal, String text) {
            super((Window)dialog, string, modal);
            this.initComponents(text);
            this.setLocationRelativeTo(BatchProcessingDialog.this);
            this.setResizable(true);
            this.pack();
            this.setLocationByPlatform(true);
        }

        private void initComponents(String text) {
            this.content = new JPanel(new GridBagLayout());
            this.helpInfo = new JTextArea(text);
            this.helpInfo.setEditable(false);
            this.scroll = new JScrollPane(this.helpInfo);
            this.scroll.setHorizontalScrollBarPolicy(32);
            this.scroll.setMinimumSize(new Dimension(640, 400));
            this.scroll.setPreferredSize(new Dimension(640, 400));
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.fill = 1;
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.anchor = 17;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            this.content.add((Component)this.scroll, gbc);
            this.getContentPane().setLayout(new GridBagLayout());
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.fill = 1;
            gbc.anchor = 17;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            this.getContentPane().add((Component)this.content, gbc);
        }
    }

    private class ResultTableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        Border unselectedBorder = null;
        Border selectedBorder = null;
        boolean isBordered = true;

        public ResultTableCellRenderer(boolean isBordered) {
            this.isBordered = isBordered;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (this.isBordered) {
                if (isSelected) {
                    this.setBackground(table.getSelectionBackground());
                    this.setForeground(table.getSelectionForeground());
                    if (this.selectedBorder == null) {
                        this.selectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, table.getSelectionBackground());
                    }
                    this.setBorder(this.selectedBorder);
                } else {
                    boolean isResultColumn = table.getColumnName(column).equals("Result");
                    boolean isQueryColumn = table.getColumnName(column).equals("Query");
                    if (value != null) {
                        if (isResultColumn && value.toString().equals(BatchProcessingDialog.SATISFIED_STRING) || value.toString().equals(BatchProcessingDialog.SATISFIED_SOUNDNESS_STRING) || value.toString().equals(BatchProcessingDialog.SATISFIED_STRONG_SOUNDNESS_STRING) || isQueryColumn && value.toString().equals("TRUE") || isResultColumn && value.toString().contains(BatchProcessingDialog.PROBABILITY_STRING)) {
                            this.setBackground(new Color(91, 255, 91));
                        } else if (isResultColumn && (value.toString().equals(BatchProcessingDialog.NOT_SATISFIED_STRING) || value.toString().equals(BatchProcessingDialog.NOT_SATISFIED_STRING_STRONG_SOUNDNESS) || value.toString().equals(BatchProcessingDialog.NOT_SATISFIED_STRING_SOUNDNESS)) || isQueryColumn && value.toString().equals("FALSE")) {
                            this.setBackground(new Color(255, 91, 91));
                        } else if (isResultColumn && value.toString().contains(BatchProcessingDialog.INCONCLUSIVE_STRING)) {
                            String[] split = value.toString().split(BatchProcessingDialog.INCONCLUSIVE_STRING);
                            if (split.length > 0) {
                                value = split[0];
                            }
                            this.setBackground(new Color(255, 255, 120));
                        } else {
                            this.setBackground(table.getBackground());
                        }
                    } else {
                        this.setBackground(table.getBackground());
                    }
                    this.setForeground(table.getForeground());
                    if (this.unselectedBorder == null) {
                        this.unselectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, table.getBackground());
                    }
                    this.setBorder(this.unselectedBorder);
                }
            }
            this.setEnabled(table.isEnabled());
            this.setFont(table.getFont());
            this.setOpaque(true);
            if (value != null) {
                if (value instanceof TAPNQuery) {
                    TAPNQuery newQuery = (TAPNQuery)value;
                    this.setToolTipText(this.generateTooltipTextFromQuery(newQuery));
                    this.setText(newQuery.getName());
                } else if (table.getColumnName(column).equals("Verification Time") || table.getColumnName(column).equals("Option") || table.getColumnName(column).equals("Memory Usage") || table.getColumnName(column).equals("Result")) {
                    this.setText(value.toString());
                    Point mousePos = table.getMousePosition();
                    BatchProcessingVerificationResult result = null;
                    if (mousePos != null) {
                        result = ((BatchProcessingResultsTableModel)table.getModel()).getResult(table.rowAtPoint(mousePos));
                    }
                    if (table.getColumnName(column).equals("Verification Time")) {
                        this.setToolTipText(result != null ? this.generateStatsToolTipText(result) : value.toString());
                    } else if (table.getColumnName(column).equals("Memory Usage")) {
                        this.setToolTipText(result != null ? this.generateMemoryToolTipText(result) : value.toString());
                    } else if (table.getColumnName(column).equals("Result")) {
                        this.setToolTipText(this.generateResultToolTipText(result, value));
                    } else {
                        this.setToolTipText(result != null ? this.generateReductionString(result.query(), result.getOptionNumber()) : value.toString());
                    }
                } else {
                    this.setToolTipText(value.toString());
                    this.setText(value.toString());
                }
            } else {
                this.setToolTipText("");
                this.setText("");
            }
            return this;
        }

        private String generateStatsToolTipText(BatchProcessingVerificationResult result) {
            return "Verification Time: " + (double)result.verificationTimeInMs() / 1000.0 + " s";
        }

        private String generateMemoryToolTipText(BatchProcessingVerificationResult result) {
            return "Peak memory usage (estimate): " + result.verificationMemory();
        }

        private String generateResultToolTipText(BatchProcessingVerificationResult result, Object value) {
            if (result == null || result.getRawOutput() == null) {
                return value.toString();
            }
            return result.getRawOutput();
        }

        private String generateTooltipTextFromQuery(TAPNQuery query) {
            return "Query Property:\n" + query.getProperty().toString();
        }

        private String generateReductionString(TAPNQuery query, int optionNumber) {
            StringBuilder s = new StringBuilder();
            if (query != null) {
                s.append("Reduction: \n");
                if (query.getReductionOption() == ReductionOption.COMBI) {
                    s.append(BatchProcessingDialog.name_COMBI);
                } else if (query.getReductionOption() == ReductionOption.STANDARD) {
                    s.append(BatchProcessingDialog.name_STANDARD);
                } else if (query.getReductionOption() == ReductionOption.OPTIMIZEDSTANDARD) {
                    s.append(BatchProcessingDialog.name_OPTIMIZEDSTANDARD);
                } else if (query.getReductionOption() == ReductionOption.BROADCAST) {
                    s.append(BatchProcessingDialog.name_BROADCAST);
                } else if (query.getReductionOption() == ReductionOption.DEGREE2BROADCAST) {
                    s.append(BatchProcessingDialog.name_BROADCASTDEG2);
                } else if (query.getReductionOption() == ReductionOption.VerifyTAPN) {
                    s.append(BatchProcessingDialog.name_verifyTAPN);
                    s.append("\n\n");
                    s.append("Discrete Inclusion: ");
                    s.append(query.discreteInclusion() ? "Yes" : "No");
                    if (query.discreteInclusion()) {
                        s.append("\n\n");
                        s.append("Discrete Inclusion Places:\n");
                        s.append(this.generateListOfInclusionPlaces(query));
                    }
                } else if (query.getReductionOption() == ReductionOption.VerifyDTAPN) {
                    if (query.useTimeDarts() && query.usePTrie()) {
                        s.append(BatchProcessingDialog.name_verifyTAPNDiscreteVerificationTimeDartPTrie);
                    } else if (query.useTimeDarts()) {
                        s.append(BatchProcessingDialog.name_verifyTAPNDiscreteVerificationTimeDart);
                    } else if (query.usePTrie()) {
                        s.append(BatchProcessingDialog.name_verifyTAPNDiscreteVerificationPTrie);
                    } else {
                        s.append(BatchProcessingDialog.name_verifyTAPNDiscreteVerificationNone);
                    }
                } else if (query.getReductionOption() == ReductionOption.VerifyPN || query.getReductionOption() == ReductionOption.VerifyPNApprox || query.getReductionOption() == ReductionOption.VerifyPNReduce) {
                    s.append(BatchProcessingDialog.name_UNTIMED);
                } else {
                    s.append(BatchProcessingDialog.name_BROADCAST);
                }
                s.append("\n\nEngine flags: \n");
                Object options = (String)BatchProcessingDialog.this.verificationTable.getValueAt(optionNumber, 2);
                if (((String)options).equalsIgnoreCase("default")) {
                    s.append(BatchProcessingDialog.this.currentWorker.getVerificationOptionsFromQuery(query).toString());
                } else {
                    if (((Boolean)BatchProcessingDialog.this.verificationTable.getValueAt(optionNumber, 3)).booleanValue()) {
                        Pattern pattern = Pattern.compile("\\s*(-k|--k-bound)\\s*(\\d+)\\s*", 2);
                        Matcher matcher = pattern.matcher((CharSequence)options);
                        if (matcher.find()) {
                            options = ((String)options).replaceFirst(matcher.group(), matcher.group(1) + " " + query.getCapacity() + " ");
                        } else {
                            options = (String)options + " -k ";
                            options = (String)options + query.getCapacity();
                        }
                    }
                    s.append((String)options);
                }
            }
            return s.toString();
        }

        private String generateListOfInclusionPlaces(TAPNQuery query) {
            if (query.inclusionPlaces().inclusionOption() == InclusionPlaces.InclusionPlacesOption.AllPlaces) {
                return "*ALL*";
            }
            List<TimedPlace> incPlace = query.inclusionPlaces().inclusionPlaces();
            if (incPlace.isEmpty()) {
                return "*NONE*";
            }
            StringBuilder s = new StringBuilder();
            boolean first = true;
            for (TimedPlace p : incPlace) {
                if (!first) {
                    s.append(", ");
                }
                s.append(p.toString());
                if (!first) continue;
                first = false;
            }
            return s.toString();
        }
    }
}

