/*
 * Decompiled with CFR 0.152.
 */
package net.tapaal.gui.petrinet.animation;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import net.tapaal.gui.petrinet.TAPNLens;
import net.tapaal.gui.petrinet.Template;
import net.tapaal.gui.petrinet.animation.DelayEnabledTransitionControl;
import pipe.gui.TAPAALGUI;
import pipe.gui.petrinet.animation.AnimationSettingsDialog;
import pipe.gui.petrinet.animation.Animator;
import pipe.gui.petrinet.animation.EnabledTransitionsList;
import pipe.gui.petrinet.animation.SimulationControl;
import pipe.gui.petrinet.graphicElements.Transition;

public class TransitionFiringComponent
extends JPanel {
    private final EnabledTransitionsList enabledTransitionsList;
    private final JButton fireButton;
    private final JButton settingsButton;
    private final TAPNLens lens;
    public static final String FIRE_BUTTON_DEACTIVATED_TOOL_TIP = "No transitions are enabled";
    public static final String FIRE_BUTTON_ENABLED_TOOL_TIP = "Press to fire the selected transition";
    public static final String SIMULATE_DEACTIVATED_TOOL_TIP = "Not able to simulate from this marking, no transitions are enabled";
    public static final String SIMULATE_ACTIVATED_TOOL_TIP = "Do a random simulation of the net";

    public TransitionFiringComponent(boolean showDelayEnabledTransitions, TAPNLens lens, Animator animator) {
        super(new GridBagLayout());
        this.enabledTransitionsList = new EnabledTransitionsList(animator);
        this.lens = lens;
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Enabled Transitions"), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
        this.setToolTipText("List of currently enabled transitions (double click a transition to fire it)");
        this.enabledTransitionsList.setPreferredSize(new Dimension(this.enabledTransitionsList.getPreferredSize().width, this.enabledTransitionsList.getMinimumSize().height));
        this.settingsButton = new JButton("Settings");
        this.settingsButton.setPreferredSize(new Dimension(0, this.settingsButton.getPreferredSize().height));
        this.settingsButton.addActionListener(e -> AnimationSettingsDialog.showAnimationSettings(lens));
        this.fireButton = new JButton("Delay & Fire");
        this.fireButton.setPreferredSize(new Dimension(0, this.fireButton.getPreferredSize().height));
        this.fireButton.addActionListener(e -> {
            if (SimulationControl.getInstance().randomSimulation() && TAPAALGUI.getAppGui().isShowingDelayEnabledTransitions()) {
                SimulationControl.startSimulation();
            } else {
                this.fireSelectedTransition();
            }
        });
        this.fireButton.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    if (SimulationControl.getInstance().randomSimulation()) {
                        SimulationControl.startSimulation();
                    } else {
                        TransitionFiringComponent.this.fireSelectedTransition();
                    }
                }
            }
        });
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 1;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        this.add((Component)this.enabledTransitionsList, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.anchor = 16;
        this.add((Component)this.settingsButton, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.anchor = 16;
        this.add((Component)this.fireButton, gbc);
        this.showDelayEnabledTransitions(showDelayEnabledTransitions);
    }

    public void updateFireButton() {
        if (SimulationControl.getInstance().isRunning()) {
            this.fireButton.setEnabled(false);
            return;
        }
        this.fireButton.setEnabled(true);
        if (TAPAALGUI.getAppGui().isShowingDelayEnabledTransitions() && SimulationControl.getInstance().randomSimulation()) {
            this.fireButton.setText("Simulate");
            if (this.enabledTransitionsList.getNumberOfTransitions() == 0) {
                this.fireButton.setEnabled(false);
                this.fireButton.setToolTipText(SIMULATE_DEACTIVATED_TOOL_TIP);
            } else {
                this.fireButton.setEnabled(true);
                this.fireButton.setToolTipText(SIMULATE_ACTIVATED_TOOL_TIP);
            }
        } else {
            this.fireButton.setText(TAPAALGUI.getAppGui().isShowingDelayEnabledTransitions() ? "Delay & Fire" : "Fire");
            if (!this.lens.isTimed()) {
                this.fireButton.setText("Fire");
            }
            if (this.enabledTransitionsList.getNumberOfTransitions() == 0) {
                this.fireButton.setEnabled(false);
                this.fireButton.setToolTipText(FIRE_BUTTON_DEACTIVATED_TOOL_TIP);
            } else {
                this.fireButton.setEnabled(true);
                this.fireButton.setToolTipText(FIRE_BUTTON_ENABLED_TOOL_TIP);
            }
        }
    }

    public void addTransition(Template template, Transition transition) {
        this.enabledTransitionsList.addTransition(template, transition);
    }

    public void startReInit() {
        this.enabledTransitionsList.startReInit();
    }

    public void reInitDone() {
        this.updateFireButton();
        this.enabledTransitionsList.reInitDone();
    }

    public DelayEnabledTransitionControl getDelayEnabledTransitionControl() {
        return DelayEnabledTransitionControl.getInstance();
    }

    public void showDelayEnabledTransitions(boolean enable) {
        this.settingsButton.setVisible(enable);
        this.updateFireButton();
    }

    public void fireSelectedTransition() {
        this.enabledTransitionsList.fireSelectedTransition();
    }
}

