/*
 * Decompiled with CFR 0.152.
 */
package net.tapaal.gui.petrinet.animation;

import dk.aau.cs.model.tapn.TimedInputArc;
import dk.aau.cs.model.tapn.TimedToken;
import dk.aau.cs.model.tapn.TimedTransition;
import dk.aau.cs.model.tapn.TransportArc;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.tapaal.gui.petrinet.animation.ArcTokenSelector;

public class AnimationTokenSelectDialog
extends JPanel {
    TimedTransition transition;
    public final ArrayList<ArcTokenSelector> arcTokenSelectors = new ArrayList();
    private final JPanel namePanel;
    private final JButton okButton;
    private boolean cancelled = true;

    public boolean cancelled() {
        return this.cancelled;
    }

    public AnimationTokenSelectDialog(TimedTransition transition) {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        this.transition = transition;
        this.namePanel = new JPanel(new FlowLayout());
        this.namePanel.add(new JLabel("<html>Select tokens to fire transition <b>" + transition.name() + "</b></html>"));
        this.add((Component)this.namePanel, c);
        JPanel presetPanelContainer = new JPanel(new FlowLayout());
        c.gridx = 0;
        c.gridy = 1;
        this.add((Component)presetPanelContainer, c);
        if (transition.isShared()) {
            for (TimedTransition trans : transition.sharedTransition().transitions()) {
                this.createDropDownsForTransition(trans, presetPanelContainer);
            }
        } else {
            this.createDropDownsForTransition(transition, presetPanelContainer);
        }
        c.gridx = 0;
        c.gridy = 2;
        this.okButton = new JButton();
        this.okButton.setText("OK");
        this.okButton.setMaximumSize(new Dimension(75, 25));
        this.okButton.setMinimumSize(new Dimension(75, 25));
        this.okButton.setPreferredSize(new Dimension(75, 25));
        this.okButton.addActionListener(evt -> {
            this.cancelled = false;
            this.exit();
        });
        this.updateOkButton();
        this.add((Component)this.okButton, c);
    }

    private void createDropDownsForTransition(TimedTransition transition, JPanel presetPanelContainer) {
        JPanel tokenPanel;
        for (TimedInputArc timedInputArc : transition.getInputArcs()) {
            tokenPanel = this.createDropDownForArc(timedInputArc.source().toString(), timedInputArc.getElligibleTokens(), timedInputArc.getWeight().value());
            presetPanelContainer.add(tokenPanel);
        }
        for (TransportArc transportArc : transition.getTransportArcsGoingThrough()) {
            tokenPanel = this.createDropDownForArc(transportArc.source().toString(), transportArc.getElligibleTokens(), transportArc.getWeight().value());
            presetPanelContainer.add(tokenPanel);
        }
    }

    private JPanel createDropDownForArc(String placeName, List<TimedToken> elligibleTokens, int weight) {
        ArcTokenSelector tokenSelector = new ArcTokenSelector(placeName, elligibleTokens, weight);
        tokenSelector.addArcTokenSelectorListener(e -> this.updateOkButton());
        this.arcTokenSelectors.add(tokenSelector);
        return tokenSelector;
    }

    private void updateOkButton() {
        boolean enable = true;
        for (ArcTokenSelector selector : this.arcTokenSelectors) {
            enable = enable && selector.allChosen();
        }
        this.okButton.setEnabled(enable);
    }

    private void exit() {
        this.getRootPane().getParent().setVisible(false);
    }

    public List<TimedToken> getTokens() {
        if (this.cancelled) {
            return null;
        }
        ArrayList<TimedToken> tokens = new ArrayList<TimedToken>();
        for (ArcTokenSelector selector : this.arcTokenSelectors) {
            tokens.addAll(selector.getSelected());
        }
        return tokens;
    }
}

