/*
 * Decompiled with CFR 0.152.
 */
package net.tapaal.gui.petrinet;

import dk.aau.cs.model.tapn.TimedArcPetriNet;
import pipe.gui.canvas.Zoomer;
import pipe.gui.petrinet.dataLayer.DataLayer;

public class Template {
    private final TimedArcPetriNet net;
    private final DataLayer guiModel;
    private final Zoomer zoomer;
    private boolean hasPositionalInfo = false;

    public Template(TimedArcPetriNet net, DataLayer guiModel, Zoomer zoomer) {
        this.net = net;
        this.guiModel = guiModel;
        this.zoomer = zoomer;
    }

    public String toString() {
        return this.net.toString();
    }

    public DataLayer guiModel() {
        return this.guiModel;
    }

    public TimedArcPetriNet model() {
        return this.net;
    }

    public boolean isActive() {
        return this.net.isActive();
    }

    public void setActive(boolean isActive) {
        this.net.setActive(isActive);
    }

    public Template copy() {
        TimedArcPetriNet tapn = this.net.copy();
        tapn.setName(tapn.name() + "Copy");
        return new Template(tapn, this.guiModel.copy(tapn), new Zoomer(this.zoomer.getPercent()));
    }

    public Zoomer zoomer() {
        return this.zoomer;
    }

    public boolean getHasPositionalInfo() {
        return this.hasPositionalInfo;
    }

    public void setHasPositionalInfo(boolean positionalInfo) {
        this.hasPositionalInfo = positionalInfo;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Template) {
            Template other = (Template)obj;
            if (this.net.equals(other.net)) {
                return true;
            }
        }
        return false;
    }
}

