/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.verification.observations.expressions;

import dk.aau.cs.model.tapn.TimedArcPetriNet;
import dk.aau.cs.model.tapn.TimedArcPetriNetNetwork;
import dk.aau.cs.model.tapn.TimedPlace;
import dk.aau.cs.verification.observations.expressions.ObsExpression;
import dk.aau.cs.verification.observations.expressions.ObsLeaf;

public class ObsPlace
extends ObsLeaf {
    private final Object template;
    private final TimedPlace place;

    public ObsPlace(Object template, TimedPlace place) {
        this.template = template;
        this.place = place;
    }

    public ObsPlace(String templateName, String placeName, TimedArcPetriNetNetwork network) {
        if (templateName.equals("Shared")) {
            this.template = templateName;
            this.place = network.getSharedPlaceByName(placeName);
        } else {
            TimedArcPetriNet net = network.getTAPNByName(templateName);
            this.template = net;
            this.place = net.getPlaceByName(placeName);
        }
    }

    public String toString() {
        return String.valueOf(this.template) + "." + this.place.name();
    }

    @Override
    public String toXml() {
        return "<place>" + String.valueOf(this.template) + "_" + this.place.name() + "</place>";
    }

    @Override
    public ObsExpression deepCopy() {
        ObsPlace copy = new ObsPlace(this.template, this.place);
        copy.setParent(this.parent);
        return copy;
    }

    @Override
    public boolean isPlace() {
        return true;
    }
}

