/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.verification.batchProcessing;

import dk.aau.cs.Messenger;
import dk.aau.cs.TCTL.visitors.RenameAllPlacesVisitor;
import dk.aau.cs.TCTL.visitors.RenameAllTransitionsVisitor;
import dk.aau.cs.approximation.ApproximationWorker;
import dk.aau.cs.io.batchProcessing.BatchProcessingModelLoader;
import dk.aau.cs.io.batchProcessing.LoadedBatchProcessingModel;
import dk.aau.cs.model.tapn.TAPNQuery;
import dk.aau.cs.model.tapn.TimedArcPetriNet;
import dk.aau.cs.model.tapn.simulation.TimedArcPetriNetTrace;
import dk.aau.cs.translations.ReductionOption;
import dk.aau.cs.util.MemoryMonitor;
import dk.aau.cs.util.Require;
import dk.aau.cs.util.Tuple;
import dk.aau.cs.util.UnsupportedModelException;
import dk.aau.cs.util.UnsupportedQueryException;
import dk.aau.cs.verification.ModelChecker;
import dk.aau.cs.verification.NameMapping;
import dk.aau.cs.verification.NullStats;
import dk.aau.cs.verification.QueryResult;
import dk.aau.cs.verification.QueryType;
import dk.aau.cs.verification.Stats;
import dk.aau.cs.verification.TAPNComposer;
import dk.aau.cs.verification.UPPAAL.Verifyta;
import dk.aau.cs.verification.UPPAAL.VerifytaOptions;
import dk.aau.cs.verification.VerificationOptions;
import dk.aau.cs.verification.VerificationResult;
import dk.aau.cs.verification.VerifyTAPN.ModelReduction;
import dk.aau.cs.verification.VerifyTAPN.VerifyDTAPN;
import dk.aau.cs.verification.VerifyTAPN.VerifyDTAPNOptions;
import dk.aau.cs.verification.VerifyTAPN.VerifyPN;
import dk.aau.cs.verification.VerifyTAPN.VerifyPNOptions;
import dk.aau.cs.verification.VerifyTAPN.VerifyTAPN;
import dk.aau.cs.verification.VerifyTAPN.VerifyTAPNOptions;
import dk.aau.cs.verification.batchProcessing.BatchProcessingListener;
import dk.aau.cs.verification.batchProcessing.BatchProcessingVerificationOptions;
import dk.aau.cs.verification.batchProcessing.BatchProcessingVerificationResult;
import dk.aau.cs.verification.batchProcessing.FileChangedEvent;
import dk.aau.cs.verification.batchProcessing.StatusChangedEvent;
import dk.aau.cs.verification.batchProcessing.VerificationTaskCompleteEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.SwingWorker;
import net.tapaal.gui.petrinet.dialog.BatchProcessingResultsTableModel;
import net.tapaal.gui.petrinet.verification.TAPNQuery;
import net.tapaal.gui.petrinet.widgets.QueryPane;
import pipe.gui.FileFinder;
import pipe.gui.MessengerImpl;
import pipe.gui.TAPAALGUI;

public class BatchProcessingWorker
extends SwingWorker<Void, BatchProcessingVerificationResult> {
    private final List<File> files;
    private final BatchProcessingResultsTableModel tableModel;
    private final List<BatchProcessingVerificationOptions> options;
    private boolean isExiting = false;
    private ModelChecker modelChecker;
    final List<BatchProcessingListener> listeners = new ArrayList<BatchProcessingListener>();
    private boolean skippingCurrentVerification = false;
    private boolean timeoutCurrentVerification = false;
    private boolean oomCurrentVerification = false;
    private int verificationTasksCompleted;
    private LoadedBatchProcessingModel model;
    private boolean isSoundnessCheck;
    private boolean isModelCheckOnly;
    private ArrayList<File> filesProcessed;

    public BatchProcessingWorker(List<File> files, BatchProcessingResultsTableModel tableModel, List<BatchProcessingVerificationOptions> options) {
        this.files = files;
        this.tableModel = tableModel;
        this.options = options;
    }

    public synchronized void notifyExiting() {
        this.isExiting = true;
    }

    private synchronized boolean exiting() {
        return this.isExiting;
    }

    public synchronized void notifySkipCurrentVerification() {
        this.skippingCurrentVerification = true;
        if (this.modelChecker != null) {
            this.modelChecker.kill();
        }
    }

    public synchronized void notifyTimeoutCurrentVerificationTask() {
        this.timeoutCurrentVerification = true;
        if (this.modelChecker != null) {
            this.modelChecker.kill();
        }
    }

    public synchronized void notifyOOMCurrentVerificationTask() {
        this.oomCurrentVerification = true;
        if (this.modelChecker != null) {
            this.modelChecker.kill();
        }
    }

    @Override
    protected Void doInBackground() throws Exception {
        this.isSoundnessCheck = false;
        this.filesProcessed = new ArrayList();
        for (File file : this.files) {
            LoadedBatchProcessingModel model;
            this.fireFileChanged(file.getName());
            this.model = model = this.loadModel(file);
            if (model == null) continue;
            Tuple<TimedArcPetriNet, NameMapping> composedModel = this.composeModel(model);
            for (net.tapaal.gui.petrinet.verification.TAPNQuery query : model.queries()) {
                if (this.exiting()) {
                    return null;
                }
                if (this.isModelCheckOnly && this.filesProcessed.contains(file)) continue;
                this.processQuery(file, composedModel, query);
            }
        }
        this.fireFileChanged("");
        this.fireStatusChanged("");
        return null;
    }

    private void processQuery(File file, Tuple<TimedArcPetriNet, NameMapping> composedModel, net.tapaal.gui.petrinet.verification.TAPNQuery queryToVerify) throws Exception {
        if (!queryToVerify.isActive()) {
            String message = "Skipped - query is disabled because it contains propositions involving places from a deactivated component";
            this.publishResult(file.getName(), queryToVerify, message, 0L, null, new NullStats(), -1);
        }
        for (BatchProcessingVerificationOptions option : this.options) {
            this.processQuery(file, composedModel, queryToVerify, option);
        }
        this.fireVerificationTaskComplete();
    }

    private void processQuery(File file, Tuple<TimedArcPetriNet, NameMapping> composedModel, net.tapaal.gui.petrinet.verification.TAPNQuery queryToVerify, BatchProcessingVerificationOptions option) throws Exception {
        VerificationResult<TimedArcPetriNetTrace> verificationResult = this.verifyQuery(file, composedModel, queryToVerify, option);
        if (verificationResult != null) {
            this.processVerificationResult(file, queryToVerify, verificationResult, option.getNumber());
        }
    }

    private Tuple<TimedArcPetriNet, NameMapping> composeModel(LoadedBatchProcessingModel model) {
        TAPNComposer composer = new TAPNComposer(new Messenger(){

            @Override
            public void displayInfoMessage(String message) {
            }

            @Override
            public void displayInfoMessage(String message, String title) {
            }

            @Override
            public void displayErrorMessage(String message) {
            }

            @Override
            public void displayErrorMessage(String message, String title) {
            }

            @Override
            public void displayWrappedErrorMessage(String message, String title) {
            }
        }, false);
        return composer.transformModel(model.network());
    }

    private VerificationResult<TimedArcPetriNetTrace> verifyQuery(File file, Tuple<TimedArcPetriNet, NameMapping> composedModel, net.tapaal.gui.petrinet.verification.TAPNQuery query, BatchProcessingVerificationOptions option) throws Exception {
        VerificationResult<TimedArcPetriNetTrace> verificationResult;
        this.fireStatusChanged(query.getName());
        try {
            verificationResult = this.verify(composedModel, query, option);
        }
        catch (UnsupportedModelException e) {
            String message = "Skipped - model not supported by the verification method";
            this.publishResult(file.getName(), query, message, 0L, null, new NullStats(), option.getNumber());
            return null;
        }
        catch (UnsupportedQueryException e) {
            if (e.getMessage().toLowerCase().contains("discrete inclusion")) {
                String message = "Skipped - discrete inclusion is enabled and query is not upward closed";
                this.publishResult(file.getName(), query, message, 0L, null, new NullStats(), option.getNumber());
            } else {
                String message = "Skipped - query not supported by the verification method";
                this.publishResult(file.getName(), query, message, 0L, null, new NullStats(), option.getNumber());
            }
            return null;
        }
        return verificationResult;
    }

    private void processVerificationResult(File file, net.tapaal.gui.petrinet.verification.TAPNQuery query, VerificationResult<TimedArcPetriNetTrace> verificationResult, int optionNumber) {
        if (this.skippingCurrentVerification) {
            this.publishResult(file.getName(), query, "Skipped - by the user", verificationResult.verificationTime(), verificationResult.getRawOutput(), new NullStats(), optionNumber);
            this.skippingCurrentVerification = false;
        } else if (this.timeoutCurrentVerification) {
            this.publishResult(file.getName(), query, "Skipped - due to timeout", verificationResult.verificationTime(), verificationResult.getRawOutput(), new NullStats(), optionNumber);
            this.timeoutCurrentVerification = false;
        } else if (this.oomCurrentVerification) {
            this.publishResult(file.getName(), query, "Skipped - due to OOM", verificationResult.verificationTime(), verificationResult.getRawOutput(), new NullStats(), optionNumber);
            this.oomCurrentVerification = false;
        } else if (!verificationResult.error()) {
            String queryResult;
            if (verificationResult.getQueryResult().isApproximationInconclusive()) {
                queryResult = "Inconclusive";
            } else if (verificationResult.getQueryResult().isQuantitative()) {
                queryResult = verificationResult.getQueryResult().getProbabilityString();
            } else {
                String string = queryResult = verificationResult.getQueryResult().isQuerySatisfied() ? "Satisfied" : "Not Satisfied";
                if (this.isSoundnessCheck && !verificationResult.isQuerySatisfied()) {
                    queryResult = "Not Sound";
                }
                if (this.isSoundnessCheck && verificationResult.isQuerySatisfied()) {
                    queryResult = query.getWorkflowMode() == TAPNQuery.WorkflowMode.WORKFLOW_STRONG_SOUNDNESS ? "Strongly Sound" : "Sound";
                }
            }
            if (this.isInconclusive(verificationResult.getQueryResult(), verificationResult.getUnfoldedModel().value1())) {
                queryResult = "Inconclusive";
            }
            if (query.discreteInclusion() && !verificationResult.isBounded() && (query.queryType().equals((Object)QueryType.EF) && !verificationResult.getQueryResult().isQuerySatisfied() || query.queryType().equals((Object)QueryType.AG) && verificationResult.getQueryResult().isQuerySatisfied())) {
                queryResult = "Inconclusive";
            }
            if (query.getReductionOption().equals((Object)ReductionOption.VerifyPNApprox) && (query.queryType().equals((Object)QueryType.EF) && verificationResult.getQueryResult().isQuerySatisfied() || query.queryType().equals((Object)QueryType.AG) && !verificationResult.getQueryResult().isQuerySatisfied())) {
                queryResult = "Inconclusive";
            }
            this.publishResult(file.getName(), query, queryResult, verificationResult.verificationTime(), verificationResult.getRawOutput(), verificationResult.stats(), optionNumber);
        } else if (this.isSoundnessCheck && verificationResult.error()) {
            String message = "Skipped - model is not a workflow net. Try running workflow analysis from the menu.";
            this.publishResult(file.getName(), query, message, verificationResult.verificationTime(), verificationResult.getRawOutput(), new NullStats(), optionNumber);
        } else {
            this.publishResult(file.getName(), query, "Error during verification", verificationResult.verificationTime(), verificationResult.getRawOutput(), new NullStats(), optionNumber);
        }
    }

    private boolean isInconclusive(QueryResult result, TimedArcPetriNet net) {
        return result.getQuery().getExtraTokens() + net.marking().size() < result.boundednessAnalysis().usedTokens() || result.toString().contains("Only markings with at most");
    }

    private void publishResult(String fileName, net.tapaal.gui.petrinet.verification.TAPNQuery query, String verificationResult, long verificationTime, String rawOutput, Stats stats, int optionNumber) {
        BatchProcessingVerificationResult result = QueryPane.getTemporaryFile() != null && fileName.equals(QueryPane.getTemporaryFile().getName()) ? new BatchProcessingVerificationResult(TAPAALGUI.getAppGui().getCurrentTabName(), query, verificationResult, verificationTime, MemoryMonitor.getPeakMemory(), rawOutput, stats, optionNumber) : new BatchProcessingVerificationResult(fileName, query, verificationResult, verificationTime, MemoryMonitor.getPeakMemory(), rawOutput, stats, optionNumber);
        this.publish(result);
    }

    private VerificationResult<TimedArcPetriNetTrace> verify(Tuple<TimedArcPetriNet, NameMapping> composedModel, net.tapaal.gui.petrinet.verification.TAPNQuery query, BatchProcessingVerificationOptions option) throws Exception {
        TAPNQuery queryToVerify = this.getTAPNQuery(query);
        queryToVerify.setCategory(query.getCategory());
        queryToVerify.setVerificationType(query.getVerificationType());
        this.MapQueryToNewNames(queryToVerify, composedModel.value2());
        TAPNQuery clonedQuery = new TAPNQuery(query.getProperty().copy(), queryToVerify.getExtraTokens(), query.getSmcSettings());
        clonedQuery.setCategory(query.getCategory());
        clonedQuery.setVerificationType(query.getVerificationType());
        this.MapQueryToNewNames(clonedQuery, composedModel.value2());
        this.fireVerificationTaskStarted();
        ApproximationWorker worker = new ApproximationWorker();
        ModelChecker modelChecker = this.modelChecker = option.getEngine() == null ? this.getModelChecker(query) : this.getModelChecker(option.getEngine());
        if (option.getOptions().equalsIgnoreCase("default")) {
            return worker.batchWorker(composedModel, this.getVerificationOptionsFromQuery(query), query, this.model, this.modelChecker, queryToVerify, clonedQuery);
        }
        Object options = option.getOptions();
        if (option.keepKBound()) {
            Pattern pattern = Pattern.compile("\\s*(-k|--k-bound)\\s*(\\d+)\\s*", 2);
            Matcher matcher = pattern.matcher((CharSequence)options);
            int kbound = query.getCapacity() + this.model.network().marking().size();
            options = matcher.find() ? ((String)options).replaceFirst(matcher.group(), " " + matcher.group(1) + " " + kbound + " ") : "--k-bound " + kbound + " " + (String)options;
        }
        return worker.batchWorker(composedModel, (String)options, query, this.model, this.modelChecker, queryToVerify, clonedQuery);
    }

    private TAPNQuery getTAPNQuery(net.tapaal.gui.petrinet.verification.TAPNQuery query) throws Exception {
        return new TAPNQuery(query.getProperty().copy(), query.getCapacity(), query.getSmcSettings());
    }

    private ModelChecker getModelChecker(net.tapaal.gui.petrinet.verification.TAPNQuery query) {
        if (query.getReductionOption() == ReductionOption.VerifyTAPN) {
            return BatchProcessingWorker.getVerifyTAPN();
        }
        if (query.getReductionOption() == ReductionOption.VerifyDTAPN) {
            return BatchProcessingWorker.getVerifyTAPNDiscreteVerification();
        }
        if (query.getReductionOption() == ReductionOption.VerifyPN || query.getReductionOption() == ReductionOption.VerifyPNApprox || query.getReductionOption() == ReductionOption.VerifyPNReduce) {
            return BatchProcessingWorker.getVerifyPN();
        }
        return this.getVerifyta();
    }

    private ModelChecker getModelChecker(ReductionOption reductionOption) {
        if (reductionOption == ReductionOption.VerifyTAPN) {
            return BatchProcessingWorker.getVerifyTAPN();
        }
        if (reductionOption == ReductionOption.VerifyDTAPN) {
            return BatchProcessingWorker.getVerifyTAPNDiscreteVerification();
        }
        if (reductionOption == ReductionOption.VerifyPN || reductionOption == ReductionOption.VerifyPNApprox || reductionOption == ReductionOption.VerifyPNReduce) {
            return BatchProcessingWorker.getVerifyPN();
        }
        return this.getVerifyta();
    }

    public VerificationOptions getVerificationOptionsFromQuery(net.tapaal.gui.petrinet.verification.TAPNQuery query) {
        if (query.getReductionOption() == ReductionOption.VerifyTAPN) {
            return new VerifyTAPNOptions(query.getCapacity(), TAPNQuery.TraceOption.NONE, query.getSearchOption(), query.useSymmetry(), false, query.discreteInclusion(), query.inclusionPlaces(), query.isOverApproximationEnabled(), query.isUnderApproximationEnabled(), query.approximationDenominator(), query.isColored(), false, query.getRawVerification(), query.getRawVerificationPrompt());
        }
        if (query.getReductionOption() == ReductionOption.VerifyDTAPN) {
            return new VerifyDTAPNOptions(query.getCapacity(), TAPNQuery.TraceOption.NONE, query.getSearchOption(), query.useSymmetry(), query.useGCD(), query.useTimeDarts(), query.usePTrie(), false, query.discreteInclusion(), query.inclusionPlaces(), query.getWorkflowMode(), 0L, query.isOverApproximationEnabled(), query.isUnderApproximationEnabled(), query.approximationDenominator(), query.isStubbornReductionEnabled(), null, query.usePartitioning(), query.useColorFixpoint(), query.isColored(), query.getRawVerification(), query.getRawVerificationPrompt(), query.isBenchmarkMode(), query.getBenchmarkRuns(), query.isParallel(), query.getCategory(), query.getNumberOfTraces(), query.getSmcTraceType(), query.isSimulate(), query.getGranularity(), query.isMaxGranularity(), query.getSmcSettings().getNumericPrecision());
        }
        if (query.getReductionOption() == ReductionOption.VerifyPN || query.getReductionOption() == ReductionOption.VerifyPNApprox || query.getReductionOption() == ReductionOption.VerifyPNReduce) {
            return new VerifyPNOptions(query.getCapacity(), TAPNQuery.TraceOption.NONE, query.getSearchOption(), query.useOverApproximation(), query.useReduction() ? ModelReduction.AGGRESSIVE : ModelReduction.NO_REDUCTION, query.isOverApproximationEnabled(), query.isUnderApproximationEnabled(), query.approximationDenominator(), query.getCategory(), query.getAlgorithmOption(), query.isSiphontrapEnabled(), query.isQueryReductionEnabled() ? TAPNQuery.QueryReductionTime.UnlimitedTime : TAPNQuery.QueryReductionTime.NoTime, query.isStubbornReductionEnabled(), null, query.isTarOptionEnabled(), query.isTarjan(), query.isColored(), false, query.usePartitioning(), query.useColorFixpoint(), query.useSymmetricVars(), query.useColoredReduction(), query.useExplicitSearch(), query.getRawVerification(), query.getRawVerificationPrompt());
        }
        return new VerifytaOptions(TAPNQuery.TraceOption.NONE, query.getSearchOption(), false, query.getReductionOption(), query.useSymmetry(), false, query.isOverApproximationEnabled(), query.isUnderApproximationEnabled(), query.approximationDenominator());
    }

    private void MapQueryToNewNames(TAPNQuery query, NameMapping mapping) {
        RenameAllPlacesVisitor placeVisitor = new RenameAllPlacesVisitor(mapping);
        RenameAllTransitionsVisitor transitionVisitor = new RenameAllTransitionsVisitor(mapping);
        query.getProperty().accept(placeVisitor, null);
        query.getProperty().accept(transitionVisitor, null);
    }

    private Verifyta getVerifyta() {
        Verifyta verifyta = new Verifyta(new FileFinder(), new MessengerImpl());
        verifyta.setup();
        return verifyta;
    }

    private static VerifyTAPN getVerifyTAPN() {
        VerifyTAPN verifytapn = new VerifyTAPN(new FileFinder(), new MessengerImpl());
        verifytapn.setup();
        return verifytapn;
    }

    private static VerifyPN getVerifyPN() {
        VerifyPN verifypn = new VerifyPN(new FileFinder(), new MessengerImpl());
        verifypn.setup();
        return verifypn;
    }

    private static VerifyDTAPN getVerifyTAPNDiscreteVerification() {
        VerifyDTAPN verifytapnDiscreteVerification = new VerifyDTAPN(new FileFinder(), new MessengerImpl());
        verifytapnDiscreteVerification.setup();
        return verifytapnDiscreteVerification;
    }

    private LoadedBatchProcessingModel loadModel(File modelFile) {
        this.fireStatusChanged("Loading model...");
        BatchProcessingModelLoader loader = new BatchProcessingModelLoader();
        try {
            return loader.load(modelFile);
        }
        catch (Exception e) {
            this.publishResult(modelFile.getName(), null, "Error loading model", 0L, null, new NullStats(), -1);
            this.fireVerificationTaskComplete();
            return null;
        }
    }

    @Override
    protected void process(List<BatchProcessingVerificationResult> chunks) {
        for (BatchProcessingVerificationResult result : chunks) {
            this.tableModel.addResult(result);
        }
    }

    @Override
    protected void done() {
        if (this.isCancelled() && this.modelChecker != null) {
            this.modelChecker.kill();
        }
    }

    public void addBatchProcessingListener(BatchProcessingListener listener) {
        Require.that(listener != null, "Listener cannot be null");
        this.listeners.add(listener);
    }

    private void fireStatusChanged(String status) {
        for (BatchProcessingListener listener : this.listeners) {
            listener.fireStatusChanged(new StatusChangedEvent(status));
        }
    }

    private void fireFileChanged(String fileName) {
        for (BatchProcessingListener listener : this.listeners) {
            listener.fireFileChanged(new FileChangedEvent(fileName));
        }
    }

    private void fireVerificationTaskComplete() {
        ++this.verificationTasksCompleted;
        for (BatchProcessingListener listener : this.listeners) {
            listener.fireVerificationTaskComplete(new VerificationTaskCompleteEvent(this.verificationTasksCompleted));
        }
    }

    private void fireVerificationTaskStarted() {
        for (BatchProcessingListener listener : this.listeners) {
            listener.fireVerificationTaskStarted();
        }
    }
}

