/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.verification.VerifyTAPN;

import com.sun.jna.Platform;
import dk.aau.cs.verification.VerificationOptions;
import java.util.HashMap;
import java.util.Map;
import net.tapaal.gui.petrinet.verification.TAPNQuery;

public class VerifyPNUnfoldOptions
extends VerificationOptions {
    private static final Map<TAPNQuery.SearchOption, String> searchMap = VerifyPNUnfoldOptions.createSearchOptionsMap();
    private final String modelOut;
    private final String queryOut;
    private final int numQueries;
    private final boolean partition;
    private final boolean computeColorFixpoint;
    private final boolean symmetricVars;

    public VerifyPNUnfoldOptions(String modelOut, String queryOut, int numQueries, boolean partition, boolean computeColorFixpoint, boolean useSymmetricVars) {
        this.modelOut = modelOut;
        this.queryOut = queryOut;
        this.numQueries = numQueries;
        this.partition = partition;
        this.computeColorFixpoint = computeColorFixpoint;
        this.symmetricVars = useSymmetricVars;
    }

    @Override
    public boolean enabledOverApproximation() {
        return false;
    }

    @Override
    public boolean enabledUnderApproximation() {
        return false;
    }

    @Override
    public int approximationDenominator() {
        return 0;
    }

    @Override
    public int extraTokens() {
        return 0;
    }

    @Override
    public TAPNQuery.TraceOption traceOption() {
        return null;
    }

    @Override
    public void setTraceOption(TAPNQuery.TraceOption option) {
    }

    @Override
    public TAPNQuery.SearchOption searchOption() {
        return null;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.writeUnfolded());
        result.append(" --search-strategy OverApprox --reduction 0 --query-reduction 0 --xml-queries 1");
        for (int i = 2; i <= this.numQueries; ++i) {
            result.append("," + i);
        }
        if (!this.partition) {
            result.append(" --disable-partitioning");
        }
        if (!this.computeColorFixpoint) {
            result.append(" --disable-cfp");
        }
        if (!this.symmetricVars) {
            result.append(" --disable-symmetry-vars");
        }
        result.append(" --col-reduction 0 ");
        result.append("--bindings ");
        return result.toString();
    }

    private String writeUnfolded() {
        if (Platform.isWindows()) {
            return "--write-unfolded-queries \"" + this.queryOut + "\" --write-unfolded-net \"" + this.modelOut + "\"";
        }
        return "--write-unfolded-queries " + this.queryOut + " --write-unfolded-net " + this.modelOut;
    }

    private static Map<TAPNQuery.SearchOption, String> createSearchOptionsMap() {
        HashMap<TAPNQuery.SearchOption, String> map = new HashMap<TAPNQuery.SearchOption, String>();
        map.put(TAPNQuery.SearchOption.BFS, " --search-strategy BFS");
        map.put(TAPNQuery.SearchOption.DFS, " --search-strategy DFS");
        map.put(TAPNQuery.SearchOption.RANDOM, " --search-strategy RDFS");
        map.put(TAPNQuery.SearchOption.HEURISTIC, " --search-strategy BestFS");
        map.put(TAPNQuery.SearchOption.OVERAPPROXIMATE, " --search-strategy OverApprox");
        return map;
    }
}

