/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.verification.VerifyTAPN;

import dk.aau.cs.model.tapn.TAPNQuery;
import dk.aau.cs.util.Tuple;
import dk.aau.cs.verification.BoundednessAnalysisResult;
import dk.aau.cs.verification.QuantitativeResult;
import dk.aau.cs.verification.QueryResult;
import dk.aau.cs.verification.SMCStats;
import dk.aau.cs.verification.Stats;
import dk.aau.cs.verification.VerifyTAPN.ObservationData;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import pipe.gui.graph.GraphPoint;

public class VerifyDTAPNOutputParser {
    private static final String Query_IS_NOT_SATISFIED_STRING = "Query is NOT satisfied";
    private static final String Query_IS_SATISFIED_STRING = "Query is satisfied";
    private static final String DISCRETE_INCLUSION = "discrete inclusion";
    private static final String SMC_Verification_INDICATOR_STRING = "SMC Verification";
    private static final String SMC_Hypothesis_IS_SATISFIED_STRING = "Hypothesis is satisfied";
    private static final String SMC_Hypothesis_IS_NOT_SATISFIED_STRING = "Hypothesis is NOT satisfied";
    private static final Pattern discoveredPattern = Pattern.compile("\\s*discovered markings:\\s*(\\d+)\\s*");
    private static final Pattern exploredPattern = Pattern.compile("\\s*explored markings:\\s*(\\d+)\\s*");
    private static final Pattern storedPattern = Pattern.compile("\\s*stored markings:\\s*(\\d+)\\s*");
    private static final Pattern maxUsedTokensPattern = Pattern.compile("\\s*Max number of tokens found in any reachable marking:\\s*(>)?(\\d+)\\s*");
    private static final Pattern transitionStatsPattern = Pattern.compile("<([^:\\s]+)[;:](\\d+)>");
    private static final Pattern placeBoundPattern = Pattern.compile("<([^;:\\s]+)[;:](\\d+)>");
    private static final Pattern placeBoundPatternUnknown = Pattern.compile("<([^;:\\s]+)[;:]\\?>");
    private static final Pattern smcTransitionStatsPattern = Pattern.compile("<([^:\\s]+)[;:]([\\d]+(\\.[\\d]+)?)>");
    private static final Pattern smcPlaceBoundPattern = Pattern.compile("<([^:\\s]+)[;:]([\\d]+(\\.[\\d]+)?)>");
    private static final Pattern smcPlaceBoundPatternUnknown = Pattern.compile("<([^;:\\s]+)[;:]\\?>");
    private static final Pattern smcEstimationPattern = Pattern.compile("\\s*P = ([^\u00b1]+) \u00b1 (.+)\\s*");
    private static final Pattern smcExecutedRunsPattern = Pattern.compile("\\s*runs executed:\\s*(\\d+)\\s*");
    private static final Pattern smcValidRunsPattern = Pattern.compile("\\s*number of valid runs:\\s*(\\d+)\\s*");
    private static final Pattern smcAverageTimePattern = Pattern.compile("\\s*average run duration:\\s*([\\d\\.]+)\\s*");
    private static final Pattern smcAverageLengthPattern = Pattern.compile("\\s*average run length:\\s*([\\d\\.]+)\\s*");
    private static final Pattern smcTimeStdDevPattern = Pattern.compile("\\s*run duration \\(std. dev.\\):\\s*([\\d\\.]+)\\s*");
    private static final Pattern smcLengthStdDevPattern = Pattern.compile("\\s*run length \\(std. dev.\\):\\s*([\\d\\.]+)\\s*");
    private static final Pattern smcVerificationTimePattern = Pattern.compile("\\s*verification time:\\s*([\\d\\.]+)\\s*");
    private static final Pattern smcCumulativeProbabilityStepPattern = Pattern.compile("\\s*cumulative probability / step :");
    private static final Pattern smcCumulativeProbabilityDelayPattern = Pattern.compile("\\s*cumulative probability / delay :");
    private static final Map<String, Pattern> smcObservationPatterns = new LinkedHashMap<String, Pattern>(){
        {
            this.put("avgStep", Pattern.compile("\\((\\w+(?: \\w+)*)\\) avg/step"));
            this.put("minStep", Pattern.compile("\\((\\w+(?: \\w+)*)\\) min/step"));
            this.put("maxStep", Pattern.compile("\\((\\w+(?: \\w+)*)\\) max/step"));
            this.put("avgTime", Pattern.compile("\\((\\w+(?: \\w+)*)\\) avg/time"));
            this.put("minTime", Pattern.compile("\\((\\w+(?: \\w+)*)\\) min/time"));
            this.put("maxTime", Pattern.compile("\\((\\w+(?: \\w+)*)\\) max/time"));
            this.put("valueStep", Pattern.compile("\\((\\w+(?: \\w+)*)\\) value/step"));
            this.put("valueTime", Pattern.compile("\\((\\w+(?: \\w+)*)\\) value/time"));
            this.put("globalAvgStep", Pattern.compile("\\((\\w+(?: \\w+)*)\\) Global steps avg.: ([0-9]*[.]?[0-9]+(?:[eE][-+]?[0-9]+)?)"));
            this.put("globalAvgTime", Pattern.compile("\\((\\w+(?: \\w+)*)\\) Global time avg.: ([0-9]*[.]?[0-9]+(?:[eE][-+]?[0-9]+)?)"));
        }
    };
    private static final Pattern smcAverageValidTimePattern = Pattern.compile("\\s*duration of a valid run \\(average\\):\\s*([\\d\\.]+)\\s*");
    private static final Pattern smcAverageValidLengthPattern = Pattern.compile("\\s*length of a valid run \\(average\\):\\s*([\\d\\.]+)\\s*");
    private static final Pattern smcValidTimeStdDevPattern = Pattern.compile("\\s*duration of a valid run \\(std. dev.\\):\\s*([\\d\\.]+)\\s*");
    private static final Pattern smcValidLengthStdDevPattern = Pattern.compile("\\s*length of a valid run \\(std. dev.\\):\\s*([\\d\\.]+)\\s*");
    private static final Pattern smcAverageViolatingTimePattern = Pattern.compile("\\s*duration of a violating run \\(average\\):\\s*([\\d\\.]+)\\s*");
    private static final Pattern smcAverageViolatingLengthPattern = Pattern.compile("\\s*length of a violating run \\(average\\):\\s*([\\d\\.]+)\\s*");
    private static final Pattern smcViolatingTimeStdDevPattern = Pattern.compile("\\s*duration of a violating run \\(std. dev.\\):\\s*([\\d\\.]+)\\s*");
    private static final Pattern smcViolatingLengthStdDevPattern = Pattern.compile("\\s*length of a violating run \\(std. dev.\\):\\s*([\\d\\.]+)\\s*");
    private static final Pattern smcNumberOfTracesPattern = Pattern.compile("\\s*Generated \\d+ random traces");
    private static final Pattern wfMinExecutionPattern = Pattern.compile("Minimum execution time: (-?\\d*)");
    private static final Pattern wfMaxExecutionPattern = Pattern.compile("Maximum execution time: (-?\\d*)");
    private static final Pattern wfCoveredMarkingPattern = Pattern.compile("Covered marking: (.*)");
    private final int totalTokens;
    private final TAPNQuery query;
    private final int extraTokens;
    private final List<Tuple<String, Number>> transitionStats = new ArrayList<Tuple<String, Number>>();
    private final List<Tuple<String, Number>> placeBoundStats = new ArrayList<Tuple<String, Number>>();
    private final Set<String> uniqueMatches = new HashSet<String>();
    private int allMatches;

    public VerifyDTAPNOutputParser(int totalTokens, int extraTokens, TAPNQuery query) {
        this.totalTokens = totalTokens;
        this.extraTokens = extraTokens;
        this.query = query;
    }

    public Tuple<QueryResult, Stats> parseOutput(String output) {
        int discovered = 0;
        int explored = 0;
        int stored = 0;
        int WFminExecutionTime = -1;
        int WFmaxExecutionTime = -1;
        int smcExecutedRuns = -1;
        int smcValidRuns = 0;
        float smcAverageTime = -1.0f;
        float smcAverageLength = -1.0f;
        float smcTimeStdDev = -1.0f;
        float smcLengthStdDev = -1.0f;
        float smcVerificationTime = -1.0f;
        float smcAverageValidTime = -1.0f;
        float smcAverageValidLength = -1.0f;
        float smcValidTimeStdDev = -1.0f;
        float smcValidLengthStdDev = -1.0f;
        float smcAverageViolatingTime = -1.0f;
        float smcAverageViolatingLength = -1.0f;
        float smcViolatingTimeStdDev = -1.0f;
        float smcViolatingLengthStdDev = -1.0f;
        ArrayList<Tuple<String, Tuple<BigDecimal, Integer>>> coveredMarking = null;
        boolean result = false;
        int maxUsedTokens = 0;
        boolean foundResult = false;
        boolean discreteInclusion = false;
        boolean isSmc = false;
        boolean isQuantitative = false;
        QuantitativeResult quantitativeResult = null;
        String[] lines = output.split(System.getProperty("line.separator"));
        ArrayList<GraphPoint> cumulativeStepPoints = new ArrayList<GraphPoint>();
        ArrayList<GraphPoint> cumulativeDelayPoints = new ArrayList<GraphPoint>();
        HashMap<String, ObservationData> observationDataMap = new HashMap<String, ObservationData>();
        if (output.contains(SMC_Verification_INDICATOR_STRING)) {
            isSmc = true;
        }
        try {
            Stats verifStats;
            boolean inTransitionStats = false;
            boolean inPlaceBoundStats = false;
            for (int i = 0; i < lines.length; ++i) {
                String[] coordinates;
                Matcher matcher;
                String line = lines[i];
                if (line.trim().equals("TRANSITION STATISTICS")) {
                    inTransitionStats = true;
                    inPlaceBoundStats = false;
                    continue;
                }
                if (line.trim().equals("PLACE-BOUND STATISTICS")) {
                    inTransitionStats = false;
                    inPlaceBoundStats = true;
                    continue;
                }
                if (inTransitionStats) {
                    if (isSmc) {
                        matcher = smcTransitionStatsPattern.matcher(line);
                        while (matcher.find()) {
                            this.transitionStats.add(new Tuple<String, Double>(matcher.group(1), Double.parseDouble(matcher.group(2))));
                        }
                    } else {
                        matcher = transitionStatsPattern.matcher(line);
                        while (matcher.find()) {
                            this.transitionStats.add(new Tuple<String, Integer>(matcher.group(1), Integer.parseInt(matcher.group(2))));
                        }
                    }
                    if (line.trim().isEmpty()) {
                        inTransitionStats = false;
                    }
                } else if (inPlaceBoundStats) {
                    if (isSmc) {
                        matcher = smcPlaceBoundPattern.matcher(line);
                        while (matcher.find()) {
                            this.placeBoundStats.add(new Tuple<String, Double>(matcher.group(1), Double.parseDouble(matcher.group(2))));
                        }
                        matcher = smcPlaceBoundPatternUnknown.matcher(line);
                        while (matcher.find()) {
                            this.placeBoundStats.add(new Tuple<String, Integer>(matcher.group(1), -1));
                        }
                    } else {
                        matcher = placeBoundPattern.matcher(line);
                        while (matcher.find()) {
                            this.placeBoundStats.add(new Tuple<String, Integer>(matcher.group(1), Integer.parseInt(matcher.group(2))));
                        }
                        matcher = placeBoundPatternUnknown.matcher(line);
                        while (matcher.find()) {
                            this.placeBoundStats.add(new Tuple<String, Integer>(matcher.group(1), -1));
                        }
                    }
                    if (line.trim().isEmpty()) {
                        inPlaceBoundStats = false;
                    }
                }
                if (line.contains(DISCRETE_INCLUSION)) {
                    discreteInclusion = true;
                }
                if (line.contains(Query_IS_SATISFIED_STRING) || line.contains(SMC_Hypothesis_IS_SATISFIED_STRING)) {
                    result = true;
                    foundResult = true;
                    continue;
                }
                if (line.contains(Query_IS_NOT_SATISFIED_STRING) || line.contains(SMC_Hypothesis_IS_NOT_SATISFIED_STRING)) {
                    result = false;
                    foundResult = true;
                    continue;
                }
                matcher = discoveredPattern.matcher(line);
                if (matcher.find()) {
                    discovered = Integer.parseInt(matcher.group(1));
                }
                if ((matcher = exploredPattern.matcher(line)).find()) {
                    explored = Integer.parseInt(matcher.group(1));
                }
                if ((matcher = storedPattern.matcher(line)).find()) {
                    stored = Integer.parseInt(matcher.group(1));
                }
                if ((matcher = maxUsedTokensPattern.matcher(line)).find()) {
                    String operator;
                    maxUsedTokens = Integer.parseInt(matcher.group(2));
                    String string = operator = matcher.group(1) == null ? "" : matcher.group(1);
                    if (operator.equals(">")) {
                        ++maxUsedTokens;
                    }
                }
                if ((matcher = wfMinExecutionPattern.matcher(line)).find()) {
                    WFminExecutionTime = Integer.parseInt(matcher.group(1));
                }
                if ((matcher = wfMaxExecutionPattern.matcher(line)).find()) {
                    WFmaxExecutionTime = Integer.parseInt(matcher.group(1));
                }
                if ((matcher = wfCoveredMarkingPattern.matcher(line)).find()) {
                    coveredMarking = new ArrayList<Tuple<String, Tuple<BigDecimal, Integer>>>();
                    Pattern pattern = Pattern.compile("\\(([^,]*), (\\d), (\\d)\\)?");
                    for (String s : matcher.group(1).split("\\), ")) {
                        Matcher m = pattern.matcher(s);
                        if (!m.matches()) continue;
                        for (int ii = 0; ii < Integer.parseInt(m.group(3)); ++ii) {
                            coveredMarking.add(new Tuple<String, Tuple<BigDecimal, Integer>>(m.group(1), new Tuple<BigDecimal, Integer>(new BigDecimal(m.group(2)), Integer.parseInt(m.group(3)))));
                        }
                    }
                }
                if ((matcher = smcEstimationPattern.matcher(line)).find()) {
                    foundResult = true;
                    result = true;
                    isQuantitative = true;
                    float smcEstimation = Float.parseFloat(matcher.group(1));
                    float smcEstimationWidth = Float.parseFloat(matcher.group(2));
                    quantitativeResult = new QuantitativeResult(smcEstimation, smcEstimationWidth);
                }
                if ((matcher = smcExecutedRunsPattern.matcher(line)).find()) {
                    smcExecutedRuns = Integer.parseInt(matcher.group(1));
                }
                if ((matcher = smcValidRunsPattern.matcher(line)).find()) {
                    smcValidRuns = Integer.parseInt(matcher.group(1));
                }
                if ((matcher = smcAverageTimePattern.matcher(line)).find()) {
                    smcAverageTime = Float.parseFloat(matcher.group(1));
                }
                if ((matcher = smcAverageLengthPattern.matcher(line)).find()) {
                    smcAverageLength = Float.parseFloat(matcher.group(1));
                }
                if ((matcher = smcTimeStdDevPattern.matcher(line)).find()) {
                    smcTimeStdDev = Float.parseFloat(matcher.group(1));
                }
                if ((matcher = smcLengthStdDevPattern.matcher(line)).find()) {
                    smcLengthStdDev = Float.parseFloat(matcher.group(1));
                }
                if ((matcher = smcVerificationTimePattern.matcher(line)).find()) {
                    smcVerificationTime = Float.parseFloat(matcher.group(1));
                }
                if ((matcher = smcAverageValidTimePattern.matcher(line)).find()) {
                    smcAverageValidTime = Float.parseFloat(matcher.group(1));
                }
                if ((matcher = smcAverageValidLengthPattern.matcher(line)).find()) {
                    smcAverageValidLength = Float.parseFloat(matcher.group(1));
                }
                if ((matcher = smcValidTimeStdDevPattern.matcher(line)).find()) {
                    smcValidTimeStdDev = Float.parseFloat(matcher.group(1));
                }
                if ((matcher = smcValidLengthStdDevPattern.matcher(line)).find()) {
                    smcValidLengthStdDev = Float.parseFloat(matcher.group(1));
                }
                if ((matcher = smcAverageViolatingTimePattern.matcher(line)).find()) {
                    smcAverageViolatingTime = Float.parseFloat(matcher.group(1));
                }
                if ((matcher = smcAverageViolatingLengthPattern.matcher(line)).find()) {
                    smcAverageViolatingLength = Float.parseFloat(matcher.group(1));
                }
                if ((matcher = smcViolatingTimeStdDevPattern.matcher(line)).find()) {
                    smcViolatingTimeStdDev = Float.parseFloat(matcher.group(1));
                }
                if ((matcher = smcViolatingLengthStdDevPattern.matcher(line)).find()) {
                    smcViolatingLengthStdDev = Float.parseFloat(matcher.group(1));
                }
                if ((matcher = smcCumulativeProbabilityStepPattern.matcher(line)).find() && i < lines.length - 1) {
                    String[] pointStrs;
                    line = lines[i + 1];
                    for (String pointStr : pointStrs = line.split(";")) {
                        coordinates = pointStr.split(":");
                        GraphPoint point = new GraphPoint(Double.parseDouble(coordinates[0]), Double.parseDouble(coordinates[1]));
                        cumulativeStepPoints.add(point);
                    }
                }
                if ((matcher = smcCumulativeProbabilityDelayPattern.matcher(line)).find() && i < lines.length - 1) {
                    String[] pointStrs;
                    line = lines[i + 1];
                    for (String pointStr : pointStrs = line.split(";")) {
                        coordinates = pointStr.split(":");
                        GraphPoint point = new GraphPoint(Double.parseDouble(coordinates[0]), Double.parseDouble(coordinates[1]));
                        cumulativeDelayPoints.add(point);
                    }
                }
                if (isSmc) {
                    this.extractObservations(line, i, lines, observationDataMap);
                }
                if (!(matcher = smcNumberOfTracesPattern.matcher(line)).find()) continue;
                foundResult = true;
                result = true;
            }
            if (!foundResult) {
                return null;
            }
            BoundednessAnalysisResult boundedAnalysis = new BoundednessAnalysisResult(this.totalTokens, maxUsedTokens, this.extraTokens);
            if (isSmc) {
                verifStats = new SMCStats(smcExecutedRuns, smcValidRuns, smcAverageTime, smcAverageLength, smcVerificationTime, cumulativeStepPoints, cumulativeDelayPoints, observationDataMap, this.transitionStats, this.placeBoundStats);
                ((SMCStats)verifStats).setRunTimeStdDev(smcTimeStdDev);
                ((SMCStats)verifStats).setRunLengthStdDev(smcLengthStdDev);
                ((SMCStats)verifStats).setValidRunAverageTime(smcAverageValidTime);
                ((SMCStats)verifStats).setValidRunAverageLength(smcAverageValidLength);
                ((SMCStats)verifStats).setValidRunTimeStdDev(smcValidTimeStdDev);
                ((SMCStats)verifStats).setValidRunLengthStdDev(smcValidLengthStdDev);
                ((SMCStats)verifStats).setViolatingRunAverageTime(smcAverageViolatingTime);
                ((SMCStats)verifStats).setViolatingRunAverageLength(smcAverageViolatingLength);
                ((SMCStats)verifStats).setViolatingRunTimeStdDev(smcViolatingTimeStdDev);
                ((SMCStats)verifStats).setViolatingRunLengthStdDev(smcViolatingLengthStdDev);
            } else {
                verifStats = new Stats(discovered, explored, stored, this.transitionStats, this.placeBoundStats, WFminExecutionTime, WFmaxExecutionTime, coveredMarking);
            }
            QueryResult queryRes = isQuantitative ? new QueryResult(quantitativeResult, boundedAnalysis, this.query, discreteInclusion) : new QueryResult(result, boundedAnalysis, this.query, discreteInclusion);
            return new Tuple<QueryResult, Stats>(queryRes, verifStats);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void extractObservations(String line, int i, String[] lines, Map<String, ObservationData> observationDataMap) {
        Matcher matcher;
        Pattern pattern;
        if (this.query.isSimulate()) {
            String startLine = line;
            for (Map.Entry<String, Pattern> entry : smcObservationPatterns.entrySet()) {
                pattern = entry.getValue();
                matcher = pattern.matcher(line);
                if (!matcher.find() || i >= lines.length - 1) continue;
                this.uniqueMatches.add(matcher.group(0));
            }
            line = startLine;
        }
        for (Map.Entry<String, Pattern> entry : smcObservationPatterns.entrySet()) {
            ObservationData observationData;
            pattern = entry.getValue();
            matcher = pattern.matcher(line);
            String key = entry.getKey();
            if (key.contains("global") && matcher.find()) {
                String observationName = matcher.group(1);
                double value = Double.parseDouble(matcher.group(2));
                observationData = observationDataMap.containsKey(observationName) ? observationDataMap.get(observationName) : new ObservationData();
                switch (key) {
                    case "globalAvgStep": {
                        observationData.setSmcGlobalAvgStep(value);
                        break;
                    }
                    case "globalAvgTime": {
                        observationData.setSmcGlobalAvgTime(value);
                    }
                }
                continue;
            }
            if (!matcher.find() || i >= lines.length - 1) continue;
            line = lines[i + 1];
            String[] pointStrs = line.split(";");
            ArrayList<GraphPoint> points = new ArrayList<GraphPoint>();
            for (String pointStr : pointStrs) {
                String[] coordinates = pointStr.split(":");
                GraphPoint point = new GraphPoint(Double.parseDouble(coordinates[0]), Double.parseDouble(coordinates[1]));
                points.add(point);
            }
            Object observationName = matcher.group(1);
            if (this.query.isSimulate()) {
                observationName = (String)observationName + " (" + (this.allMatches++ + this.uniqueMatches.size()) / this.uniqueMatches.size() + ")";
            }
            observationData = observationDataMap.containsKey(observationName) ? observationDataMap.get(observationName) : new ObservationData();
            observationData.setObservationData(points, key);
            if (observationDataMap.containsKey(observationName)) continue;
            observationDataMap.put((String)observationName, observationData);
        }
    }
}

