/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.verification.VerifyTAPN;

import com.sun.jna.Platform;
import dk.aau.cs.verification.SMCTraceType;
import dk.aau.cs.verification.VerifyTAPN.VerifyTAPNOptions;
import java.io.File;
import java.io.IOException;
import net.tapaal.gui.petrinet.verification.InclusionPlaces;
import net.tapaal.gui.petrinet.verification.TAPNQuery;
import pipe.gui.MessengerImpl;

public class VerifyDTAPNOptions
extends VerifyTAPNOptions {
    private final boolean gcd;
    private final boolean timeDarts;
    private final boolean pTrie;
    private final TAPNQuery.WorkflowMode workflow;
    private final long workflowbound;
    private boolean dontUseDeadPlaces = false;
    private boolean useStubbornReduction = true;
    private final boolean partition;
    private final boolean colorFixpoint;
    private boolean useRawVerification;
    private String rawVerificationOptions;
    private boolean parallel = false;
    private boolean benchmark = false;
    private int benchmarkRuns = 100;
    private boolean isSmc;
    private int numberOfTraces;
    private SMCTraceType smcTraceType;
    private int granularity;
    private boolean maxGranularity = false;
    private long numericPrecision;

    public VerifyDTAPNOptions(boolean dontUseDeadPlaces, int extraTokens, TAPNQuery.TraceOption traceOption, TAPNQuery.SearchOption search, boolean symmetry, boolean gcd, boolean timeDarts, boolean pTrie, boolean enableOverApproximation, boolean enableUnderApproximation, int approximationDenominator, boolean stubbornReduction, boolean partition, boolean colorFixpoint, boolean unfoldNet, boolean useRawVerification, String rawVerificationOptions) {
        this(extraTokens, traceOption, search, symmetry, gcd, timeDarts, pTrie, false, false, new InclusionPlaces(), TAPNQuery.WorkflowMode.NOT_WORKFLOW, 0L, enableOverApproximation, enableUnderApproximation, approximationDenominator, stubbornReduction, null, partition, colorFixpoint, unfoldNet, useRawVerification, rawVerificationOptions, false, 0, false, TAPNQuery.QueryCategory.Default, 1, new SMCTraceType(), false, 500, false, 5L);
        this.dontUseDeadPlaces = dontUseDeadPlaces;
    }

    public VerifyDTAPNOptions(int extraTokens, TAPNQuery.TraceOption traceOption, TAPNQuery.SearchOption search, boolean symmetry, boolean gcd, boolean timeDarts, boolean pTrie, boolean useStateequationCheck, boolean discreteInclusion, InclusionPlaces inclusionPlaces, TAPNQuery.WorkflowMode workflow, long workflowbound, boolean enableOverApproximation, boolean enableUnderApproximation, int approximationDenominator, boolean stubbornReduction, String reducedModelPath, boolean partition, boolean colorFixpoint, boolean unfoldNet, boolean useRawVerification, String rawVerificationOptions, boolean benchmark, int benchmarkRuns, boolean parallel, TAPNQuery.QueryCategory queryCategory, int numberOfTraces, SMCTraceType smcTraceType, boolean isSimulate, int granularity, boolean maxGranularity, long numericPrecision) {
        super(extraTokens, traceOption, search, symmetry, useStateequationCheck, discreteInclusion, inclusionPlaces, enableOverApproximation, enableUnderApproximation, approximationDenominator);
        this.timeDarts = timeDarts;
        this.pTrie = pTrie;
        this.workflow = workflow;
        this.gcd = gcd;
        this.workflowbound = workflowbound;
        this.useStubbornReduction = stubbornReduction;
        this.reducedModelPath = reducedModelPath;
        this.partition = partition;
        this.colorFixpoint = colorFixpoint;
        this.unfold = unfoldNet;
        this.useRawVerification = useRawVerification;
        this.rawVerificationOptions = rawVerificationOptions;
        this.benchmark = benchmark;
        this.benchmarkRuns = benchmarkRuns;
        this.parallel = parallel;
        this.isSmc = queryCategory == TAPNQuery.QueryCategory.SMC;
        this.numberOfTraces = numberOfTraces;
        this.smcTraceType = smcTraceType;
        this.isSimulate = isSimulate;
        this.granularity = granularity;
        this.maxGranularity = maxGranularity;
        this.numericPrecision = numericPrecision;
        if ((this.unfold && this.trace() != TAPNQuery.TraceOption.NONE || enableOverApproximation || enableUnderApproximation || this.isSmc && isSimulate && this.unfold) && !useRawVerification) {
            try {
                unfoldedModelPath = File.createTempFile("unfolded-", ".pnml").getAbsolutePath();
                unfoldedQueriesPath = File.createTempFile("unfoldedQueries-", ".xml").getAbsolutePath();
            }
            catch (IOException e) {
                new MessengerImpl().displayErrorMessage(e.getMessage(), "Error");
            }
        }
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        if (this.useRawVerification && this.rawVerificationOptions != null) {
            String rawOptions = this.benchmark ? "--smc-benchmark " + this.benchmarkRuns + " " + this.rawVerificationOptions : this.rawVerificationOptions;
            return this.rawVerificationString(rawOptions, VerifyDTAPNOptions.traceArg(this.traceOption));
        }
        result.append(this.kBoundArg());
        result.append(this.deadTokenArg());
        result.append(VerifyDTAPNOptions.traceArg(this.traceOption));
        if (this.unfold && this.trace() != TAPNQuery.TraceOption.NONE || this.enabledOverApproximation || this.enabledUnderApproximation || this.isSmc && this.isSimulate && this.unfold) {
            result.append(this.writeUnfolded());
            result.append(" --bindings ");
        }
        if (!this.isSmc) {
            result.append(VerifyDTAPNOptions.searchArg(this.searchOption));
            result.append("--verification-method ");
            result.append(this.timeDarts ? "1" : "0");
            result.append(' ');
            result.append("--memory-optimization ");
            result.append(this.pTrie ? "1" : "0");
            if (!this.useStubbornReduction) {
                result.append(" --disable-partial-order ");
            }
        }
        if (this.workflow == TAPNQuery.WorkflowMode.WORKFLOW_SOUNDNESS) {
            result.append(" --workflow 1 ");
        } else if (this.workflow == TAPNQuery.WorkflowMode.WORKFLOW_STRONG_SOUNDNESS) {
            result.append(" --workflow 2 ");
            result.append(" --strong-workflow-bound ");
            result.append(this.workflowbound);
        }
        result.append(' ');
        if (this.workflow != TAPNQuery.WorkflowMode.WORKFLOW_SOUNDNESS && this.workflow != TAPNQuery.WorkflowMode.WORKFLOW_STRONG_SOUNDNESS) {
            result.append(this.gcd ? " --gcd-lower " : "");
        }
        if (this.isSmc) {
            result.append(this.parallel ? "--smc-parallel " : "");
            result.append((String)(this.benchmark ? "--smc-benchmark " + this.benchmarkRuns + " " : ""));
            result.append("--smc-obs-scale " + (this.maxGranularity ? 0 : this.granularity) + " ");
            result.append("--smc-print-cumulative-stats 4 ");
            result.append("--smc-numeric-precision " + Long.toUnsignedString(this.numericPrecision) + " ");
            if (this.isSimulate) {
                result.append(" --smc-traces ");
                result.append(this.numberOfTraces);
                result.append(" ");
                result.append(this.smcTraceType.getArg());
            }
        }
        return result.toString();
    }

    private String writeUnfolded() {
        if (Platform.isWindows()) {
            return " --write-unfolded-queries \"" + unfoldedQueriesPath + "\" --write-unfolded-net \"" + unfoldedModelPath + "\"";
        }
        return " --write-unfolded-queries " + unfoldedQueriesPath + " --write-unfolded-net " + unfoldedModelPath + " ";
    }

    public boolean timeDarts() {
        return this.timeDarts;
    }

    public boolean pTrie() {
        return this.pTrie;
    }

    public TAPNQuery.WorkflowMode getWorkflowMode() {
        return this.workflow;
    }

    public static String traceArg(TAPNQuery.TraceOption opt) {
        switch (opt) {
            case SOME: {
                return "--trace 1 ";
            }
            case FASTEST: {
                return "--trace 2 ";
            }
            default: {
                assert (false);
                break;
            }
            case NONE: 
        }
        return "--trace 0 ";
    }

    private static String searchArg(TAPNQuery.SearchOption arg) {
        switch (arg) {
            case BFS: {
                return "--search-strategy BFS ";
            }
            case DFS: {
                return "--search-strategy DFS ";
            }
            case RANDOM: {
                return "--search-strategy RDFS ";
            }
            case HEURISTIC: {
                return "--search-strategy BestFS ";
            }
            case OVERAPPROXIMATE: {
                return "--search-strategy OverApprox ";
            }
            default: {
                assert (false);
                break;
            }
            case DEFAULT: 
        }
        return "--search-strategy default ";
    }
}

