/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.verification.VerifyTAPN;

import dk.aau.cs.io.LoadedModel;
import dk.aau.cs.model.CPN.Color;
import dk.aau.cs.model.CPN.Variable;
import dk.aau.cs.model.tapn.TimedArcPetriNetNetwork;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.tapaal.gui.petrinet.Template;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import pipe.gui.petrinet.dataLayer.DataLayer;
import pipe.gui.petrinet.graphicElements.Transition;

public class ColorBindingParser
extends DefaultHandler {
    private Map<String, List<String>> bindings = new HashMap<String, List<String>>();
    private String currentElement = "";
    private String transitionId = "";
    private String variableId = "";
    private String color = "";

    public void addBindings(LoadedModel loadedModel, String output) {
        Map<String, List<String>> bindings = this.parseBindings(output);
        for (Template net : loadedModel.templates()) {
            for (Transition transition : net.guiModel().getTransitions()) {
                if (!bindings.containsKey(transition.getName())) continue;
                transition.setToolTipText(ColorBindingParser.createTooltip(bindings, transition));
            }
        }
    }

    public void addBindings(DataLayer guiModel, String output) {
        Map<String, List<String>> bindings = this.parseBindings(output);
        for (Transition transition : guiModel.getTransitions()) {
            if (!bindings.containsKey(transition.getName())) continue;
            transition.setToolTipText(ColorBindingParser.createTooltip(bindings, transition));
        }
    }

    public static String createTooltip(Map<String, List<String>> bindings, Transition transition) {
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        for (String binding : bindings.get(transition.getName())) {
            sb.append(binding);
            sb.append("<br>");
        }
        sb.append("</html>");
        return sb.toString();
    }

    public static String createTooltip(Map<Variable, Color> bindings) {
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        for (Map.Entry<Variable, Color> entry : bindings.entrySet()) {
            String bindingString = entry.getKey().getId() + " -> " + entry.getValue().getName();
            sb.append(bindingString);
            sb.append("<br>");
        }
        sb.append("</html>");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, List<String>> parseBindings(String output) {
        InputStream stream = null;
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            int start = output.indexOf("<bindings>");
            if (start == -1) {
                HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
                return hashMap;
            }
            int end = output.indexOf("</bindings>") + "</bindings>".length();
            String xml = output.substring(start, end);
            stream = new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8));
            parser.parse(new InputSource(new InputStreamReader(stream, StandardCharsets.UTF_8)), (DefaultHandler)this);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            e.printStackTrace();
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return this.bindings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Variable, Color> parseBindingsForSingleTransition(String output, String transitionName, final TimedArcPetriNetNetwork tapnNetwork) {
        final LinkedHashMap<Variable, Color> result = new LinkedHashMap<Variable, Color>();
        DefaultHandler handler = new DefaultHandler(this){
            private String currentElement = "";
            private String varId = "";
            private String colorValue = "";
            final /* synthetic */ ColorBindingParser this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void startElement(String uri, String localName, String qName, Attributes atts) {
                this.currentElement = qName;
                if ("variable".equals(qName)) {
                    this.varId = atts.getValue("id");
                }
            }

            @Override
            public void endElement(String uri, String localName, String qName) {
                if ("color".equals(qName)) {
                    Variable variable = tapnNetwork.getVariableByName(this.varId);
                    Color color = tapnNetwork.getColorByName(this.colorValue);
                    result.put(variable, color);
                } else if ("variable".equals(qName)) {
                    this.varId = "";
                    this.colorValue = "";
                }
                this.currentElement = "";
            }

            @Override
            public void characters(char[] ch, int start, int length) {
                if ("color".equals(this.currentElement)) {
                    this.colorValue = new String(ch, start, length);
                }
            }
        };
        InputStream stream = null;
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            int start = output.indexOf("<bindings>");
            if (start == -1) {
                LinkedHashMap<Variable, Color> linkedHashMap = result;
                return linkedHashMap;
            }
            int end = output.indexOf("</bindings>") + "</bindings>".length();
            String xml = output.substring(start, end);
            stream = new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8));
            parser.parse(new InputSource(new InputStreamReader(stream, StandardCharsets.UTF_8)), handler);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            e.printStackTrace();
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        switch (this.currentElement = qName) {
            case "transition": {
                this.transitionId = atts.getValue("id");
                break;
            }
            case "variable": {
                this.variableId = atts.getValue("id");
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equalsIgnoreCase("color")) {
            String binding = this.variableId + " -> " + this.color;
            this.bindings.computeIfAbsent(this.transitionId, k -> new ArrayList()).add(binding);
        } else if (qName.equalsIgnoreCase("transition")) {
            this.transitionId = "";
        } else if (qName.equalsIgnoreCase("variable")) {
            this.variableId = "";
            this.color = "";
        }
        this.currentElement = "";
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if ("color".equals(this.currentElement)) {
            this.color = new String(ch, start, length);
        }
    }
}

