/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.verification.UPPAAL;

import dk.aau.cs.model.CPN.ColorType;
import dk.aau.cs.model.NTA.trace.Participant;
import dk.aau.cs.model.NTA.trace.TAFiringAction;
import dk.aau.cs.model.NTA.trace.TimeDelayFiringAction;
import dk.aau.cs.model.NTA.trace.TransitionFiring;
import dk.aau.cs.model.NTA.trace.UppaalTrace;
import dk.aau.cs.model.tapn.TimedArcPetriNet;
import dk.aau.cs.model.tapn.TimedPlace;
import dk.aau.cs.model.tapn.TimedToken;
import dk.aau.cs.model.tapn.TimedTransition;
import dk.aau.cs.model.tapn.simulation.TimeDelayStep;
import dk.aau.cs.model.tapn.simulation.TimedArcPetriNetTrace;
import dk.aau.cs.model.tapn.simulation.TimedTransitionStep;
import dk.aau.cs.translations.TranslationNamingScheme;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class VerifytaTraceInterpreter {
    private final TimedArcPetriNet tapn;
    private final TranslationNamingScheme namingScheme;

    public VerifytaTraceInterpreter(TimedArcPetriNet model, TranslationNamingScheme namingScheme) {
        this.tapn = model;
        this.namingScheme = namingScheme;
    }

    protected TimedArcPetriNet tapn() {
        return this.tapn;
    }

    protected TranslationNamingScheme namingScheme() {
        return this.namingScheme;
    }

    public TimedArcPetriNetTrace interpretTrace(UppaalTrace trace) {
        return this.interpretTimedTrace(trace);
    }

    private TimedArcPetriNetTrace interpretTimedTrace(UppaalTrace trace) {
        boolean isConcreteTrace = trace.isConcreteTrace();
        TimedArcPetriNetTrace result = new TimedArcPetriNetTrace(isConcreteTrace);
        Iterator<TAFiringAction> iterator = trace.iterator();
        TAFiringAction action = null;
        while (iterator.hasNext()) {
            TranslationNamingScheme.TransitionTranslation[] transitions;
            ArrayList<TransitionFiring> firingSequence = new ArrayList<TransitionFiring>();
            ArrayList<String> firingSequenceNames = new ArrayList<String>();
            while (iterator.hasNext() && (action = iterator.next()) instanceof TransitionFiring) {
                firingSequence.add((TransitionFiring)action);
                firingSequenceNames.add(((TransitionFiring)action).channel());
            }
            for (TranslationNamingScheme.TransitionTranslation transitionTranslation : transitions = this.namingScheme.interpretTransitionSequence(firingSequenceNames)) {
                TimedTransitionStep transitionStep = this.interpretTransitionFiring(firingSequence, transitionTranslation, isConcreteTrace);
                result.add(transitionStep);
            }
            if (!(action instanceof TimeDelayFiringAction)) continue;
            BigDecimal delay = ((TimeDelayFiringAction)action).getDelay();
            TimeDelayStep delayAction = new TimeDelayStep(delay);
            result.add(delayAction);
        }
        return result;
    }

    protected TimedTransitionStep interpretTransitionFiring(List<TransitionFiring> firingSequence, TranslationNamingScheme.TransitionTranslation transitionTranslation, boolean isConcreteTrace) {
        TimedTransition transition = this.tapn.getTransitionByName(transitionTranslation.originalTransitionName());
        List<TimedToken> tokens = null;
        if (isConcreteTrace) {
            if (transitionTranslation.sequenceInfo().equals((Object)TranslationNamingScheme.TransitionTranslation.SequenceInfo.WHOLE)) {
                tokens = this.parseConsumedTokens(firingSequence.subList(transitionTranslation.startsAt(), transitionTranslation.endsAt() + 1));
            } else if (transitionTranslation.sequenceInfo().equals((Object)TranslationNamingScheme.TransitionTranslation.SequenceInfo.END)) {
                TransitionFiring start = firingSequence.get(transitionTranslation.startsAt());
                TransitionFiring end = firingSequence.get(transitionTranslation.endsAt());
                tokens = this.parseConsumedTokens(start, end);
            }
        }
        return new TimedTransitionStep(transition, tokens);
    }

    private List<TimedToken> parseConsumedTokens(List<TransitionFiring> actions) {
        ArrayList<TimedToken> tokens = new ArrayList<TimedToken>();
        for (int i = 0; i < actions.size(); ++i) {
            TransitionFiring action = actions.get(i);
            for (Participant participant : action.participants()) {
                String automata = participant.automata();
                String sourceLocation = participant.location();
                if (this.namingScheme.isIgnoredAutomata(automata) || this.namingScheme.isIgnoredPlace(sourceLocation)) continue;
                TimedPlace place = this.tapn.getPlaceByName(sourceLocation);
                BigDecimal clockValue = participant.clockOrVariableValue(this.namingScheme().tokenClockName()).lower();
                TimedToken token = new TimedToken(place, clockValue, ColorType.COLORTYPE_DOT.getFirstColor());
                tokens.add(token);
            }
        }
        return tokens;
    }

    private List<TimedToken> parseConsumedTokens(TransitionFiring start, TransitionFiring end) {
        ArrayList<TimedToken> tokens = new ArrayList<TimedToken>();
        for (Participant participant : end.participants()) {
            String automata = participant.automata();
            String sourceLocation = start.sourceState().locationFor(automata);
            if (this.namingScheme.isIgnoredAutomata(automata) || this.namingScheme.isIgnoredPlace(sourceLocation)) continue;
            TimedPlace place = this.tapn.getPlaceByName(sourceLocation);
            BigDecimal clockValue = start.sourceState().getLocalClockOrVariable(automata, this.namingScheme().tokenClockName()).lower();
            TimedToken token = new TimedToken(place, clockValue, ColorType.COLORTYPE_DOT.getFirstColor());
            tokens.add(token);
        }
        return tokens;
    }
}

