/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.verification.UPPAAL;

import dk.aau.cs.model.tapn.TAPNQuery;
import dk.aau.cs.verification.BoundednessAnalysisResult;
import dk.aau.cs.verification.InconclusiveBoundednessAnalysisResult;
import dk.aau.cs.verification.QueryResult;

public class VerifytaOutputParser {
    private static final String PROPERTY_IS_NOT_SATISFIED_STRING = "is NOT satisfied".toLowerCase();
    private static final String PROPERTY_IS_SATISFIED_STRING = "is satisfied".toLowerCase();
    private static final String DISCRETE_INCLUSION = "discrete inclusion".toLowerCase();
    private final boolean error = false;
    private boolean discreteInclusion = false;
    private final TAPNQuery query;

    public VerifytaOutputParser(TAPNQuery query) {
        this.query = query;
    }

    public boolean error() {
        return false;
    }

    public QueryResult parseOutput(String output) {
        String[] lines = output.split(System.getProperty("line.separator"));
        try {
            for (int i = 0; i < lines.length; ++i) {
                String line = lines[i].toLowerCase();
                if (line.contains(DISCRETE_INCLUSION)) {
                    this.discreteInclusion = true;
                }
                if (line.contains(PROPERTY_IS_SATISFIED_STRING)) {
                    return new QueryResult(true, (BoundednessAnalysisResult)new InconclusiveBoundednessAnalysisResult(), this.query, this.discreteInclusion);
                }
                if (!line.contains(PROPERTY_IS_NOT_SATISFIED_STRING)) continue;
                return new QueryResult(false, (BoundednessAnalysisResult)new InconclusiveBoundednessAnalysisResult(), this.query, this.discreteInclusion);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

