/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.verification;

import dk.aau.cs.model.tapn.simulation.TAPNNetworkTrace;
import dk.aau.cs.util.Tuple;
import dk.aau.cs.verification.VerificationResult;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.text.DecimalFormat;
import java.util.Comparator;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;

public class StatisticsPanel {
    public static JPanel createPanel(VerificationResult<TAPNNetworkTrace> result, boolean transitionPanel) {
        NonEditableModel model;
        Object[][] data;
        String[] columnNames;
        JPanel headLinePanel = new JPanel(new GridBagLayout());
        final JPanel fullPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(15, 0, 15, 15);
        gbc.anchor = 17;
        gbc.weightx = 2.0;
        gbc.weighty = 1.0;
        gbc.fill = 2;
        if (transitionPanel) {
            headLinePanel.add((Component)new JLabel(StatisticsPanel.toHTML("Number of times transitions were enabled during the search.\n"), 2), gbc);
        } else {
            headLinePanel.add((Component)new JLabel(StatisticsPanel.toHTML("Maximum number of tokens per place achieved during the search.\n"), 2), gbc);
        }
        if (transitionPanel) {
            columnNames = new String[]{"Count", "Transition"};
            data = StatisticsPanel.extractArrayFromTransitionStatistics(result);
            model = new NonEditableModel(data, columnNames);
        } else {
            columnNames = new String[]{"Max Tokens", "Place"};
            data = StatisticsPanel.extractArrayFromPlaceBoundStatistics(result);
            model = new NonEditableModel(data, columnNames);
        }
        JTable table = new JTable(model);
        Comparator comparator = (oo1, oo2) -> {
            String o1 = oo1.toString();
            String o2 = oo2.toString();
            boolean isFirstNumeric = o1.matches("\\d+");
            boolean isSecondNumeric = o2.matches("\\d+");
            if (isFirstNumeric) {
                if (isSecondNumeric) {
                    return Integer.valueOf(o2).compareTo(Integer.valueOf(o1));
                }
                return -1;
            }
            if (isSecondNumeric) {
                return 1;
            }
            return 0;
        };
        TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(table.getModel());
        sorter.setComparator(0, comparator);
        table.setRowSorter(sorter);
        JScrollPane scrollPane = new JScrollPane(table);
        scrollPane.setVerticalScrollBarPolicy(20);
        scrollPane.setHorizontalScrollBarPolicy(30);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        fullPanel.add((Component)headLinePanel, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 17;
        fullPanel.add((Component)scrollPane, gbc);
        fullPanel.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                Dialog dialog;
                Window window = SwingUtilities.getWindowAncestor(fullPanel);
                if (window instanceof Dialog && !(dialog = (Dialog)window).isResizable()) {
                    dialog.setResizable(true);
                    dialog.setMinimumSize(new Dimension(350, 300));
                    dialog.setPreferredSize(new Dimension(600, 400));
                }
            }
        });
        return fullPanel;
    }

    private static Object[][] extractArrayFromTransitionStatistics(VerificationResult<TAPNNetworkTrace> result) {
        List<Tuple<String, Number>> transitionStats = result.getTransitionStatistics();
        Object[][] out = new Object[transitionStats.size()][2];
        DecimalFormat formatter = new DecimalFormat("#.######");
        for (int i = 0; i < transitionStats.size(); ++i) {
            Number value = transitionStats.get(i).value2();
            Object displayValue = value.doubleValue() == -1.0 ? "unknown" : (value instanceof Integer || value.doubleValue() == (double)value.intValue() ? Integer.valueOf(value.intValue()) : formatter.format(value));
            Object[] line = new Object[]{displayValue, transitionStats.get(i).value1()};
            out[i] = line;
        }
        return out;
    }

    private static Object[][] extractArrayFromPlaceBoundStatistics(VerificationResult<TAPNNetworkTrace> result) {
        List<Tuple<String, Number>> placeBoundStats = result.getPlaceBoundStatistics();
        Object[][] out = new Object[placeBoundStats.size()][2];
        DecimalFormat formatter = new DecimalFormat("#.######");
        for (int i = 0; i < placeBoundStats.size(); ++i) {
            Number value = placeBoundStats.get(i).value2();
            Object displayValue = value.doubleValue() == -1.0 ? "unknown" : (value instanceof Integer || value.doubleValue() == (double)value.intValue() ? Integer.valueOf(value.intValue()) : formatter.format(value));
            Object[] line = new Object[]{displayValue, placeBoundStats.get(i).value1()};
            out[i] = line;
        }
        return out;
    }

    private static String toHTML(String string) {
        return "<html>" + string.replace(System.getProperty("line.separator"), "<br/>") + "</html>";
    }

    private static class NonEditableModel
    extends DefaultTableModel {
        NonEditableModel(Object[][] data, String[] columnNames) {
            super(data, columnNames);
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }
    }
}

