/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.verification;

import dk.aau.cs.model.tapn.simulation.TAPNNetworkTrace;
import dk.aau.cs.util.MemoryMonitor;
import dk.aau.cs.verification.QueryResult;
import dk.aau.cs.verification.SMCStats;
import dk.aau.cs.verification.StatisticsPanel;
import dk.aau.cs.verification.VerificationResult;
import dk.aau.cs.verification.VerifyTAPN.ObservationData;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import net.tapaal.swinghelpers.GridBagHelper;
import pipe.gui.graph.DefaultGraphDialog;
import pipe.gui.graph.Graph;
import pipe.gui.graph.GraphDialog;
import pipe.gui.graph.GraphPoint;
import pipe.gui.graph.MultiGraph;
import pipe.gui.graph.ObservationGraphDialog;

public class SMCResultPanel
extends JPanel {
    public SMCResultPanel(VerificationResult<TAPNNetworkTrace> result) {
        this.setLayout(new GridBagLayout());
        boolean quantitative = result.getQueryResult().isQuantitative();
        SMCStats stats = (SMCStats)result.getStats();
        JPanel resultPanel = this.createResultPanel(result, stats);
        JPanel statsPanel = this.createStatsPanel(stats, quantitative);
        JPanel estimates = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = GridBagHelper.as(0, 0, GridBagHelper.Anchor.WEST);
        gbc.weightx = 1.0;
        gbc.fill = 0;
        estimates.add((Component)new JLabel(result.getVerificationTimeString()), gbc);
        gbc = GridBagHelper.as(0, 1, GridBagHelper.Anchor.WEST);
        estimates.add((Component)new JLabel("Estimated memory usage: " + MemoryMonitor.getPeakMemory()), gbc);
        if (result.getRawOutput() != null) {
            JButton showRawQueryButton = new JButton("Show raw query results");
            showRawQueryButton.addActionListener(arg0 -> JOptionPane.showMessageDialog(this, this.createRawQueryPanel(result.getRawOutput()), "Raw query results", 1));
            estimates.add((Component)showRawQueryButton, GridBagHelper.as(1, 0, GridBagHelper.Anchor.EAST));
        }
        gbc = GridBagHelper.as(0, 0);
        gbc.fill = 2;
        this.add((Component)resultPanel, gbc);
        ++gbc.gridy;
        this.add((Component)statsPanel, gbc);
        ++gbc.gridy;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = new Insets(30, 0, 0, 0);
        this.add((Component)estimates, gbc);
    }

    private JPanel createResultPanel(VerificationResult<TAPNNetworkTrace> result, SMCStats stats) {
        List<GraphPoint> cumulativeStepPoints;
        QueryResult queryResult = result.getQueryResult();
        JPanel resultPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = GridBagHelper.as(0, 0, new Insets(20, 20, 20, 20));
        resultPanel.setBorder(BorderFactory.createTitledBorder("Query result"));
        resultPanel.add((Component)new JLabel("<html>" + queryResult.toString() + "</html>"), gbc);
        ArrayList<Graph> cumulativeGraphs = new ArrayList<Graph>();
        List<GraphPoint> cumulativeDelayPoints = stats.getCumulativeDelayPoints();
        if (!cumulativeDelayPoints.isEmpty()) {
            cumulativeGraphs.add(new Graph("Cumulative Probability / Delay", cumulativeDelayPoints, "Time", "Cumulative Probability", "Time"));
        }
        if (!(cumulativeStepPoints = stats.getCumulativeStepPoints()).isEmpty()) {
            cumulativeGraphs.add(new Graph("Cumulative Probability / Step", cumulativeStepPoints, "Number of Steps", "Cumulative Probability", "Step"));
        }
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        GridBagConstraints buttonGbc = new GridBagConstraints();
        buttonGbc.gridx = 0;
        buttonGbc.gridy = 0;
        buttonGbc.fill = 2;
        buttonGbc.anchor = 17;
        buttonGbc.insets = new Insets(0, 0, 10, 0);
        if (!cumulativeGraphs.isEmpty()) {
            DefaultGraphDialog.GraphDialogBuilder builder = new DefaultGraphDialog.GraphDialogBuilder();
            GraphDialog graphFrame = builder.addGraphs(cumulativeGraphs).setTitle("SMC Statistics").build();
            String btnText = "Plot cumulative statistics";
            JButton showCumulativeButton = new JButton(btnText);
            showCumulativeButton.addActionListener(arg0 -> graphFrame.display());
            buttonPanel.add((Component)showCumulativeButton, buttonGbc);
            ++buttonGbc.gridy;
        }
        if (!result.getTransitionStatistics().isEmpty()) {
            JButton transitionStatsButton = new JButton("Transition Statistics");
            transitionStatsButton.addActionListener(arg0 -> JOptionPane.showMessageDialog(this, StatisticsPanel.createPanel(result, true), "Transition Statistics", 1));
            buttonPanel.add((Component)transitionStatsButton, buttonGbc);
            ++buttonGbc.gridy;
        }
        if (!result.getPlaceBoundStatistics().isEmpty()) {
            JButton placeStatsButton = new JButton("Place-Bound Statistics");
            placeStatsButton.addActionListener(arg0 -> JOptionPane.showMessageDialog(this, StatisticsPanel.createPanel(result, false), "Place-Bound Statistics", 1));
            buttonPanel.add((Component)placeStatsButton, buttonGbc);
            ++buttonGbc.gridy;
        }
        buttonGbc.insets = new Insets(0, 0, 0, 0);
        Map<String, ObservationData> observationDataMap = stats.getObservationDataMap();
        if (!observationDataMap.isEmpty()) {
            ArrayList<MultiGraph> observationGraphs = new ArrayList<MultiGraph>();
            MultiGraph timeMultiGraph = new MultiGraph("Observation / Time", "Time", "Count", "Time");
            MultiGraph stepMultiGraph = new MultiGraph("Observation / Step", "Step", "Count", "Step");
            for (Map.Entry<String, ObservationData> entry : observationDataMap.entrySet()) {
                List<GraphPoint> observationStepPoints;
                List<GraphPoint> observationTimePoints;
                List<GraphPoint> maxStepPoints;
                List<GraphPoint> minStepPoints;
                List<GraphPoint> avgStepPoints;
                List<GraphPoint> maxTimePoints;
                List<GraphPoint> minTimePoints;
                String observationName = entry.getKey();
                ObservationData observationData = entry.getValue();
                List<GraphPoint> avgTimePoints = observationData.getSmcObservationAvgTime();
                if (!avgTimePoints.isEmpty()) {
                    timeMultiGraph.addGraph(observationName, "Avg Time", new Graph(avgTimePoints));
                }
                if (!(minTimePoints = observationData.getSmcObservationMinTime()).isEmpty()) {
                    timeMultiGraph.addGraph(observationName, "Min Time", new Graph(minTimePoints));
                }
                if (!(maxTimePoints = observationData.getSmcObservationMaxTime()).isEmpty()) {
                    timeMultiGraph.addGraph(observationName, "Max Time", new Graph(maxTimePoints));
                }
                if (!(avgStepPoints = observationData.getSmcObservationAvgStep()).isEmpty()) {
                    stepMultiGraph.addGraph(observationName, "Avg Step", new Graph(avgStepPoints));
                }
                if (!(minStepPoints = observationData.getSmcObservationMinStep()).isEmpty()) {
                    stepMultiGraph.addGraph(observationName, "Min Step", new Graph(minStepPoints));
                }
                if (!(maxStepPoints = observationData.getSmcObservationMaxStep()).isEmpty()) {
                    stepMultiGraph.addGraph(observationName, "Max Step", new Graph(maxStepPoints));
                }
                if (!(observationTimePoints = observationData.getSmcObservationValueTime()).isEmpty()) {
                    timeMultiGraph.addGraph(observationName, "Time", new Graph(observationTimePoints));
                }
                if (!(observationStepPoints = observationData.getSmcObservationValueStep()).isEmpty()) {
                    stepMultiGraph.addGraph(observationName, "Step", new Graph(observationStepPoints));
                }
                timeMultiGraph.addGlobalAvg(observationName + " Avg Time", observationData.getSmcGlobalAvgTime());
                stepMultiGraph.addGlobalAvg(observationName + " Avg Step", observationData.getSmcGlobalAvgStep());
            }
            if (!timeMultiGraph.isEmpty()) {
                observationGraphs.add(timeMultiGraph);
            }
            if (!stepMultiGraph.isEmpty()) {
                observationGraphs.add(stepMultiGraph);
            }
            ObservationGraphDialog.GraphDialogBuilder builder = new ObservationGraphDialog.GraphDialogBuilder();
            ObservationGraphDialog graphFrame = builder.addMultiGraphs(observationGraphs).setTitle("Observation Statistics").showGlobalAverages(true).isSimulate(queryResult.getQuery().isSimulate()).build();
            String btnText = "Plot observations";
            JButton showObservationButton = new JButton(btnText);
            buttonPanel.add((Component)showObservationButton, buttonGbc);
            showObservationButton.addActionListener(arg0 -> graphFrame.display());
        }
        resultPanel.add((Component)buttonPanel, GridBagHelper.as(1, 0, GridBagHelper.Anchor.WEST, new Insets(0, 0, 10, 0)));
        return resultPanel;
    }

    private JPanel createStatsPanel(SMCStats stats, boolean printRunsStats) {
        DecimalFormatSymbols decimalFormatSymbols = DecimalFormatSymbols.getInstance();
        decimalFormatSymbols.setDecimalSeparator('.');
        DecimalFormat verifTimeFormat = new DecimalFormat("#.######", decimalFormatSymbols);
        JPanel statsPanel = new JPanel(new GridBagLayout());
        statsPanel.setBorder(BorderFactory.createTitledBorder("Statistics"));
        JPanel validRunsPanel = new JPanel(new GridBagLayout());
        JPanel violatingRunsPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = GridBagHelper.as(0, 0, GridBagHelper.Anchor.WEST, new Insets(10, 0, 10, 30));
        JPanel generalStatsPanel = new JPanel(new GridBagLayout());
        this.addStatIfPositive(generalStatsPanel, "Executed runs: ", stats.getExecutedRuns(), gbc);
        this.addStatIfPositive(generalStatsPanel, "Average simulation time per run (ms): ", 1000.0 * (double)stats.getVerificationTime() / (double)stats.getExecutedRuns(), gbc, verifTimeFormat);
        gbc.gridy = 0;
        gbc.gridx = 3;
        this.addAvgStdDev(generalStatsPanel, "Average run duration: ", stats.getAverageRunTime(), stats.getRunTimeStdDev(), gbc);
        this.addAvgStdDev(generalStatsPanel, "Average run length: ", stats.getAverageRunLength(), stats.getRunLengthStdDev(), gbc);
        gbc = GridBagHelper.as(0, 0);
        statsPanel.add((Component)generalStatsPanel, gbc);
        validRunsPanel.setBorder(BorderFactory.createTitledBorder("Valid runs satisfying the property"));
        gbc = GridBagHelper.as(0, 0, GridBagHelper.Anchor.WEST, new Insets(5, 5, 5, 5));
        if (stats.getValidRuns() == 0) {
            validRunsPanel.add((Component)new JLabel("No valid run"), gbc);
        } else {
            this.addStatIfPositive(validRunsPanel, "Number: ", stats.getValidRuns(), gbc);
            this.addAvgStdDev(validRunsPanel, "Average duration: ", stats.getValidRunAverageTime(), stats.getValidRunTimeStdDev(), gbc);
            this.addAvgStdDev(validRunsPanel, "Average length: ", stats.getValidRunAverageLength(), stats.getValidRunLengthStdDev(), gbc);
        }
        violatingRunsPanel.setBorder(BorderFactory.createTitledBorder("Violating runs not satisfying the property"));
        gbc = GridBagHelper.as(0, 0, GridBagHelper.Anchor.WEST, new Insets(5, 5, 5, 5));
        if (stats.getViolatingRuns() == 0) {
            violatingRunsPanel.add((Component)new JLabel("No violating run"), gbc);
        } else {
            this.addStatIfPositive(violatingRunsPanel, "Number: ", stats.getViolatingRuns(), gbc);
            this.addAvgStdDev(violatingRunsPanel, "Average duration: ", stats.getViolatingRunAverageTime(), stats.getViolatingRunTimeStdDev(), gbc);
            this.addAvgStdDev(violatingRunsPanel, "Average length: ", stats.getViolatingRunAverageLength(), stats.getViolatingRunLengthStdDev(), gbc);
        }
        if (printRunsStats) {
            gbc = GridBagHelper.as(0, 1, GridBagHelper.Anchor.WEST, GridBagHelper.Fill.BOTH, new Insets(30, 0, 0, 0));
            JPanel specificStats = new JPanel(new GridLayout());
            specificStats.add((Component)validRunsPanel, gbc);
            specificStats.add((Component)violatingRunsPanel, gbc);
            statsPanel.add((Component)specificStats, gbc);
        }
        return statsPanel;
    }

    private void addAvgStdDev(JPanel panel, String label, double avg, double stdDev, GridBagConstraints gbc) {
        DecimalFormatSymbols decimalFormatSymbols = DecimalFormatSymbols.getInstance();
        decimalFormatSymbols.setDecimalSeparator('.');
        DecimalFormat format = new DecimalFormat("#.######", decimalFormatSymbols);
        if (avg < 0.0) {
            return;
        }
        String toPrint = format.format(avg);
        int x = gbc.gridx++;
        panel.add((Component)new JLabel(label), gbc);
        panel.add((Component)new JLabel(toPrint), gbc);
        ++gbc.gridx;
        if (stdDev >= 0.0) {
            JLabel sdLabel = new JLabel(" (SD: " + format.format(stdDev) + ")");
            sdLabel.setToolTipText("<html>Standard deviation. <br/>In normal distribution, 68% of all values are one standard deviation from the average, <br/>95% of values within two standard deviations <br/>and 99.99% within three standard deviations from the average.</html>");
            panel.add((Component)sdLabel, gbc);
        }
        gbc.gridx = x;
        ++gbc.gridy;
    }

    private void addStatIfPositive(JPanel panel, String label, double stat, GridBagConstraints gbc, DecimalFormat format) {
        if (stat < 0.0) {
            return;
        }
        int x = gbc.gridx++;
        panel.add((Component)new JLabel(label), gbc);
        panel.add((Component)new JLabel(format.format(stat)), gbc);
        gbc.gridx = x;
        ++gbc.gridy;
    }

    private void addStatIfPositive(JPanel panel, String label, int stat, GridBagConstraints gbc) {
        if (stat < 0) {
            return;
        }
        int x = gbc.gridx++;
        panel.add((Component)new JLabel(label), gbc);
        panel.add((Component)new JLabel(String.valueOf(stat)), gbc);
        gbc.gridx = x;
        ++gbc.gridy;
    }

    private JPanel createRawQueryPanel(String rawOutput) {
        final JPanel fullPanel = new JPanel(new GridBagLayout());
        JTextArea rawQueryLabel = new JTextArea(rawOutput);
        rawQueryLabel.setEditable(false);
        JScrollPane scroll = new JScrollPane(rawQueryLabel);
        scroll.setHorizontalScrollBarPolicy(32);
        scroll.setPreferredSize(new Dimension(640, 400));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        fullPanel.add((Component)scroll, gbc);
        fullPanel.addHierarchyListener(new HierarchyListener(){
            final /* synthetic */ SMCResultPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                Window window = SwingUtilities.getWindowAncestor(fullPanel);
                if (window instanceof Dialog) {
                    Dialog dialog = (Dialog)window;
                    dialog.setMinimumSize(dialog.getPreferredSize());
                    if (!dialog.isResizable()) {
                        dialog.setResizable(true);
                    }
                }
            }
        });
        return fullPanel;
    }
}

