/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.verification;

import dk.aau.cs.TCTL.visitors.HasDeadlockVisitor;
import dk.aau.cs.model.tapn.TAPNQuery;
import dk.aau.cs.verification.BoundednessAnalysisResult;
import dk.aau.cs.verification.QuantitativeResult;
import dk.aau.cs.verification.QueryType;
import net.tapaal.gui.petrinet.verification.TAPNQuery;

public class QueryResult {
    private final boolean satisfied;
    private final QuantitativeResult quantitativeResult;
    private boolean approximationInconclusive = false;
    private final boolean discreteInclusion;
    private final TAPNQuery query;
    private final BoundednessAnalysisResult boundednessAnalysis;
    private boolean solvedUsingQuerySimplification;
    private boolean solvedUsingTraceAbstractRefinement;
    private boolean solvedUsingSiphonTrap;
    public boolean isCTL = false;

    public boolean isSolvedUsingQuerySimplification() {
        return this.solvedUsingQuerySimplification;
    }

    public void setSolvedUsingQuerySimplification(boolean solvedUsingQuerySimplification) {
        this.solvedUsingQuerySimplification = solvedUsingQuerySimplification;
    }

    public boolean isSolvedUsingTraceAbstractRefinement() {
        return this.solvedUsingTraceAbstractRefinement;
    }

    public void setSolvedUsingTraceAbstractRefinement(boolean solvedUsingTraceAbstractRefinement) {
        this.solvedUsingTraceAbstractRefinement = solvedUsingTraceAbstractRefinement;
    }

    public boolean isSolvedUsingSiphonTrap() {
        return this.solvedUsingSiphonTrap;
    }

    public void setSolvedUsingSiphonTrap(boolean solvedUsingSiphonTrap) {
        this.solvedUsingSiphonTrap = solvedUsingSiphonTrap;
    }

    public QueryResult(boolean satisfied, BoundednessAnalysisResult boundednessAnalysis, TAPNQuery query, boolean discreteInclusion) {
        this.satisfied = satisfied;
        this.boundednessAnalysis = boundednessAnalysis;
        this.query = query;
        this.discreteInclusion = discreteInclusion;
        this.quantitativeResult = null;
    }

    public QueryResult(QuantitativeResult quantitativeResult, BoundednessAnalysisResult boundednessAnalysis, TAPNQuery query, boolean discreteInclusion) {
        this.satisfied = true;
        this.boundednessAnalysis = boundednessAnalysis;
        this.query = query;
        this.discreteInclusion = discreteInclusion;
        this.quantitativeResult = quantitativeResult;
    }

    public boolean isQuerySatisfied() {
        return this.satisfied;
    }

    public boolean isApproximationInconclusive() {
        return this.approximationInconclusive;
    }

    public void setApproximationInconclusive(boolean result) {
        this.approximationInconclusive = result;
    }

    public boolean isDiscreteIncludion() {
        return this.discreteInclusion;
    }

    public boolean hasDeadlock() {
        return new HasDeadlockVisitor().hasDeadLock(this.query.getProperty());
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        if (this.approximationInconclusive) {
            buffer.append(this.getInconclusiveString());
        } else if (this.quantitativeResult == null) {
            buffer.append("Property is ");
            buffer.append(this.satisfied ? "satisfied." : "not satisfied.");
        } else {
            buffer.append(this.quantitativeResult);
        }
        if (this.shouldAddExplanation()) {
            buffer.append(this.getExplanationString());
        }
        return buffer.toString();
    }

    public QueryType queryType() {
        return this.query.queryType();
    }

    private boolean shouldAddExplanation() {
        return this.queryType().equals((Object)QueryType.EF) && !this.isQuerySatisfied() || this.queryType().equals((Object)QueryType.EG) || this.queryType().equals((Object)QueryType.AF) || this.queryType().equals((Object)QueryType.AG) && this.isQuerySatisfied() || this.queryType().equals((Object)QueryType.A) || this.queryType().equals((Object)QueryType.E) || this.isSMC() || this.hasDeadlock() && !this.isQuerySatisfied() && this.queryType().equals((Object)QueryType.EF) || this.isQuerySatisfied() && this.queryType().equals((Object)QueryType.AG) || this.hasDeadlock() && this.boundednessAnalysis.isUPPAAL();
    }

    protected String getExplanationString() {
        if (this.isSMC()) {
            String stepBound;
            String timeBound = this.query.getSMCSettings().timeBound < Integer.MAX_VALUE ? String.valueOf(this.query.getSMCSettings().timeBound) : "&infin;";
            String string = stepBound = this.query.getSMCSettings().stepBound < Integer.MAX_VALUE ? String.valueOf(this.query.getSMCSettings().stepBound) : "&infin;";
            return "<br/><br/>The engine explored runs satisfying: time  &le; " + timeBound + " and steps &le; " + stepBound + (String)(this.isQuantitative() ? "<br/>Confidence level: " + this.query.getSMCSettings().confidence * 100.0f + "%" : (this.query.getSMCSettings().compareToFloat ? "<br/>Probability of false positive: " + this.query.getSMCSettings().falsePositives + "<br/>Probability of false negative: " + this.query.getSMCSettings().falseNegatives + "<br/>Indifference region: [" + (this.query.getSMCSettings().geqThan - this.query.getSMCSettings().indifferenceWidth) + ";" + (this.query.getSMCSettings().geqThan + this.query.getSMCSettings().indifferenceWidth) + "]" : ""));
        }
        return this.boundednessAnalysis.toString();
    }

    protected String getInconclusiveString() {
        return "The result of the approximation was inconclusive.";
    }

    public BoundednessAnalysisResult boundednessAnalysis() {
        return this.boundednessAnalysis;
    }

    public TAPNQuery getQuery() {
        return this.query;
    }

    public boolean isSMC() {
        return this.query.getCategory() == TAPNQuery.QueryCategory.SMC;
    }

    public boolean isQuantitative() {
        return this.quantitativeResult != null;
    }

    public String getProbabilityString() {
        return this.quantitativeResult.getProbabilityString();
    }
}

