/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.verification;

import dk.aau.cs.util.Tuple;
import java.util.HashMap;

public class NameMapping {
    private final HashMap<String, Tuple<String, String>> mappedNamesToOriginalNames = new HashMap();
    private final HashMap<Tuple<String, String>, String> originalToMappedNames = new HashMap();

    public void addMappingForShared(String objectName, String mappedName) {
        this.addMapping("", objectName, mappedName);
    }

    public void addMapping(String templateName, String objectName, String mappedName) {
        Tuple<String, String> value = new Tuple<String, String>(templateName, objectName);
        if (this.mappedNamesToOriginalNames.containsKey(mappedName)) {
            throw new RuntimeException(mappedName + " already maps to a value");
        }
        if (this.originalToMappedNames.containsKey(value)) {
            throw new RuntimeException(templateName + "." + objectName + " already maps to a value");
        }
        this.mappedNamesToOriginalNames.put(mappedName, value);
        this.originalToMappedNames.put(value, mappedName);
    }

    public Tuple<String, String> map(String key) {
        return this.mappedNamesToOriginalNames.getOrDefault(key, null);
    }

    public String map(String templateName, String objectName) {
        return this.originalToMappedNames.get(new Tuple<String, String>(templateName, objectName));
    }

    public HashMap<Tuple<String, String>, String> getOrgToMapped() {
        return this.originalToMappedNames;
    }
}

