/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.verification;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EngineHelperFunctions {
    public static String readVersionNumberFrom(InputStream stream, String strPattern) {
        String result = null;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(stream));
        StringBuilder sb = new StringBuilder();
        String versioninfo = null;
        try {
            int c;
            while (bufferedReader.ready() && (c = bufferedReader.read()) != -1 && c != 10) {
                sb.append((char)c);
            }
        }
        catch (IOException e) {
            return null;
        }
        versioninfo = sb.toString();
        Pattern pattern = Pattern.compile(strPattern);
        Matcher m = pattern.matcher(versioninfo);
        if (m.find()) {
            result = m.group(1);
            return result;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getVersion(String[] command, String strPattern) {
        String result = null;
        if (command[0] != null && !command[0].equals("") && new File(command[0]).exists()) {
            InputStream stream = null;
            Process child = null;
            try {
                child = Runtime.getRuntime().exec(command);
                stream = child.getInputStream();
                child.waitFor(2L, TimeUnit.SECONDS);
                if (stream != null) {
                    result = EngineHelperFunctions.readVersionNumberFrom(stream, strPattern);
                }
            }
            catch (IOException | InterruptedException e) {
                String string = null;
                return string;
            }
            finally {
                if (stream != null) {
                    child.destroyForcibly();
                }
            }
        }
        return result;
    }

    public static boolean versionIsEqualOrGreater(String versionStr, String versionToCompareStr) {
        String[] version = versionStr.split("-")[0].split("\\.");
        String[] targetVersion = versionToCompareStr.split("\\.");
        for (int i = 0; i < targetVersion.length; ++i) {
            int diff;
            if (version.length < i + 1) {
                version[i] = "0";
            }
            if ((diff = Integer.parseInt(version[i]) - Integer.parseInt(targetVersion[i])) > 0) {
                return true;
            }
            if (diff >= 0) continue;
            return false;
        }
        return true;
    }
}

