/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.verification;

import dk.aau.cs.verification.Boundedness;

public class BoundednessAnalysisResult {
    private final int maxUsedTokens;
    private final int totalTokens;
    private final int extraTokens;
    private boolean isUPPAAL;

    public BoundednessAnalysisResult(int totalTokens, int maxUsedTokens, int extraTokens) {
        this.maxUsedTokens = maxUsedTokens;
        this.totalTokens = totalTokens;
        this.extraTokens = extraTokens;
        this.isUPPAAL = false;
    }

    public BoundednessAnalysisResult(int totalTokens, int maxUsedTokens, int extraTokens, boolean isUPPAAL) {
        this(totalTokens, maxUsedTokens, extraTokens);
        this.isUPPAAL = isUPPAAL;
    }

    public String toString() {
        if (this.boundednessResult().equals((Object)Boundedness.Bounded)) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(System.getProperty("line.separator"));
        buffer.append(System.getProperty("line.separator"));
        buffer.append(String.format("Only markings with at most %1$d tokens (%2$d extra tokens)", this.totalTokens, this.extraTokens));
        buffer.append(System.getProperty("line.separator"));
        buffer.append("were explored. Try to increase the number of extra tokens.");
        return buffer.toString();
    }

    public Boundedness boundednessResult() {
        if (this.maxUsedTokens <= this.totalTokens) {
            return Boundedness.Bounded;
        }
        return Boundedness.NotBounded;
    }

    public int usedTokens() {
        return this.maxUsedTokens;
    }

    public int totalTokens() {
        return this.totalTokens;
    }

    public int tokensInNet() {
        return this.totalTokens - this.extraTokens;
    }

    public boolean isUPPAAL() {
        return this.isUPPAAL;
    }
}

