/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.util;

import dk.aau.cs.model.tapn.Bound;
import dk.aau.cs.model.tapn.RatBound;
import dk.aau.cs.model.tapn.TimeInterval;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.List;

public class IntervalOperations {
    public static RatBound getRatBound(Bound b) {
        if (b instanceof RatBound) {
            return (RatBound)b;
        }
        return new RatBound(new BigDecimal(b.value(), new MathContext(9)));
    }

    public static TimeInterval union(TimeInterval i1, TimeInterval i2) {
        if (i1 == null) {
            return i2;
        }
        if (i2 == null) {
            return i1;
        }
        if (IntervalOperations.intersection(i1, i2) == null) {
            return null;
        }
        TimeInterval lower = IntervalOperations.min(i1, i2, BoundToCheck.lower);
        TimeInterval upper = IntervalOperations.max(i1, i2, BoundToCheck.upper);
        return new TimeInterval(lower.isLowerBoundNonStrict(), lower.lowerBound(), upper.upperBound(), upper.isUpperBoundNonStrict());
    }

    public static TimeInterval intersection(TimeInterval i1, TimeInterval i2) {
        BigDecimal iLow;
        if (i1 == null || i2 == null) {
            return null;
        }
        TimeInterval upper = IntervalOperations.min(i1, i2, BoundToCheck.upper);
        TimeInterval lower = IntervalOperations.max(i1, i2, BoundToCheck.lower);
        BigDecimal iUp = IntervalOperations.getRatBound(upper.upperBound()).getBound();
        if (iUp.compareTo(iLow = IntervalOperations.getRatBound(lower.lowerBound()).getBound()) > 0 || iUp.compareTo(iLow) == 0 && lower.isLowerBoundNonStrict() && upper.isUpperBoundNonStrict() || upper.upperBound().value() < 0) {
            return new TimeInterval(lower.isLowerBoundNonStrict(), lower.lowerBound(), upper.upperBound(), upper.isUpperBoundNonStrict());
        }
        return null;
    }

    public static TimeInterval min(TimeInterval i1, TimeInterval i2, BoundToCheck b) {
        if (i1 == null) {
            return i2;
        }
        if (i2 == null) {
            return i1;
        }
        switch (b.ordinal()) {
            case 0: {
                BigDecimal b1 = IntervalOperations.getRatBound(i1.lowerBound()).getBound();
                BigDecimal b2 = IntervalOperations.getRatBound(i2.lowerBound()).getBound();
                if (b1.compareTo(b2) < 0 || b1.compareTo(b2) == 0 && i1.isLowerBoundNonStrict() && !i2.isLowerBoundNonStrict()) {
                    return i1;
                }
                return i2;
            }
            case 1: {
                BigDecimal b1 = IntervalOperations.getRatBound(i1.upperBound()).getBound();
                BigDecimal b2 = IntervalOperations.getRatBound(i2.upperBound()).getBound();
                if (b1.compareTo(BigDecimal.ZERO) >= 0 && b2.compareTo(BigDecimal.ZERO) >= 0) {
                    if (b1.compareTo(b2) < 0 || b1.compareTo(b2) == 0 && !i1.isUpperBoundNonStrict() && i2.isUpperBoundNonStrict()) {
                        return i1;
                    }
                    return i2;
                }
                if (b1.compareTo(BigDecimal.ZERO) < 0) {
                    return i2;
                }
                return i1;
            }
        }
        return null;
    }

    public static TimeInterval max(TimeInterval i1, TimeInterval i2, BoundToCheck b) {
        if (i1 == null) {
            return i2;
        }
        if (i2 == null) {
            return i1;
        }
        TimeInterval min = IntervalOperations.min(i1, i2, b);
        if (min.equals(i1)) {
            return i2;
        }
        return i1;
    }

    public static Bound getMaxNoInfBound(TimeInterval interval) {
        if (interval.upperBound() instanceof Bound.InfBound) {
            return interval.lowerBound();
        }
        return interval.upperBound();
    }

    public static ArrayList<TimeInterval> intersectingInterval(List<TimeInterval> IS1, List<TimeInterval> IS2) {
        ArrayList<TimeInterval> output = new ArrayList<TimeInterval>();
        if (IS1.size() < 1 || IS2.size() < 1) {
            return output;
        }
        boolean incrementI = false;
        int i = 0;
        int j = 0;
        while (i < IS1.size() && j < IS2.size()) {
            if (IS1.get(i) != null && IS2.get(j) != null) {
                RatBound i1up = IS1.get(i).upperBound() instanceof RatBound ? (RatBound)IS1.get(i).upperBound() : new RatBound(new BigDecimal(IS1.get(i).upperBound().value(), new MathContext(9)));
                RatBound i2up = IS2.get(j).upperBound() instanceof RatBound ? (RatBound)IS2.get(j).upperBound() : new RatBound(new BigDecimal(IS2.get(j).upperBound().value(), new MathContext(9)));
                if (IntervalOperations.intersection(IS1.get(i), IS2.get(j)) != null) {
                    output.add(IntervalOperations.intersection(IS1.get(i), IS2.get(j)));
                }
                if (i1up.compareTo(i2up) == -1 || i2up.compareTo(i1up) == 0 && (IS2.get(j).isUpperBoundNonStrict() == IS1.get(i).isUpperBoundNonStrict() || !IS1.get(i).isUpperBoundNonStrict())) {
                    incrementI = true;
                }
                if (i2up.compareTo(i1up) == -1 || i2up.compareTo(i1up) == 0 && (IS2.get(j).isUpperBoundNonStrict() == IS1.get(i).isUpperBoundNonStrict() || !IS2.get(j).isUpperBoundNonStrict())) {
                    ++j;
                }
                if (!incrementI) continue;
                ++i;
                incrementI = false;
                continue;
            }
            if (IS1.get(i) == null) {
                ++i;
            }
            if (IS2.get(j) != null) continue;
            ++j;
        }
        return output;
    }

    public static ArrayList<TimeInterval> unionIntervalSequences(List<TimeInterval> IS1, List<TimeInterval> IS2) {
        if (IS1.size() < 1) {
            return new ArrayList<TimeInterval>(IS2);
        }
        if (IS2.size() < 1) {
            return new ArrayList<TimeInterval>(IS1);
        }
        ArrayList<TimeInterval> output = new ArrayList<TimeInterval>();
        int i = 0;
        int j = 0;
        while (i < IS1.size() || j < IS2.size()) {
            TimeInterval temp = null;
            while (i < IS1.size() && j < IS2.size()) {
                RatBound i1up = IS1.get(i).upperBound() instanceof RatBound ? (RatBound)IS1.get(i).upperBound() : new RatBound(new BigDecimal(IS1.get(i).upperBound().value(), new MathContext(9)));
                RatBound i2up = IS2.get(j).upperBound() instanceof RatBound ? (RatBound)IS2.get(j).upperBound() : new RatBound(new BigDecimal(IS2.get(j).upperBound().value(), new MathContext(9)));
                RatBound i1lo = IS1.get(i).lowerBound() instanceof RatBound ? (RatBound)IS1.get(i).lowerBound() : new RatBound(new BigDecimal(IS1.get(i).lowerBound().value(), new MathContext(9)));
                RatBound i2lo = IS2.get(j).lowerBound() instanceof RatBound ? (RatBound)IS2.get(j).lowerBound() : new RatBound(new BigDecimal(IS2.get(j).lowerBound().value(), new MathContext(9)));
                if (IntervalOperations.intersection(IS1.get(i), IS2.get(j)) == null && (i1lo.compareTo(i2up) != 0 || !IS1.get(i).isLowerBoundNonStrict() && !IS2.get(j).isUpperBoundNonStrict()) && (i2lo.compareTo(i1up) != 0 || !IS2.get(j).isLowerBoundNonStrict() && !IS1.get(i).isUpperBoundNonStrict())) break;
                temp = IntervalOperations.union(temp, IntervalOperations.union(IS1.get(i), IS2.get(j)));
                if (i1up.compareTo(i2up) == 1 || i1up.compareTo(i2up) == 0 && !IS2.get(j).isUpperBoundNonStrict() && IS1.get(i).isUpperBoundNonStrict()) {
                    ++j;
                    continue;
                }
                if (i2up.compareTo(i1up) != 1 && (i2up.compareTo(i1up) != 0 || IS1.get(i).isUpperBoundNonStrict() || !IS2.get(j).isUpperBoundNonStrict())) break;
                ++i;
            }
            if (temp != null) {
                output.add(temp);
                ++i;
                ++j;
            } else if (i < IS1.size() && j < IS2.size() && IntervalOperations.min(IS1.get(i), IS2.get(j), BoundToCheck.upper).equals(IS1.get(i))) {
                output.add(IS1.get(i));
                ++i;
            } else if (i < IS1.size() && j < IS2.size() && IntervalOperations.min(IS2.get(j), IS1.get(i), BoundToCheck.upper).equals(IS2.get(j))) {
                output.add(IS2.get(j));
                ++j;
            }
            if (i > IS1.size() - 1) {
                for (int jTemp = j; jTemp < IS2.size(); ++jTemp) {
                    output.add(IS2.get(jTemp));
                }
                j = IS2.size() + 1;
            }
            if (j <= IS2.size() - 1) continue;
            for (int iTemp = i; iTemp < IS1.size(); ++iTemp) {
                output.add(IS1.get(iTemp));
            }
            i = IS1.size() + 1;
        }
        return output;
    }

    private static enum BoundToCheck {
        lower,
        upper;

    }
}

