/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.translations.tapn;

import dk.aau.cs.model.tapn.IntWeight;
import dk.aau.cs.model.tapn.LocalTimedPlace;
import dk.aau.cs.model.tapn.TAPNElement;
import dk.aau.cs.model.tapn.TimeInterval;
import dk.aau.cs.model.tapn.TimedArcPetriNet;
import dk.aau.cs.model.tapn.TimedInputArc;
import dk.aau.cs.model.tapn.TimedOutputArc;
import dk.aau.cs.model.tapn.TimedPlace;
import dk.aau.cs.model.tapn.TimedTransition;
import java.util.Hashtable;

public class TAPNToTimedConservativeTAPNConverter {
    public static final String BOTTOM = "_BOTTOMIN_";

    public TimedArcPetriNet makeConservative(TimedArcPetriNet model, Hashtable<String, Boolean> placeNameToTimed, int largestPresetSize) {
        TimedArcPetriNet conservativeModel = model.copy();
        TimedPlace bottom = conservativeModel.getPlaceByName(BOTTOM);
        if (bottom == null) {
            bottom = new LocalTimedPlace(BOTTOM);
            conservativeModel.add(bottom);
        }
        for (TimedTransition t : model.transitions()) {
            TAPNElement arc;
            int i;
            for (TimedInputArc ia : t.getInputArcs()) {
                if (!placeNameToTimed.get(ia.source().name()).booleanValue() || ia.getWeight().value() <= 1) continue;
                for (i = 1; i < ia.getWeight().value(); ++i) {
                    arc = new TimedInputArc(conservativeModel.getPlaceByName(ia.source().name()), conservativeModel.getTransitionByName(t.name()), TimeInterval.ZERO_INF);
                    arc.setTimeInterval(ia.interval());
                    conservativeModel.add((TimedInputArc)arc);
                }
            }
            for (TimedOutputArc oa : t.getOutputArcs()) {
                if (!placeNameToTimed.get(oa.destination().name()).booleanValue() || oa.getWeight().value() <= 1) continue;
                for (i = 1; i < oa.getWeight().value(); ++i) {
                    arc = new TimedOutputArc(conservativeModel.getTransitionByName(t.name()), conservativeModel.getPlaceByName(oa.destination().name()));
                    conservativeModel.add((TimedOutputArc)arc);
                }
            }
        }
        for (TimedTransition t : conservativeModel.transitions()) {
            TAPNElement arc;
            IntWeight weight1 = new IntWeight(1);
            int timedPresetSize = 0;
            for (TimedInputArc ia : t.getInputArcs()) {
                if (!placeNameToTimed.get(ia.source().name()).booleanValue()) continue;
                ia.setWeight(weight1);
                ++timedPresetSize;
            }
            int timedPostsetSize = 0;
            for (TimedOutputArc oa : t.getOutputArcs()) {
                if (!placeNameToTimed.get(oa.destination().name()).booleanValue()) continue;
                oa.setWeight(weight1);
                ++timedPostsetSize;
            }
            int difference = timedPostsetSize - timedPresetSize;
            if (difference < 0) {
                for (int i = 0; i < Math.abs(difference); ++i) {
                    arc = new TimedOutputArc(t, bottom);
                    conservativeModel.add((TimedOutputArc)arc);
                }
                continue;
            }
            if (difference <= 0) continue;
            for (int i = 0; i < difference; ++i) {
                arc = new TimedInputArc(bottom, t, TimeInterval.ZERO_INF);
                conservativeModel.add((TimedInputArc)arc);
            }
        }
        return conservativeModel;
    }
}

