/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.translations;

import dk.aau.cs.model.tapn.TimedInputArc;
import dk.aau.cs.model.tapn.TimedOutputArc;
import dk.aau.cs.model.tapn.TimedTransition;
import dk.aau.cs.util.Require;
import java.util.Hashtable;
import java.util.List;

public class Pairing {
    private final TimedTransition transition;
    private Hashtable<TimedInputArc, TimedOutputArc> inputArcToOutputArc = null;

    public Pairing(TimedTransition t) {
        this.transition = t;
    }

    protected void generatePairing() {
        int postsetSize;
        List<TimedInputArc> inputArcs = this.transition.getInputArcs();
        List<TimedOutputArc> outputArcs = this.transition.getOutputArcs();
        int presetSize = inputArcs.size();
        Require.that(presetSize == (postsetSize = outputArcs.size()), "The provided model is not conservative");
        for (int i = 0; i < presetSize; ++i) {
            this.add(inputArcs.get(i), outputArcs.get(i));
        }
    }

    protected void add(TimedInputArc inputArc, TimedOutputArc outputArc) {
        this.getInputArcToOutputArc().put(inputArc, outputArc);
    }

    public TimedOutputArc getOutputArcFor(TimedInputArc inputArc) {
        Require.that(this.getInputArcToOutputArc().containsKey(inputArc), "The given input arc is not in the preset of the transition");
        return this.getInputArcToOutputArc().get(inputArc);
    }

    protected TimedTransition getTransition() {
        return this.transition;
    }

    protected Hashtable<TimedInputArc, TimedOutputArc> getInputArcToOutputArc() {
        if (this.inputArcToOutputArc == null) {
            this.inputArcToOutputArc = new Hashtable();
            this.generatePairing();
        }
        return this.inputArcToOutputArc;
    }
}

