/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.translations;

import dk.aau.cs.model.tapn.TimedInputArc;
import dk.aau.cs.model.tapn.TimedOutputArc;
import dk.aau.cs.model.tapn.TimedTransition;
import dk.aau.cs.translations.Pairing;
import dk.aau.cs.util.Require;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Degree2Pairing
extends Pairing {
    public Degree2Pairing(TimedTransition t) {
        super(t);
    }

    @Override
    protected void generatePairing() {
        int postsetSize;
        List<TimedInputArc> inputArcs = this.getTransition().getInputArcs();
        List<TimedOutputArc> outputArcs = this.getTransition().getOutputArcs();
        int presetSize = inputArcs.size();
        Require.that(presetSize == (postsetSize = outputArcs.size()), "The provided model is not conservative");
        Require.that(presetSize <= 2, "The provided model is more than degree 2");
        if (this.getTransition().presetSizeWithoutInhibitorArcs() == 0) {
            return;
        }
        if (this.getTransition().getInputArcs().size() == 1) {
            this.add(this.getTransition().getInputArcs().get(0), this.getTransition().getOutputArcs().get(0));
        } else {
            block0: for (TimedInputArc inputArc : inputArcs) {
                if (this.isPartOfLockTemplate(inputArc.source().name())) {
                    for (TimedOutputArc outputArc : outputArcs) {
                        if (!this.isPartOfLockTemplate(outputArc.destination().name()) || this.getInputArcToOutputArc().containsValue(outputArc)) continue;
                        this.add(inputArc, outputArc);
                        continue block0;
                    }
                    continue;
                }
                for (TimedOutputArc outputArc : outputArcs) {
                    if (this.isPartOfLockTemplate(outputArc.destination().name()) || this.getInputArcToOutputArc().containsValue(outputArc)) continue;
                    this.add(inputArc, outputArc);
                    continue block0;
                }
            }
        }
    }

    private boolean isPartOfLockTemplate(String name) {
        Pattern pattern = Pattern.compile("^(P_(?:[a-zA-Z][a-zA-Z0-9_]*)_(?:(?:[0-9]*_(?:in|out)|check))|P_lock|P_deadlock)$");
        Matcher matcher = pattern.matcher(name);
        return matcher.find();
    }
}

