/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.translations;

import dk.aau.cs.model.CPN.ColorType;
import dk.aau.cs.model.tapn.IntBound;
import dk.aau.cs.model.tapn.LocalTimedPlace;
import dk.aau.cs.model.tapn.TimeInterval;
import dk.aau.cs.model.tapn.TimeInvariant;
import dk.aau.cs.model.tapn.TimedArcPetriNet;
import dk.aau.cs.model.tapn.TimedInhibitorArc;
import dk.aau.cs.model.tapn.TimedInputArc;
import dk.aau.cs.model.tapn.TimedOutputArc;
import dk.aau.cs.model.tapn.TimedPlace;
import dk.aau.cs.model.tapn.TimedToken;
import dk.aau.cs.model.tapn.TimedTransition;
import dk.aau.cs.model.tapn.TransportArc;
import dk.aau.cs.translations.Pairing;
import dk.aau.cs.translations.tapn.TAPNToConservativeTAPNConverter;
import java.util.ArrayList;
import java.util.List;

public class Degree2Converter {
    protected static final String T_MAX_FORMAT = "%1$s_%2$d";
    protected static final String T_I_OUT_FORMAT = "%1$s_%2$d_out";
    protected static final String T_I_IN_FORMAT = "%1$s_%2$d_in";
    protected static final String HOLDING_PLACE_FORMAT = "P_hp_%1$s_%2$d";
    protected static final String P_T_IN_FORMAT = "P_%1$s_%2$d_in";
    protected static final String P_T_OUT_FORMAT = "P_%1$s_%2$d_out";
    protected static final String PLOCK = "P_lock";
    private TimedArcPetriNet degree2Model;
    private TimedArcPetriNet conservativeModel;
    private final List<TimedTransition> retainedDegree2Transitions = new ArrayList<TimedTransition>();

    public TimedArcPetriNet transformModel(TimedArcPetriNet model) throws Exception {
        try {
            TAPNToConservativeTAPNConverter converter = new TAPNToConservativeTAPNConverter();
            this.conservativeModel = converter.makeConservative(model.copy());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        this.degree2Model = new TimedArcPetriNet(this.conservativeModel.name() + "_degree2");
        for (TimedPlace p : this.conservativeModel.places()) {
            TimedPlace copy = p.copy();
            this.degree2Model.add(copy);
            for (TimedToken token : p.tokens()) {
                this.degree2Model.addToken(new TimedToken(copy, token.color()));
            }
        }
        LocalTimedPlace plock = new LocalTimedPlace(PLOCK);
        this.degree2Model.add(plock);
        this.degree2Model.addToken(new TimedToken(plock, ColorType.COLORTYPE_DOT.getFirstColor()));
        for (TimedTransition t : this.conservativeModel.transitions()) {
            this.createDegree2TransitionSimulation(t);
        }
        return this.degree2Model;
    }

    public List<TimedTransition> getRetainedTransitions() {
        return this.retainedDegree2Transitions;
    }

    protected void createDegree2TransitionSimulation(TimedTransition t) {
        Pairing p = new Pairing(t);
        if ((this.isTransitionDegree1(t) || this.isTransitionDegree2(t)) && !t.hasInhibitorArcs()) {
            this.createCopyOfOriginalTransition(t, p);
        } else {
            this.createTransitionSimulation(t, p);
        }
    }

    private boolean isTransitionDegree1(TimedTransition t) {
        return t.presetSizeWithoutInhibitorArcs() == 1 && t.postsetSize() == 1;
    }

    private boolean isTransitionDegree2(TimedTransition t) {
        return t.presetSizeWithoutInhibitorArcs() == 2 && t.postsetSize() == 2;
    }

    private void createCopyOfOriginalTransition(TimedTransition transition, Pairing pairing) {
        TimedTransition t = new TimedTransition(transition.name());
        this.degree2Model.add(t);
        this.retainedDegree2Transitions.add(t);
        for (TimedInputArc inputArc : transition.getInputArcs()) {
            this.degree2Model.add(new TimedInputArc(this.degree2Model.getPlaceByName(inputArc.source().name()), t, inputArc.interval().copy(), inputArc.getArcExpression().copy()));
            this.degree2Model.add(new TimedOutputArc(t, this.degree2Model.getPlaceByName(pairing.getOutputArcFor(inputArc).destination().name())));
        }
        for (TransportArc transArc : transition.getTransportArcsGoingThrough()) {
            TransportArc transArcCopy = new TransportArc(this.degree2Model.getPlaceByName(transArc.source().name()), t, this.degree2Model.getPlaceByName(transArc.destination().name()), transArc.interval().copy());
            transArcCopy.setInputExpression(transArc.getInputExpression().copy());
            transArcCopy.setOutputExpression(transArc.getOutputExpression().copy());
            this.degree2Model.add(new TransportArc(this.degree2Model.getPlaceByName(transArc.source().name()), t, this.degree2Model.getPlaceByName(transArc.destination().name()), transArc.interval().copy()));
        }
    }

    protected void createTransitionSimulation(TimedTransition t, Pairing p) {
        this.createRingStructure(t, p);
        this.createArcsFromInputToOutputAccordingToPairing(t, p);
        this.createInhibitorArcs(t);
    }

    private void createRingStructure(TimedTransition transition, Pairing p) {
        String transitionName = transition.name();
        int transitionsToCreate = 2 * transition.presetSizeWithoutInhibitorArcs() - 1;
        LocalTimedPlace previousPlace = null;
        for (int i = 1; i <= (transitionsToCreate - 1) / 2; ++i) {
            String tiinName = String.format(T_I_IN_FORMAT, transitionName, i);
            TimedTransition tiin = new TimedTransition(tiinName);
            this.degree2Model.add(tiin);
            if (previousPlace == null) {
                this.degree2Model.add(new TimedInputArc(this.degree2Model.getPlaceByName(PLOCK), tiin, TimeInterval.ZERO_INF));
            }
            String ptName = String.format(P_T_IN_FORMAT, transitionName, i);
            LocalTimedPlace pt = new LocalTimedPlace(ptName, new TimeInvariant(true, new IntBound(0)), ColorType.COLORTYPE_DOT);
            this.degree2Model.add(pt);
            this.degree2Model.add(new TimedOutputArc(tiin, pt));
            if (previousPlace != null) {
                this.degree2Model.add(new TimedInputArc(previousPlace, tiin, TimeInterval.ZERO_INF));
            }
            previousPlace = pt;
            String holdingPlaceName = String.format(HOLDING_PLACE_FORMAT, transitionName, i);
            this.degree2Model.add(new LocalTimedPlace(holdingPlaceName, TimeInvariant.LESS_THAN_INFINITY, ColorType.COLORTYPE_DOT));
        }
        String tmaxName = String.format(T_MAX_FORMAT, transitionName, transitionsToCreate / 2 + 1);
        TimedTransition tmax = new TimedTransition(tmaxName);
        this.degree2Model.add(tmax);
        if (previousPlace != null) {
            this.degree2Model.add(new TimedInputArc(previousPlace, tmax, TimeInterval.ZERO_INF));
        } else {
            this.degree2Model.add(new TimedInputArc(this.degree2Model.getPlaceByName(PLOCK), tmax, TimeInterval.ZERO_INF));
        }
        TimedTransition previousTransition = tmax;
        for (int i = (transitionsToCreate - 1) / 2; i >= 1; --i) {
            String tiOutName = String.format(T_I_OUT_FORMAT, transitionName, i);
            TimedTransition tiOut = new TimedTransition(tiOutName);
            this.degree2Model.add(tiOut);
            String ptOutName = String.format(P_T_OUT_FORMAT, transitionName, i);
            LocalTimedPlace ptOut = new LocalTimedPlace(ptOutName, new TimeInvariant(true, new IntBound(0)), ColorType.COLORTYPE_DOT);
            this.degree2Model.add(ptOut);
            this.degree2Model.add(new TimedOutputArc(previousTransition, ptOut));
            this.degree2Model.add(new TimedInputArc(ptOut, tiOut, TimeInterval.ZERO_INF));
            previousTransition = tiOut;
        }
        this.degree2Model.add(new TimedOutputArc(previousTransition, this.degree2Model.getPlaceByName(PLOCK)));
    }

    private void createArcsFromInputToOutputAccordingToPairing(TimedTransition transition, Pairing pairing) {
        TimedPlace outputPlace;
        TimedTransition tiOut;
        TimedPlace pHolding;
        TimedTransition tiIn;
        TimedPlace inputPlace;
        int numPresetArcs = 1;
        String transitionName = transition.name();
        for (TimedInputArc inputArc : transition.getInputArcs()) {
            if (numPresetArcs == transition.presetSizeWithoutInhibitorArcs()) {
                TimedTransition tmax = this.degree2Model.getTransitionByName(String.format(T_MAX_FORMAT, transitionName, numPresetArcs));
                this.degree2Model.add(new TimedInputArc(this.degree2Model.getPlaceByName(inputArc.source().name()), tmax, inputArc.interval().copy()));
                this.degree2Model.add(new TimedOutputArc(tmax, this.degree2Model.getPlaceByName(pairing.getOutputArcFor(inputArc).destination().name())));
            } else {
                inputPlace = this.degree2Model.getPlaceByName(inputArc.source().name());
                tiIn = this.degree2Model.getTransitionByName(String.format(T_I_IN_FORMAT, transitionName, numPresetArcs));
                pHolding = this.degree2Model.getPlaceByName(String.format(HOLDING_PLACE_FORMAT, transitionName, numPresetArcs));
                this.degree2Model.add(new TimedInputArc(inputPlace, tiIn, inputArc.interval().copy()));
                this.degree2Model.add(new TimedOutputArc(tiIn, pHolding));
                tiOut = this.degree2Model.getTransitionByName(String.format(T_I_OUT_FORMAT, transitionName, numPresetArcs));
                outputPlace = this.degree2Model.getPlaceByName(pairing.getOutputArcFor(inputArc).destination().name());
                this.degree2Model.add(new TimedInputArc(pHolding, tiOut, TimeInterval.ZERO_INF));
                this.degree2Model.add(new TimedOutputArc(tiOut, outputPlace));
            }
            ++numPresetArcs;
        }
        for (TransportArc transArc : transition.getTransportArcsGoingThrough()) {
            if (numPresetArcs == transition.presetSizeWithoutInhibitorArcs()) {
                this.degree2Model.add(new TransportArc(this.degree2Model.getPlaceByName(transArc.source().name()), this.degree2Model.getTransitionByName(String.format(T_MAX_FORMAT, transitionName, numPresetArcs)), this.degree2Model.getPlaceByName(transArc.destination().name()), transArc.interval().copy()));
            } else {
                inputPlace = this.degree2Model.getPlaceByName(transArc.source().name());
                tiIn = this.degree2Model.getTransitionByName(String.format(T_I_IN_FORMAT, transitionName, numPresetArcs));
                pHolding = this.degree2Model.getPlaceByName(String.format(HOLDING_PLACE_FORMAT, transitionName, numPresetArcs));
                tiOut = this.degree2Model.getTransitionByName(String.format(T_I_OUT_FORMAT, transitionName, numPresetArcs));
                outputPlace = this.degree2Model.getPlaceByName(transArc.destination().name());
                TimeInterval newGuard = transArc.interval().intersect(transArc.destination().invariant());
                this.degree2Model.add(new TransportArc(inputPlace, tiIn, pHolding, newGuard));
                this.degree2Model.add(new TransportArc(pHolding, tiOut, outputPlace, TimeInterval.ZERO_INF));
            }
            ++numPresetArcs;
        }
    }

    private void createInhibitorArcs(TimedTransition t) {
        if (t.presetSizeWithoutInhibitorArcs() == 0) {
            return;
        }
        for (TimedInhibitorArc inhibArc : t.getInhibitorArcs()) {
            if (t.presetSizeWithoutInhibitorArcs() == 1) {
                this.degree2Model.add(new TimedInhibitorArc(this.degree2Model.getPlaceByName(inhibArc.source().name()), this.degree2Model.getTransitionByName(String.format(T_MAX_FORMAT, t.name(), 1)), inhibArc.interval().copy(), inhibArc.getArcExpression().copy()));
                continue;
            }
            this.degree2Model.add(new TimedInhibitorArc(this.degree2Model.getPlaceByName(inhibArc.source().name()), this.degree2Model.getTransitionByName(String.format(T_I_IN_FORMAT, t.name(), 1)), inhibArc.interval().copy(), inhibArc.getArcExpression().copy()));
        }
    }
}

