/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.model.tapn.simulation;

import dk.aau.cs.model.tapn.TimedToken;
import dk.aau.cs.model.tapn.simulation.ColoredTransitionStep;
import dk.aau.cs.model.tapn.simulation.PetriNetStep;
import dk.aau.cs.model.tapn.simulation.TimedTransitionStep;
import dk.aau.cs.util.Require;
import dk.aau.cs.verification.VerifyTAPN.TraceType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class TimedArcPetriNetTrace
implements Iterable<PetriNetStep> {
    private boolean nextIsLoop;
    private int loopToIndex = -1;
    private TraceType traceType;
    private String traceName;
    private boolean isColoredTrace;
    private final List<PetriNetStep> steps = new ArrayList<PetriNetStep>();
    private final boolean isTimedTrace;

    public TimedArcPetriNetTrace(boolean isTimedTrace, String traceName) {
        this.isTimedTrace = isTimedTrace;
        this.traceType = TraceType.NOT_EG;
        this.traceName = traceName;
    }

    public TimedArcPetriNetTrace(boolean isTimedTrace) {
        this.isTimedTrace = isTimedTrace;
        this.traceType = TraceType.NOT_EG;
        this.traceName = "";
    }

    public void add(PetriNetStep step) {
        if (step instanceof ColoredTransitionStep) {
            this.isColoredTrace = true;
        }
        if (this.nextIsLoop) {
            Require.that(this.loopToIndex == -1, "There can only be one step to loop to in a trace");
            this.loopToIndex = this.steps.size();
            this.nextIsLoop = false;
        }
        this.steps.add(step);
    }

    public String getTraceName() {
        return this.traceName;
    }

    public void setTraceName(String traceName) {
        this.traceName = traceName;
    }

    @Override
    @NotNull
    public Iterator<PetriNetStep> iterator() {
        return this.steps.iterator();
    }

    public int length() {
        return this.steps.size();
    }

    public boolean isEmpty() {
        return this.steps.isEmpty();
    }

    public PetriNetStep getLastStep() {
        if (this.steps.isEmpty()) {
            return null;
        }
        return this.steps.get(this.steps.size() - 1);
    }

    public boolean isTimedTrace() {
        return this.isTimedTrace;
    }

    public boolean isColoredTrace() {
        return this.isColoredTrace;
    }

    public void nextIsLoop() {
        this.nextIsLoop = true;
    }

    public int getLoopToIndex() {
        return this.loopToIndex;
    }

    public TraceType getTraceType() {
        return this.traceType;
    }

    public void setTraceType(TraceType traceType) {
        this.traceType = traceType;
    }

    public void reduceTraceForOriginalNet(String matchForTransition, String matchTokenRemoval) {
        block0: for (PetriNetStep step : this.steps) {
            if (!(step instanceof TimedTransitionStep)) continue;
            if (((TimedTransitionStep)step).transition().name().contains(matchForTransition)) {
                ((TimedTransitionStep)step).transition().setName(((TimedTransitionStep)step).transition().name().substring(0, ((TimedTransitionStep)step).transition().name().indexOf(matchForTransition)));
            }
            if (((TimedTransitionStep)step).consumedTokens() == null) continue;
            for (TimedToken token : ((TimedTransitionStep)step).consumedTokens()) {
                if (!token.place().name().contains(matchTokenRemoval)) continue;
                ((TimedTransitionStep)step).consumedTokens().remove(token);
                continue block0;
            }
        }
    }

    public void removeTokens(String matchTokenRemoval) {
        block0: for (PetriNetStep step : this.steps) {
            if (!(step instanceof TimedTransitionStep) || ((TimedTransitionStep)step).consumedTokens() == null) continue;
            for (TimedToken token : ((TimedTransitionStep)step).consumedTokens()) {
                if (!token.place().name().contains(matchTokenRemoval)) continue;
                ((TimedTransitionStep)step).consumedTokens().remove(token);
                continue block0;
            }
        }
    }
}

