/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.model.tapn.simulation;

import dk.aau.cs.model.tapn.NetworkMarking;
import dk.aau.cs.model.tapn.TimedToken;
import dk.aau.cs.model.tapn.TimedTransition;
import dk.aau.cs.model.tapn.simulation.TAPNNetworkTraceStep;
import dk.aau.cs.util.Require;
import java.util.List;

public class TAPNNetworkTimedTransitionStep
extends TAPNNetworkTraceStep {
    private final TimedTransition transition;
    private final List<TimedToken> consumedTokens;

    public TAPNNetworkTimedTransitionStep(TimedTransition transition, List<TimedToken> consumedTokens) {
        Require.that(transition != null, "transition cannot be null");
        this.transition = transition;
        this.consumedTokens = consumedTokens;
    }

    @Override
    public NetworkMarking performStepFrom(NetworkMarking marking) {
        return marking.fireTransition(this.transition, (List)this.consumedTokens);
    }

    public TimedTransition getTransition() {
        return this.transition;
    }

    public List<TimedToken> getConsumedTokens() {
        return this.consumedTokens;
    }

    @Override
    public boolean isTimedTransitionStep() {
        return true;
    }

    public String toString() {
        String toReturn = this.transition.isShared() ? this.transition.sharedTransition().name() : this.transition.toString();
        return this.isLoopStep() ? this.formatAsLoopStep(toReturn) : toReturn;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TAPNNetworkTimedTransitionStep)) {
            return false;
        }
        TAPNNetworkTimedTransitionStep other = (TAPNNetworkTimedTransitionStep)obj;
        if (!this.transition.equals(other.transition)) {
            return false;
        }
        return this.consumedTokens.equals(other.consumedTokens);
    }
}

