/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.model.tapn.simulation;

import dk.aau.cs.model.tapn.NetworkMarking;
import dk.aau.cs.model.tapn.simulation.TAPNNetworkTraceStep;
import java.math.BigDecimal;

public class TAPNNetworkTimeDelayStep
extends TAPNNetworkTraceStep {
    private BigDecimal delay;

    public TAPNNetworkTimeDelayStep(BigDecimal delay) {
        this.delay = delay;
    }

    @Override
    public NetworkMarking performStepFrom(NetworkMarking marking) {
        return marking.delay(this.delay);
    }

    public BigDecimal getDelay() {
        return this.delay;
    }

    public String toString() {
        String number = this.delay.toString();
        int index = number.indexOf(".");
        index = index < 0 ? number.length() : index;
        String padding = "";
        if (index < 4) {
            int numberOfSpacesToPad = (4 - index) * 2;
            padding = new String(new char[numberOfSpacesToPad]).replace("\u0000", " ");
        }
        String toReturn = "TimeDelay: " + padding + number;
        return this.isLoopStep() ? this.formatAsLoopStep(toReturn) : toReturn;
    }
}

