/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.model.tapn.simulation;

import dk.aau.cs.model.tapn.TimeInterval;
import dk.aau.cs.model.tapn.TimedTransition;
import dk.aau.cs.model.tapn.simulation.DelayMode;
import dk.aau.cs.util.IntervalOperations;
import java.math.BigDecimal;
import java.math.MathContext;

public class ShortestDelayMode
implements DelayMode {
    private static ShortestDelayMode instance;

    public static ShortestDelayMode getInstance() {
        if (instance == null) {
            instance = new ShortestDelayMode();
        }
        return instance;
    }

    private ShortestDelayMode() {
    }

    @Override
    public BigDecimal GetDelay(TimedTransition transition, TimeInterval dInterval, BigDecimal delayGranularity) {
        if (dInterval.isLowerBoundNonStrict()) {
            return IntervalOperations.getRatBound(dInterval.lowerBound()).getBound();
        }
        return IntervalOperations.getRatBound(dInterval.lowerBound()).getBound().add(delayGranularity, new MathContext(9));
    }

    public String toString() {
        return ShortestDelayMode.name();
    }

    public static String name() {
        return "Shortest delay";
    }
}

