/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.model.tapn.simulation;

import dk.aau.cs.model.tapn.TimeInterval;
import dk.aau.cs.model.tapn.TimedTransition;
import dk.aau.cs.model.tapn.simulation.DelayMode;
import dk.aau.cs.util.IntervalOperations;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.text.NumberFormatter;
import pipe.gui.TAPAALGUI;
import pipe.gui.swingcomponents.EscapableDialog;

public class ManualDelayMode
implements DelayMode {
    private static ManualDelayMode instance;
    TimeInterval dInterval;
    JButton okButton;
    boolean okPressed = false;
    JDialog dialog;

    public static ManualDelayMode getInstance() {
        if (instance == null) {
            instance = new ManualDelayMode();
        }
        return instance;
    }

    private ManualDelayMode() {
    }

    public String toString() {
        return ManualDelayMode.name();
    }

    public static String name() {
        return "Manual delay";
    }

    @Override
    public BigDecimal GetDelay(TimedTransition transition, TimeInterval dInterval, BigDecimal delayGranularity) {
        this.dInterval = dInterval;
        this.dialog = new EscapableDialog(TAPAALGUI.getApp(), "Choose delay", true);
        ChooseDelayPanel panel = new ChooseDelayPanel(transition, dInterval, delayGranularity);
        this.dialog.setContentPane(panel);
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(null);
        this.dialog.setVisible(true);
        BigDecimal result = this.okPressed ? panel.getResult() : null;
        return result;
    }

    private class ChooseDelayPanel
    extends JPanel {
        private final JSpinner spinner;

        public ChooseDelayPanel(TimedTransition transition, TimeInterval dInterval, BigDecimal delayGranularity) {
            super(new GridBagLayout());
            JPanel buttonPanel = this.createButtonPanel();
            BigDecimal value = IntervalOperations.getRatBound(dInterval.lowerBound()).getBound();
            if (!dInterval.isLowerBoundNonStrict()) {
                value = value.add(delayGranularity);
                value = value.stripTrailingZeros();
            }
            DelaySpinnerModel model = new DelaySpinnerModel(value, BigDecimal.ONE, dInterval);
            this.spinner = new JSpinner(model);
            JSpinner.NumberEditor editor = new JSpinner.NumberEditor(this.spinner);
            editor.getTextField().addActionListener(arg0 -> {
                ManualDelayMode.this.okButton.requestFocus();
                ManualDelayMode.this.okButton.doClick();
            });
            editor.getTextField().setFormatterFactory(new JFormattedTextField.AbstractFormatterFactory(this){
                final /* synthetic */ ChooseDelayPanel this$1;
                {
                    this.this$1 = this$1;
                }

                @Override
                public JFormattedTextField.AbstractFormatter getFormatter(JFormattedTextField tf) {
                    CustomNumberFormatter formatter = this.this$1.new CustomNumberFormatter();
                    DecimalFormat decimalFormat = new DecimalFormat("#.#####");
                    formatter.setFormat(decimalFormat);
                    formatter.setAllowsInvalid(false);
                    return formatter;
                }
            });
            this.spinner.setEditor(editor);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.fill = 2;
            gbc.weightx = 1.0;
            gbc.insets = new Insets(5, 5, 0, 5);
            this.add((Component)new JLabel("Choose delay from the interval: " + String.valueOf(dInterval)), gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.fill = 2;
            gbc.weightx = 1.0;
            gbc.insets = new Insets(5, 5, 0, 5);
            this.add((Component)this.spinner, gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.fill = 2;
            gbc.weightx = 1.0;
            gbc.insets = new Insets(5, 5, 0, 5);
            this.add((Component)buttonPanel, gbc);
        }

        private JPanel createButtonPanel() {
            JPanel buttonPanel = new JPanel(new FlowLayout(4));
            ManualDelayMode.this.okButton = new JButton("OK");
            ManualDelayMode.this.okButton.setPreferredSize(new Dimension(100, 25));
            ManualDelayMode.this.okButton.setMinimumSize(new Dimension(100, 25));
            ManualDelayMode.this.okButton.setMaximumSize(new Dimension(100, 25));
            ManualDelayMode.this.dialog.getRootPane().setDefaultButton(ManualDelayMode.this.okButton);
            ManualDelayMode.this.okButton.addActionListener(arg0 -> {
                ManualDelayMode.this.okPressed = true;
                ManualDelayMode.this.dialog.setVisible(false);
            });
            JButton cancelButton = new JButton("Cancel");
            cancelButton.setPreferredSize(new Dimension(100, 25));
            cancelButton.setMinimumSize(new Dimension(100, 25));
            cancelButton.setMaximumSize(new Dimension(100, 25));
            cancelButton.addActionListener(e -> {
                ManualDelayMode.this.okPressed = false;
                ManualDelayMode.this.dialog.setVisible(false);
            });
            buttonPanel.add(cancelButton);
            buttonPanel.add(ManualDelayMode.this.okButton);
            buttonPanel.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
            return buttonPanel;
        }

        private void updateOkButton(BigDecimal result) {
            if (result != null && ManualDelayMode.this.dInterval.isIncluded(result)) {
                ManualDelayMode.this.okButton.setEnabled(true);
            } else {
                ManualDelayMode.this.okButton.setEnabled(false);
            }
        }

        public BigDecimal getResult() {
            return (BigDecimal)this.spinner.getValue();
        }

        private class DelaySpinnerModel
        extends SpinnerNumberModel {
            final TimeInterval dInterval;

            public DelaySpinnerModel(Number value, Number stepSize, TimeInterval dInterval) {
                super(value, null, null, stepSize);
                this.dInterval = dInterval;
            }

            @Override
            public Object getNextValue() {
                BigDecimal currentValue = (BigDecimal)this.getValue();
                if (this.dInterval.isIncluded(currentValue.add(BigDecimal.ONE))) {
                    return currentValue.add(BigDecimal.ONE);
                }
                return null;
            }

            @Override
            public Object getPreviousValue() {
                BigDecimal currentValue = (BigDecimal)this.getValue();
                if (this.dInterval.isIncluded(currentValue.subtract(BigDecimal.ONE))) {
                    return currentValue.subtract(BigDecimal.ONE);
                }
                return null;
            }
        }

        private class CustomBigDecimal
        extends BigDecimal {
            final String stringRepres;

            public CustomBigDecimal(String string) {
                super(string.endsWith(".") && !string.matches(".*\\..*\\..*") ? string.substring(0, string.length() - 1) : string);
                this.stringRepres = string;
            }

            @Override
            public String toString() {
                return this.stringRepres;
            }
        }

        private class CustomNumberFormatter
        extends NumberFormatter {
            private CustomNumberFormatter() {
            }

            @Override
            public Object stringToValue(String string) throws ParseException {
                CustomBigDecimal result = null;
                try {
                    string = string.replace(DecimalFormatSymbols.getInstance().getDecimalSeparator(), '.');
                    if (string == null || string.isEmpty() || string.equals(".")) {
                        result = null;
                    } else {
                        if (string.contains(".") && string.substring(string.indexOf(".") + 1).length() > 5) {
                            throw new ParseException(string, 0);
                        }
                        result = new CustomBigDecimal(string);
                    }
                }
                catch (NumberFormatException e) {
                    throw new ParseException(string, 0);
                }
                ChooseDelayPanel.this.updateOkButton(result);
                return result;
            }

            @Override
            public String valueToString(Object arg0) throws ParseException {
                if (arg0 != null) {
                    return arg0.toString().replace('.', DecimalFormatSymbols.getInstance().getDecimalSeparator());
                }
                return null;
            }
        }
    }
}

