/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.model.tapn;

import dk.aau.cs.model.CPN.Color;
import dk.aau.cs.model.tapn.TimedPlace;
import java.math.BigDecimal;
import java.text.DecimalFormat;

public class TimedToken {
    private final TimedPlace place;
    protected BigDecimal age;
    private Color color;

    public TimedToken(TimedPlace place, Color color) {
        this(place, BigDecimal.ZERO, color);
    }

    public TimedToken(TimedPlace place, BigDecimal age, Color color) {
        this.place = place;
        this.age = age;
        this.color = color;
    }

    public Color color() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }

    public TimedPlace place() {
        return this.place;
    }

    public BigDecimal age() {
        return this.age;
    }

    public void setAge(BigDecimal age) {
        this.age = age;
    }

    public TimedToken clone() {
        return new TimedToken(this.place, this.age, this.color);
    }

    public TimedToken delay(BigDecimal delay) {
        return new TimedToken(this.place, this.age.add(delay), this.color);
    }

    public String toString() {
        DecimalFormat df = new DecimalFormat();
        df.setMaximumFractionDigits(5);
        return String.format("(%s, %s, %s)", this.place.toString(), df.format(this.age), this.color.toString());
    }

    public String toStringForPNML() {
        Object token = "";
        if (this.color.getTuple() != null && this.color.getTuple().size() != 0) {
            for (Color element : this.color.getTuple()) {
                token = (String)token + "(" + element.getColorName() + ")";
            }
            return (String)token;
        }
        token = (String)token + "(" + this.color.getColorName() + ")";
        return token;
    }

    public String getFormattedTokenString() {
        return this.color.getColorName();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.age == null ? 0 : this.age.hashCode());
        result = 31 * result + (this.place == null ? 0 : this.place.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimedToken)) {
            return false;
        }
        TimedToken other = (TimedToken)obj;
        if (this.age == null ? other.age != null : this.age.compareTo(other.age) != 0) {
            return false;
        }
        if (this.color == null ? other.color != null : !this.color.equals(other.color)) {
            return false;
        }
        return !(this.place == null ? other.place != null : !this.place.equals(other.place));
    }
}

