/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.model.tapn;

import dk.aau.cs.model.CPN.ColorType;
import dk.aau.cs.model.CPN.ColoredTimeInterval;
import dk.aau.cs.model.CPN.Expressions.ArcExpression;
import dk.aau.cs.model.CPN.Expressions.ColorExpression;
import dk.aau.cs.model.CPN.Expressions.NumberOfExpression;
import dk.aau.cs.model.CPN.Expressions.UserOperatorExpression;
import dk.aau.cs.model.tapn.IntWeight;
import dk.aau.cs.model.tapn.RatBound;
import dk.aau.cs.model.tapn.TAPNElement;
import dk.aau.cs.model.tapn.TimeInterval;
import dk.aau.cs.model.tapn.TimedArcPetriNet;
import dk.aau.cs.model.tapn.TimedPlace;
import dk.aau.cs.model.tapn.TimedToken;
import dk.aau.cs.model.tapn.TimedTransition;
import dk.aau.cs.model.tapn.Weight;
import dk.aau.cs.util.IntervalOperations;
import dk.aau.cs.util.Require;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class TimedInputArc
extends TAPNElement {
    private Weight weight = new IntWeight(1);
    private TimedPlace source;
    private TimeInterval interval;
    private final TimedTransition destination;
    private List<ColoredTimeInterval> colorTimeIntervals = new ArrayList<ColoredTimeInterval>();
    protected ArcExpression expression;

    public TimedInputArc(TimedPlace source, TimedTransition destination, TimeInterval interval) {
        this(source, destination, interval, new IntWeight(1), null);
    }

    public TimedInputArc(TimedPlace source, TimedTransition destination, TimeInterval interval, ArcExpression expression) {
        this(source, destination, interval, new IntWeight(1), expression);
    }

    public TimedInputArc(TimedPlace source, TimedTransition destination, TimeInterval interval, Weight weight, ArcExpression expression) {
        Require.that(source != null, "A timed input arc cannot have a null source place");
        Require.that(destination != null, "A timed input arc cannot have a null destination transition");
        Require.that(!source.isShared() || !destination.isShared(), "You cannot draw an arc between a shared transition and shared place.");
        this.source = source;
        this.destination = destination;
        this.setTimeInterval(interval);
        this.weight = weight;
        if (expression == null) {
            this.createNewArcExpression(source.getColorType());
        } else {
            this.expression = expression;
        }
    }

    public Weight getWeight() {
        return this.weight;
    }

    public Weight getWeightValue() {
        return new IntWeight(this.weight.value());
    }

    public void setWeight(Weight weight) {
        this.weight = weight;
    }

    public TimedPlace source() {
        return this.source;
    }

    public TimeInterval interval() {
        return this.interval;
    }

    public void setTimeInterval(TimeInterval interval) {
        Require.that(interval != null, "A timed input arc cannot have a null interval");
        this.interval = interval;
    }

    public TimedTransition destination() {
        return this.destination;
    }

    public boolean isEnabled() {
        return this.getElligibleTokens().size() >= this.weight.value();
    }

    public boolean isEnabledBy(TimedToken token) {
        Require.that(this.source.equals(token.place()), "This token is from a different place");
        return this.interval.isIncluded(token.age());
    }

    public List<TimedToken> getElligibleTokens() {
        ArrayList<TimedToken> elligbleTokens = new ArrayList<TimedToken>();
        List<TimedToken> tokens = this.source.tokens();
        for (TimedToken t : tokens) {
            if (!this.isEnabledBy(t)) continue;
            elligbleTokens.add(t);
        }
        return elligbleTokens;
    }

    @Override
    public void delete() {
        this.model().remove(this);
    }

    public TimedInputArc copy(TimedArcPetriNet tapn) {
        TimedInputArc tia = new TimedInputArc(tapn.getPlaceByName(this.source.name()), tapn.getTransitionByName(this.destination.name()), this.interval.copy(), this.weight, this.expression.copy());
        tia.setColorTimeIntervals(this.colorTimeIntervals);
        return tia;
    }

    public void setSource(TimedPlace place) {
        Require.that(place != null, "place cannot be null");
        this.source = place;
    }

    public String toString() {
        return "From " + this.source.name() + " to " + this.destination.name() + " with interval " + this.interval().toString() + " and arc expression " + this.expression.toString();
    }

    public String fromTo() {
        return "from " + this.source.name() + " to " + this.destination.name();
    }

    public List<TimeInterval> getDEnabledInterval() {
        ArrayList<TimeInterval> result = new ArrayList<TimeInterval>();
        BigDecimal iLow = IntervalOperations.getRatBound(this.interval.lowerBound()).getBound();
        BigDecimal iHeigh = IntervalOperations.getRatBound(this.interval.upperBound()).getBound();
        List<TimedToken> sortedTokens = this.source.sortedTokens();
        boolean overrideLowerInclusion = false;
        int i = 0;
        while (i + this.getWeight().value() - 1 < sortedTokens.size()) {
            int j = i + this.getWeight().value() - 1;
            TimedToken oldestToken = sortedTokens.get(i);
            TimedToken youngestToken = sortedTokens.get(j);
            TimeInterval temp = null;
            if (oldestToken.age().compareTo(iHeigh) <= 0 || iHeigh.compareTo(BigDecimal.ZERO) < 0) {
                BigDecimal newLower = iLow.subtract(youngestToken.age(), new MathContext(9));
                if (newLower.compareTo(BigDecimal.ZERO) < 0) {
                    overrideLowerInclusion = true;
                    newLower = BigDecimal.ZERO;
                }
                if (iHeigh.compareTo(BigDecimal.ZERO) >= 0) {
                    BigDecimal newUpper = iHeigh.subtract(oldestToken.age(), new MathContext(9));
                    if (newUpper.compareTo(BigDecimal.ZERO) < 0) {
                        newUpper = BigDecimal.ZERO;
                    }
                    temp = newUpper.compareTo(newLower) == 0 && (this.interval.isLowerBoundNonStrict() || overrideLowerInclusion) && this.interval.isUpperBoundNonStrict() ? new TimeInterval(true, new RatBound(newLower), new RatBound(newUpper), true) : (newLower.compareTo(newUpper) < 0 ? new TimeInterval(this.interval.isLowerBoundNonStrict() || overrideLowerInclusion, new RatBound(newLower), new RatBound(newUpper), this.interval.isUpperBoundNonStrict()) : null);
                } else {
                    temp = new TimeInterval(this.interval.isLowerBoundNonStrict(), new RatBound(newLower), this.interval.upperBound(), false);
                }
            }
            if (temp != null) {
                result = IntervalOperations.unionIntervalSequences(List.of(temp), result);
            }
            ++i;
        }
        return result;
    }

    public void createNewArcExpression(ColorType newColorType) {
        UserOperatorExpression userOperatorExpression = new UserOperatorExpression(newColorType.getFirstColor());
        Vector<ColorExpression> vecColorExpr = new Vector<ColorExpression>();
        vecColorExpr.add(userOperatorExpression);
        NumberOfExpression numbExpr = new NumberOfExpression(1, vecColorExpr);
        this.setExpression(numbExpr);
    }

    public ArcExpression getArcExpression() {
        return this.expression;
    }

    public void setExpression(ArcExpression expression) {
        this.expression = expression;
    }

    public List<ColoredTimeInterval> getColorTimeIntervals() {
        return this.colorTimeIntervals;
    }

    public void setColorTimeIntervals(List<ColoredTimeInterval> colorTimeIntervals) {
        this.colorTimeIntervals = colorTimeIntervals;
    }
}

