/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.model.tapn;

import dk.aau.cs.model.CPN.ColoredTimeInterval;
import dk.aau.cs.model.CPN.Expressions.ArcExpression;
import dk.aau.cs.model.tapn.Bound;
import dk.aau.cs.model.tapn.IntWeight;
import dk.aau.cs.model.tapn.RatBound;
import dk.aau.cs.model.tapn.TimeInterval;
import dk.aau.cs.model.tapn.TimedArcPetriNet;
import dk.aau.cs.model.tapn.TimedInputArc;
import dk.aau.cs.model.tapn.TimedPlace;
import dk.aau.cs.model.tapn.TimedToken;
import dk.aau.cs.model.tapn.TimedTransition;
import dk.aau.cs.model.tapn.Weight;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class TimedInhibitorArc
extends TimedInputArc {
    private List<ColoredTimeInterval> colorTimeIntervals = new ArrayList<ColoredTimeInterval>();

    public TimedInhibitorArc(TimedPlace source, TimedTransition destination, TimeInterval interval, ArcExpression expression) {
        this(source, destination, interval, new IntWeight(1), expression);
    }

    public TimedInhibitorArc(TimedPlace source, TimedTransition destination, TimeInterval interval, Weight weight, ArcExpression expression) {
        super(source, destination, TimeInterval.ZERO_INF, weight, expression);
    }

    public TimedInhibitorArc(TimedPlace source, TimedTransition destination) {
        this(source, destination, TimeInterval.ZERO_INF, new IntWeight(1), null);
    }

    @Override
    public List<TimeInterval> getDEnabledInterval() {
        if (this.source().tokens().size() < this.getWeight().value()) {
            return List.of(new TimeInterval(true, new RatBound(BigDecimal.ZERO), Bound.Infinity, false));
        }
        return new ArrayList<TimeInterval>();
    }

    @Override
    public void setTimeInterval(TimeInterval interval) {
        super.setTimeInterval(TimeInterval.ZERO_INF);
    }

    @Override
    public boolean isEnabled() {
        return !super.isEnabled();
    }

    @Override
    public boolean isEnabledBy(TimedToken token) {
        return !super.isEnabledBy(token);
    }

    @Override
    public List<TimedToken> getElligibleTokens() {
        ArrayList<TimedToken> elligbleTokens = new ArrayList<TimedToken>();
        List<TimedToken> tokens = this.source().tokens();
        for (TimedToken t : tokens) {
            if (this.isEnabledBy(t)) continue;
            elligbleTokens.add(t);
        }
        return elligbleTokens;
    }

    @Override
    public void delete() {
        this.model().remove(this);
    }

    @Override
    public TimedInhibitorArc copy(TimedArcPetriNet tapn) {
        return new TimedInhibitorArc(tapn.getPlaceByName(this.source().name()), tapn.getTransitionByName(this.destination().name()), this.interval().copy(), this.getWeight(), this.expression.copy());
    }
}

