/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.model.tapn;

import dk.aau.cs.model.CPN.Color;
import dk.aau.cs.model.CPN.ColorType;
import dk.aau.cs.model.CPN.ColoredTimeInvariant;
import dk.aau.cs.model.CPN.Expressions.ExpressionContext;
import dk.aau.cs.model.CPN.ProductType;
import dk.aau.cs.model.CPN.Variable;
import dk.aau.cs.model.tapn.Bound;
import dk.aau.cs.model.tapn.Constant;
import dk.aau.cs.model.tapn.ConstantBound;
import dk.aau.cs.model.tapn.ConstantProbability;
import dk.aau.cs.model.tapn.ConstantStore;
import dk.aau.cs.model.tapn.ConstantWeight;
import dk.aau.cs.model.tapn.LocalTimedMarking;
import dk.aau.cs.model.tapn.NetworkMarking;
import dk.aau.cs.model.tapn.Probability;
import dk.aau.cs.model.tapn.SharedPlace;
import dk.aau.cs.model.tapn.SharedTransition;
import dk.aau.cs.model.tapn.TimeInterval;
import dk.aau.cs.model.tapn.TimedArcPetriNet;
import dk.aau.cs.model.tapn.TimedInhibitorArc;
import dk.aau.cs.model.tapn.TimedInputArc;
import dk.aau.cs.model.tapn.TimedOutputArc;
import dk.aau.cs.model.tapn.TimedPlace;
import dk.aau.cs.model.tapn.TimedToken;
import dk.aau.cs.model.tapn.TimedTransition;
import dk.aau.cs.model.tapn.TransportArc;
import dk.aau.cs.model.tapn.Weight;
import dk.aau.cs.model.tapn.event.ConstantChangedEvent;
import dk.aau.cs.model.tapn.event.ConstantEvent;
import dk.aau.cs.model.tapn.event.ConstantsListener;
import dk.aau.cs.util.Require;
import dk.aau.cs.util.StringComparator;
import dk.aau.cs.util.Tuple;
import dk.aau.cs.verification.NameMapping;
import dk.aau.cs.verification.TAPNComposer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import net.tapaal.gui.petrinet.editor.ConstantsPane;
import net.tapaal.gui.petrinet.undo.Colored.RemoveColorTypeFromNetworkCommand;
import net.tapaal.gui.petrinet.undo.Colored.RemoveVariableFromNetworkCommand;
import net.tapaal.gui.petrinet.undo.Colored.UpdateColorTypeCommand;
import net.tapaal.gui.petrinet.undo.Colored.UpdatePTColorTypeCommand;
import net.tapaal.gui.petrinet.undo.Command;
import pipe.gui.MessengerImpl;
import pipe.gui.petrinet.undo.UndoManager;

public class TimedArcPetriNetNetwork {
    private final List<TimedArcPetriNet> tapns = new ArrayList<TimedArcPetriNet>();
    private final List<SharedPlace> sharedPlaces = new ArrayList<SharedPlace>();
    private final List<SharedTransition> sharedTransitions = new ArrayList<SharedTransition>();
    private NetworkMarking currentMarking = new NetworkMarking();
    private final ConstantStore constants;
    private List<ColorType> colorTypes = new ArrayList<ColorType>();
    private List<Variable> variables = new ArrayList<Variable>();
    private int defaultBound = 3;
    private final List<ConstantsListener> constantsListeners = new ArrayList<ConstantsListener>();
    private boolean paintNet = true;

    public TimedArcPetriNetNetwork() {
        this(new ConstantStore(), List.of(ColorType.COLORTYPE_DOT));
    }

    public TimedArcPetriNetNetwork(ConstantStore constants, List<ColorType> colorTypes) {
        this.constants = constants;
        this.colorTypes.addAll(colorTypes);
        this.buildConstraints();
    }

    public void addConstantsListener(ConstantsListener listener) {
        this.constantsListeners.add(listener);
    }

    public void removeConstantsListener(ConstantsListener listener) {
        this.constantsListeners.remove(listener);
    }

    public void add(TimedArcPetriNet tapn) {
        Require.that(tapn != null, "tapn must be non-null");
        tapn.setParentNetwork(this);
        this.tapns.add(tapn);
        LocalTimedMarking marking = tapn.marking() instanceof LocalTimedMarking ? (LocalTimedMarking)tapn.marking() : new LocalTimedMarking();
        this.currentMarking.addMarking(tapn, marking);
        tapn.setMarking(this.currentMarking);
    }

    public void add(SharedTransition sharedTransition) {
        this.add(sharedTransition, false);
    }

    public void add(SharedTransition sharedTransition, boolean multiAdd) {
        Require.that(sharedTransition != null, "sharedTransition must not be null");
        if (!multiAdd) {
            Require.that(!this.isNameUsed(sharedTransition.name()), "There is already a transition or place with that name");
        }
        sharedTransition.setNetwork(this);
        if (!this.sharedTransitions.contains(sharedTransition)) {
            this.sharedTransitions.add(sharedTransition);
        }
    }

    public void add(SharedPlace sharedPlace) {
        this.add(sharedPlace, false);
    }

    public void add(SharedPlace sharedPlace, boolean multiremove) {
        Require.that(sharedPlace != null, "sharedPlace must not be null");
        if (!multiremove) {
            Require.that(!this.isNameUsed(sharedPlace.name()), "There is already a transition or place with that name");
        }
        sharedPlace.setNetwork(this);
        sharedPlace.setCurrentMarking(this.currentMarking);
        if (!this.sharedPlaces.contains(sharedPlace)) {
            this.sharedPlaces.add(sharedPlace);
        }
    }

    public boolean isNameUsedForShared(String name) {
        for (SharedTransition transition : this.sharedTransitions) {
            if (!transition.name().equals(name)) continue;
            return true;
        }
        for (SharedPlace place : this.sharedPlaces) {
            if (!place.name().equals(name)) continue;
            return true;
        }
        return false;
    }

    private boolean isNameUsedInTemplates(String name) {
        for (TimedArcPetriNet net : this.tapns) {
            if (!net.isNameUsed(name)) continue;
            return true;
        }
        return false;
    }

    public boolean isNameUsedForPlacesOnly(String name) {
        for (TimedArcPetriNet net : this.tapns) {
            for (TimedTransition transition : net.transitions()) {
                if (!name.equals(transition.name())) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isNameUsedForTransitionsOnly(String name) {
        for (TimedArcPetriNet net : this.tapns) {
            for (TimedPlace place : net.places()) {
                if (!name.equals(place.name())) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isNameUsed(String name) {
        return this.isNameUsedForShared(name) || this.isNameUsedInTemplates(name);
    }

    public void remove(TimedArcPetriNet tapn) {
        if (tapn != null) {
            tapn.setParentNetwork(null);
            this.tapns.remove(tapn);
            this.currentMarking.removeMarkingFor(tapn);
        }
    }

    public void remove(SharedPlace sharedPlace) {
        if (sharedPlace != null) {
            sharedPlace.setNetwork(null);
            this.sharedPlaces.remove(sharedPlace);
        }
    }

    public void remove(SharedTransition sharedTransition) {
        if (sharedTransition != null) {
            sharedTransition.setNetwork(null);
            this.sharedTransitions.remove(sharedTransition);
            sharedTransition.delete();
        }
    }

    public List<TimedArcPetriNet> activeTemplates() {
        ArrayList<TimedArcPetriNet> activeTemplates = new ArrayList<TimedArcPetriNet>();
        for (TimedArcPetriNet t : this.tapns) {
            if (!t.isActive()) continue;
            activeTemplates.add(t);
        }
        return activeTemplates;
    }

    public List<TimedArcPetriNet> allTemplates() {
        return this.tapns;
    }

    public boolean hasTAPNCalled(String newName) {
        for (TimedArcPetriNet tapn : this.tapns) {
            if (!tapn.name().equalsIgnoreCase(newName)) continue;
            return true;
        }
        return false;
    }

    public NetworkMarking marking() {
        return this.currentMarking;
    }

    public void setMarking(NetworkMarking marking) {
        this.currentMarking = marking;
        for (TimedArcPetriNet tapn : this.tapns) {
            tapn.setMarking(this.currentMarking);
        }
    }

    public void buildConstraints() {
        this.constants.buildConstraints(this);
    }

    public Command addConstant(String name, int val) {
        Command cmd = this.constants.addConstant(name, val);
        Constant constant = this.constants.getConstantByName(name);
        this.fireConstantAdded(constant);
        return cmd;
    }

    private void fireConstantAdded(Constant constant) {
        for (ConstantsListener listener : this.constantsListeners) {
            listener.constantAdded(new ConstantEvent(constant, this.constants.getIndexOf(constant)));
        }
    }

    public Command removeConstant(String name) {
        Constant constant = this.constants.getConstantByName(name);
        int index = this.constants.getIndexOf(constant);
        Command cmd = this.constants.removeConstant(name);
        for (ConstantsListener listener : this.constantsListeners) {
            listener.constantRemoved(new ConstantEvent(constant, index));
        }
        return cmd;
    }

    public Command updateConstant(String oldName, Constant constant) {
        Constant old = this.constants.getConstantByName(oldName);
        int index = this.constants.getIndexOf(old);
        Command edit = this.constants.updateConstant(oldName, constant, this);
        if (edit != null) {
            this.updateGuardsAndWeightsWithNewConstant(oldName, constant);
            for (ConstantsListener listener : this.constantsListeners) {
                listener.constantChanged(new ConstantChangedEvent(old, constant, index));
            }
        }
        return edit;
    }

    public void updateGuardsAndWeightsWithNewConstant(String oldName, Constant newConstant) {
        for (TimedArcPetriNet tapn : this.allTemplates()) {
            for (TimedPlace place : tapn.places()) {
                this.updatePlaceInvariant(oldName, newConstant, place);
            }
            for (TimedTransition transition : tapn.transitions()) {
                this.updateProbability(oldName, newConstant, transition.getWeight());
            }
            for (TimedInputArc inputArc : tapn.inputArcs()) {
                this.updateTimeIntervalAndWeight(oldName, newConstant, inputArc.interval(), inputArc.getWeight());
            }
            for (TransportArc transArc : tapn.transportArcs()) {
                this.updateTimeIntervalAndWeight(oldName, newConstant, transArc.interval(), transArc.getWeight());
            }
            for (TimedInhibitorArc inhibArc : tapn.inhibitorArcs()) {
                this.updateTimeIntervalAndWeight(oldName, newConstant, inhibArc.interval(), inhibArc.getWeight());
            }
            for (TimedOutputArc outputArc : tapn.outputArcs()) {
                this.updateWeight(oldName, newConstant, outputArc.getWeight());
            }
        }
    }

    private void updatePlaceInvariant(String oldName, Constant newConstant, TimedPlace place) {
        this.updateBound(oldName, newConstant, place.invariant().upperBound());
    }

    private void updateTimeIntervalAndWeight(String oldName, Constant newConstant, TimeInterval interval, Weight weight) {
        this.updateBound(oldName, newConstant, interval.lowerBound());
        this.updateBound(oldName, newConstant, interval.upperBound());
        this.updateWeight(oldName, newConstant, weight);
    }

    private void updateBound(String oldName, Constant newConstant, Bound bound) {
        ConstantBound cb;
        if (bound instanceof ConstantBound && (cb = (ConstantBound)bound).name().equals(oldName)) {
            cb.setConstant(newConstant);
        }
    }

    private void updateWeight(String oldName, Constant newConstant, Weight weight) {
        ConstantWeight cw;
        if (weight instanceof ConstantWeight && (cw = (ConstantWeight)weight).constant().name().equals(oldName)) {
            cw.setConstant(newConstant);
        }
    }

    private void updateProbability(String oldName, Constant newConstant, Probability probability) {
        ConstantProbability cp;
        if (probability instanceof ConstantProbability && (cp = (ConstantProbability)probability).constant().name().equals(oldName)) {
            cp.setConstant(newConstant);
        }
    }

    public Collection<Constant> constants() {
        return this.constants.getConstants();
    }

    public Set<String> getConstantNames() {
        return this.constants.getConstantNames();
    }

    public int getConstantValue(String name) {
        return this.constants.getConstantByName(name).value();
    }

    public int getLargestConstantValue() {
        return this.constants.getLargestConstantValue();
    }

    public void setConstants(Iterable<Constant> constants) {
        for (Constant c : constants) {
            this.constants.add(c);
            this.fireConstantAdded(c);
        }
    }

    public Constant getConstant(String constantName) {
        return this.constants.getConstantByName(constantName);
    }

    public Constant getConstant(int index) {
        return this.constants.getConstantByIndex(index);
    }

    public ConstantStore getConstantStore() {
        return this.constants;
    }

    public TimedArcPetriNet getTAPNByName(String name) {
        for (TimedArcPetriNet tapn : this.tapns) {
            if (!tapn.name().equals(name)) continue;
            return tapn;
        }
        return null;
    }

    public int numberOfSharedPlaces() {
        return this.sharedPlaces.size();
    }

    public int numberOfSharedTransitions() {
        return this.sharedTransitions.size();
    }

    public SharedPlace getSharedPlaceByIndex(int index) {
        return this.sharedPlaces.get(index);
    }

    public Object getSharedTransitionByIndex(int index) {
        return this.sharedTransitions.get(index);
    }

    public Collection<SharedTransition> sharedTransitions() {
        return this.sharedTransitions;
    }

    public Collection<SharedPlace> sharedPlaces() {
        return this.sharedPlaces;
    }

    public SharedTransition getSharedTransitionByName(String name) {
        for (SharedTransition t : this.sharedTransitions) {
            if (!t.name().equals(name)) continue;
            return t;
        }
        return null;
    }

    public TimedPlace getSharedPlaceByName(String name) {
        for (SharedPlace place : this.sharedPlaces) {
            if (!place.name().equals(name)) continue;
            return place;
        }
        return null;
    }

    public boolean hasInhibitorArcs() {
        for (TimedArcPetriNet tapn : this.tapns) {
            if (!tapn.isActive() || !tapn.hasInhibitorArcs()) continue;
            return true;
        }
        return false;
    }

    public void swapTemplates(int currentIndex, int newIndex) {
        TimedArcPetriNet temp = this.tapns.get(currentIndex);
        this.tapns.set(currentIndex, this.tapns.get(newIndex));
        this.tapns.set(newIndex, temp);
    }

    public TimedArcPetriNet[] sortTemplates() {
        TimedArcPetriNet[] oldOrder = this.tapns.toArray(new TimedArcPetriNet[0]);
        this.tapns.sort(new StringComparator());
        return oldOrder;
    }

    public void undoSort(TimedArcPetriNet[] tapns) {
        this.tapns.clear();
        this.tapns.addAll(Arrays.asList(tapns));
    }

    public void swapConstants(int currentIndex, int newIndex) {
        this.constants.swapConstants(currentIndex, newIndex);
    }

    public Constant[] sortConstants() {
        return this.constants.sortConstants();
    }

    public void undoSort(Constant[] oldOrder) {
        this.constants.undoSort(oldOrder);
    }

    public void swapSharedPlaces(int currentIndex, int newIndex) {
        SharedPlace temp = this.sharedPlaces.get(currentIndex);
        this.sharedPlaces.set(currentIndex, this.sharedPlaces.get(newIndex));
        this.sharedPlaces.set(newIndex, temp);
    }

    public SharedPlace[] sortSharedPlaces() {
        SharedPlace[] oldOrder = this.sharedPlaces.toArray(new SharedPlace[0]);
        this.sharedPlaces.sort(new StringComparator());
        return oldOrder;
    }

    public void undoSort(SharedPlace[] oldOrder) {
        this.sharedPlaces.clear();
        this.sharedPlaces.addAll(Arrays.asList(oldOrder));
    }

    public void swapSharedTransitions(int currentIndex, int newIndex) {
        SharedTransition temp = this.sharedTransitions.get(currentIndex);
        this.sharedTransitions.set(currentIndex, this.sharedTransitions.get(newIndex));
        this.sharedTransitions.set(newIndex, temp);
    }

    public SharedTransition[] sortSharedTransitions() {
        SharedTransition[] oldOrder = this.sharedTransitions.toArray(new SharedTransition[0]);
        this.sharedTransitions.sort(new StringComparator());
        return oldOrder;
    }

    public void undoSort(SharedTransition[] oldOrder) {
        this.sharedTransitions.clear();
        this.sharedTransitions.addAll(Arrays.asList(oldOrder));
    }

    public boolean isColored() {
        for (TimedArcPetriNet tapn : this.tapns) {
            if (!tapn.isColored()) continue;
            return true;
        }
        return this.colorTypes.size() > 1 || this.variables.size() > 0;
    }

    public boolean isStochastic() {
        for (TimedArcPetriNet tapn : this.tapns) {
            if (!tapn.isStochastic()) continue;
            return true;
        }
        return false;
    }

    public boolean isUntimed() {
        for (TimedArcPetriNet t : this.tapns) {
            if (t.isUntimed()) continue;
            return false;
        }
        return true;
    }

    public boolean isTimed() {
        return !this.isUntimed();
    }

    public boolean hasWeights() {
        for (TimedArcPetriNet t : this.tapns) {
            if (!t.isActive() || !t.hasWeights()) continue;
            return true;
        }
        return false;
    }

    public boolean hasUrgentTransitions() {
        for (TimedArcPetriNet t : this.tapns) {
            if (!t.isActive() || !t.hasUrgentTransitions()) continue;
            return true;
        }
        return false;
    }

    public boolean hasUncontrollableTransitions() {
        for (TimedArcPetriNet t : this.tapns) {
            if (!t.isActive() || !t.hasUncontrollableTransitions()) continue;
            return true;
        }
        return false;
    }

    public boolean hasInvariants() {
        for (TimedArcPetriNet t : this.tapns) {
            if (!t.isActive()) continue;
            for (TimedPlace p : t.places()) {
                if (p.invariant().upperBound().equals(Bound.Infinity)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isNonStrict() {
        for (TimedArcPetriNet t : this.tapns) {
            if (!t.isActive() || t.isNonStrict()) continue;
            return false;
        }
        return true;
    }

    public boolean isDegree2() {
        TAPNComposer composer = new TAPNComposer(new MessengerImpl(), false);
        Tuple<TimedArcPetriNet, NameMapping> composedModel = composer.transformModel(this);
        return composedModel.value1().isDegree2();
    }

    public int getHighestNetDegree() {
        TAPNComposer composer = new TAPNComposer(new MessengerImpl(), false);
        Tuple<TimedArcPetriNet, NameMapping> composedModel = composer.transformModel(this);
        return composedModel.value1().getHighestNetDegree();
    }

    public boolean isSharedPlaceUsedInTemplates(SharedPlace place) {
        for (TimedArcPetriNet tapn : this.activeTemplates()) {
            for (TimedPlace timedPlace : tapn.places()) {
                if (!timedPlace.equals(place)) continue;
                return true;
            }
        }
        return false;
    }

    public int biggestConstantInActiveNet() {
        int biggestConstant = -1;
        for (TimedArcPetriNet tapn : this.activeTemplates()) {
            int tmp = tapn.getBiggestConstant();
            if (tmp <= biggestConstant) continue;
            biggestConstant = tmp;
        }
        return biggestConstant;
    }

    public int biggestContantInActiveNetEnabledTransitions() {
        int biggestConstant = -1;
        for (TimedArcPetriNet tapn : this.activeTemplates()) {
            int tmp = tapn.getBiggestConstantEnabledTransitions();
            if (tmp <= biggestConstant) continue;
            biggestConstant = tmp;
        }
        return biggestConstant;
    }

    public TimedArcPetriNetNetwork copy() {
        TimedArcPetriNetNetwork network = new TimedArcPetriNetNetwork();
        for (SharedPlace sharedPlace : this.sharedPlaces) {
            network.add(new SharedPlace(sharedPlace.name(), sharedPlace.invariant().copy(), sharedPlace.getColorType()));
            for (TimedToken token : this.currentMarking.getTokensFor(sharedPlace)) {
                network.currentMarking.add(token.clone());
            }
        }
        for (SharedTransition sharedTransition : this.sharedTransitions) {
            network.add(new SharedTransition(sharedTransition.name()));
        }
        for (Constant constant : this.constants()) {
            network.addConstant(constant.name(), constant.value());
        }
        for (TimedArcPetriNet timedArcPetriNet : this.tapns) {
            TimedArcPetriNet new_t = timedArcPetriNet.copy();
            network.add(new_t);
            for (TimedTransition trans : new_t.transitions()) {
                if (!trans.isShared()) continue;
                network.getSharedTransitionByName(trans.name()).makeShared(trans);
            }
        }
        network.setDefaultBound(this.getDefaultBound());
        return network;
    }

    public int getDefaultBound() {
        return this.defaultBound;
    }

    public void setDefaultBound(int defaultBound) {
        this.defaultBound = defaultBound;
    }

    public boolean paintNet() {
        return this.paintNet;
    }

    public void setPaintNet(boolean paintNet) {
        this.paintNet = paintNet;
    }

    public List<ColorType> colorTypes() {
        return this.colorTypes;
    }

    public void setColorTypes(List<ColorType> cts) {
        this.colorTypes = cts;
    }

    public List<Variable> variables() {
        return this.variables;
    }

    public void setVariables(List<Variable> newVariables) {
        this.variables = newVariables;
    }

    public void renameColorType(ColorType oldColorType, ColorType colorType, ConstantsPane.ColorTypesListModel colorTypesListModel, UndoManager undoManager) {
        Integer index = this.getColorTypeIndex(oldColorType.getName());
        UpdateColorTypeCommand command = new UpdateColorTypeCommand(this, oldColorType, colorType, index, colorTypesListModel);
        command.redo();
        undoManager.addEdit(command);
        this.updateProductTypes(oldColorType, colorType, undoManager);
    }

    public void updateColorType(ColorType oldColorType, ColorType colorType, ConstantsPane.ColorTypesListModel colorTypesListModel, UndoManager undoManager) {
        undoManager.newEdit();
        this.renameColorType(oldColorType, colorType, colorTypesListModel, undoManager);
    }

    private void updateProductTypes(ColorType oldColorType, ColorType colorType, UndoManager undoManager) {
        for (ColorType ct : this.colorTypes) {
            if (!(ct instanceof ProductType)) continue;
            UpdatePTColorTypeCommand command = new UpdatePTColorTypeCommand(oldColorType, colorType, (ProductType)ct);
            command.redo();
            undoManager.addEdit(command);
        }
    }

    public Integer getColorTypeIndex(String name) {
        for (int i = 0; i < this.colorTypes.size(); ++i) {
            if (!this.colorTypes.get(i).getName().equals(name)) continue;
            return i;
        }
        return null;
    }

    public ColorType getColorTypeByName(String name) {
        for (ColorType element : this.colorTypes) {
            if (!element.getName().equals(name)) continue;
            return element;
        }
        return null;
    }

    public Integer getVariableIndex(String name) {
        for (int i = 0; i < this.variables.size(); ++i) {
            if (!this.variables.get(i).getName().equals(name)) continue;
            return i;
        }
        return null;
    }

    public boolean isIndeticalToExisting(ColorType newColorType) {
        for (ColorType ct : this.colorTypes) {
            if (!ct.isIdentical(newColorType)) continue;
            return true;
        }
        return false;
    }

    public boolean isNameUsedForColorType(String name) {
        for (ColorType element : this.colorTypes) {
            if (!element.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public boolean isNameUsedForVariable(String name) {
        for (Variable element : this.variables) {
            if (!element.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public boolean isNameUsedForColor(String name, ColorType ignored) {
        for (ColorType e : this.colorTypes) {
            if (e == ignored || e.isIntegerRange() || e.isProductColorType()) continue;
            for (Color c : e.getColors()) {
                if (!c.getName().equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isNameUsedForConstant(String newName) {
        return this.constants.containsConstantByName(newName);
    }

    public Variable getVariableByName(String name) {
        for (Variable variable : this.variables) {
            if (!variable.getName().equals(name)) continue;
            return variable;
        }
        return null;
    }

    public Variable getVariableById(String id) {
        for (Variable variable : this.variables) {
            if (!variable.getId().equals(id)) continue;
            return variable;
        }
        return null;
    }

    public Color getColorByName(String name) {
        for (ColorType element : this.colorTypes) {
            if (element.getColorByName(name) == null) continue;
            return element.getColorByName(name);
        }
        return null;
    }

    public Color getProductColorByConstituents(Vector<Color> constituents) {
        for (ColorType ct : this.colorTypes) {
            if (!ct.isProductColorType()) continue;
            for (Color c : ct.getColors()) {
                if (c.getTuple() == null || !c.getTuple().equals(constituents)) continue;
                return c;
            }
        }
        return null;
    }

    public Variable getVariableByIndex(int index) {
        return this.variables.get(index);
    }

    public int numberOfColorTypes() {
        return this.colorTypes.size();
    }

    public ColorType getColorTypeByIndex(int index) {
        return this.colorTypes.get(index);
    }

    public int numberOfVariables() {
        return this.variables.size();
    }

    public void add(ColorType colorType) {
        if (colorType.equals(ColorType.COLORTYPE_DOT) && this.isNameUsedForColorType(ColorType.COLORTYPE_DOT.getName())) {
            return;
        }
        Require.that(colorType != null, "colorType must not be null");
        Require.that(!this.isNameUsedForColorType(colorType.getName()), "There is already a color type with that name");
        this.colorTypes.add(colorType);
    }

    public void add(Variable variable) {
        Require.that(variable != null, "variable must not be null");
        Require.that(!this.isNameUsedForVariable(variable.getName()), "There is already a variable with that name");
        this.variables.add(variable);
    }

    public boolean remove(ColorType colorType, ConstantsPane.ColorTypesListModel colorTypesListModel, UndoManager undoManager, ArrayList<String> messages) {
        Integer index = this.getColorTypeIndex(colorType.getName());
        if (this.canColorTypeBeRemoved(colorType, messages)) {
            RemoveColorTypeFromNetworkCommand command = new RemoveColorTypeFromNetworkCommand(colorType, this, colorTypesListModel, index);
            command.redo();
            undoManager.addEdit(command);
            return true;
        }
        return false;
    }

    public boolean canColorTypeBeRemoved(ColorType colorType, List<String> messages) {
        this.isColorTypeUsedInProduct(colorType, messages);
        this.isColorTypeUsedInVariable(colorType, messages);
        for (TimedArcPetriNet tapn : this.allTemplates()) {
            for (TimedPlace p : tapn.places()) {
                if (!p.getColorType().equals(colorType)) continue;
                messages.add("Color type " + p.getColorType().getName() + " is used in place " + p.name() + " \n");
            }
            for (TimedTransition t : tapn.transitions()) {
                for (Color c : colorType.getColors()) {
                    if (t.getGuard() == null || !t.getGuard().containsColor(c)) continue;
                    messages.add("Colors of color type " + colorType.getName() + " are used in transition " + t.name() + "\n");
                }
            }
        }
        return messages.isEmpty();
    }

    private void isColorTypeUsedInVariable(ColorType colorType, List<String> messages) {
        for (Variable variable : this.variables) {
            if (!variable.getColorType().equals(colorType)) continue;
            messages.add("Color type " + variable.getColorType().getName() + " is used in variable " + variable.getName() + "\n");
        }
    }

    public boolean canColorBeRemoved(Color color, List<String> messages) {
        for (TimedArcPetriNet tapn : this.allTemplates()) {
            for (TimedPlace timedPlace : tapn.places()) {
                if (timedPlace.getTokensAsExpression() != null && timedPlace.getTokensAsExpression().containsColor(color)) {
                    messages.add(color.getName() + " is used in a token in place " + timedPlace.name() + " \n");
                }
                for (ColoredTimeInvariant invariant : timedPlace.getCtiList()) {
                    if (!invariant.getColor().equals(color)) continue;
                    messages.add(color.getName() + " is used in an invariant in place " + timedPlace.name() + " \n");
                }
            }
            for (TimedTransition timedTransition : tapn.transitions()) {
                if (timedTransition.getGuard() == null || !timedTransition.getGuard().containsColor(color)) continue;
                messages.add(color.getName() + " of color type is used in transition " + timedTransition.name() + "\n");
            }
            for (TransportArc transportArc : tapn.transportArcs()) {
                if (transportArc.getInputExpression().containsColor(color)) {
                    messages.add(color.getName() + " is used on transport arc from " + transportArc.source().name() + " to " + String.valueOf(transportArc.transition()) + "\n");
                }
                if (!transportArc.getOutputExpression().containsColor(color)) continue;
                messages.add(color.getName() + " is used on transport arc from " + String.valueOf(transportArc.transition()) + " to " + transportArc.destination().name() + "\n");
            }
            for (TimedInputArc timedInputArc : tapn.inputArcs()) {
                if (!timedInputArc.getArcExpression().containsColor(color)) continue;
                messages.add(color.getName() + " is used on arc from " + timedInputArc.source().name() + " to " + timedInputArc.destination().name() + "\n");
            }
            for (TimedOutputArc timedOutputArc : tapn.outputArcs()) {
                if (!timedOutputArc.getExpression().containsColor(color)) continue;
                messages.add(color.getName() + " is used on arc from " + timedOutputArc.source().name() + " to " + timedOutputArc.destination().name() + "\n");
            }
        }
        return messages.isEmpty();
    }

    private void isColorTypeUsedInProduct(ColorType colorType, List<String> messages) {
        for (ColorType ct : this.colorTypes) {
            if (!(ct instanceof ProductType) || !((ProductType)ct).contains(colorType)) continue;
            messages.add("Color type " + colorType.getName() + " is used in product type " + ct.getName() + " \n");
        }
    }

    public void remove(Variable variable, ConstantsPane.VariablesListModel variablesListModel, UndoManager undoManager, List<String> messages) {
        if (this.canVariableBeRemoved(variable, messages)) {
            Integer index = this.getVariableIndex(variable.getName());
            RemoveVariableFromNetworkCommand command = new RemoveVariableFromNetworkCommand(variable, this, variablesListModel, index);
            command.redo();
            undoManager.addEdit(command);
        }
    }

    public void remove(Variable variable) {
        if (variable != null) {
            this.variables.remove(variable);
        }
    }

    public boolean canVariableBeRemoved(Variable variable, List<String> messages) {
        for (TimedArcPetriNet tapn : this.allTemplates()) {
            HashSet<Variable> variables;
            for (TimedInputArc timedInputArc : tapn.inputArcs()) {
                variables = new HashSet<Variable>();
                timedInputArc.getArcExpression().getVariables(variables);
                if (!variables.contains(variable)) continue;
                messages.add("Variable contained on input arc " + timedInputArc.fromTo());
            }
            for (TimedOutputArc timedOutputArc : tapn.outputArcs()) {
                variables = new HashSet();
                timedOutputArc.getExpression().getVariables(variables);
                if (!variables.contains(variable)) continue;
                messages.add("Variable contained on output arc " + String.valueOf(timedOutputArc));
            }
            for (TransportArc transportArc : tapn.transportArcs()) {
                variables = new HashSet();
                transportArc.getInputExpression().getVariables(variables);
                transportArc.getOutputExpression().getVariables(variables);
                if (!variables.contains(variable)) continue;
                messages.add("Variable contained on transport arc " + transportArc.fromTo());
            }
            for (TimedTransition timedTransition : tapn.transitions()) {
                if (timedTransition.getGuard() == null) continue;
                variables = new HashSet();
                timedTransition.getGuard().getVariables(variables);
                if (!variables.contains(variable)) continue;
                messages.add("Variable contained in guard of transition " + timedTransition.name());
            }
        }
        return messages.isEmpty();
    }

    public ColorType[] sortColorTypes() {
        ColorType[] oldorder = this.colorTypes.toArray(new ColorType[0]);
        this.colorTypes.sort(new StringComparator());
        return oldorder;
    }

    public void undoSort(ColorType[] oldorder) {
        this.colorTypes.clear();
        this.colorTypes.addAll(Arrays.asList(oldorder));
    }

    public void swapColorTypes(int currentIndex, int newIndex) {
        ColorType temp = this.colorTypes.get(currentIndex);
        this.colorTypes.set(currentIndex, this.colorTypes.get(newIndex));
        this.colorTypes.set(newIndex, temp);
    }

    public void swapVariables(int currentIndex, int newIndex) {
        Variable temp = this.variables.get(currentIndex);
        this.variables.set(currentIndex, this.variables.get(newIndex));
        this.variables.set(newIndex, temp);
    }

    public Variable[] sortVariables() {
        Variable[] oldOrder = this.variables.toArray(new Variable[0]);
        this.variables.sort(new StringComparator());
        return oldOrder;
    }

    public void undoSort(Variable[] oldOrder) {
        this.variables.clear();
        this.variables.addAll(Arrays.asList(oldOrder));
    }

    public ExpressionContext getContext() {
        HashMap<String, ColorType> hashMap = new HashMap<String, ColorType>();
        for (ColorType colorType : this.colorTypes) {
            hashMap.put(colorType.getName(), colorType);
        }
        return new ExpressionContext(new HashMap<String, Color>(), hashMap);
    }
}

