/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.model.tapn;

import dk.aau.cs.model.tapn.Bound;
import dk.aau.cs.model.tapn.ConstantBound;
import dk.aau.cs.model.tapn.ConstantStore;
import dk.aau.cs.model.tapn.IntBound;
import dk.aau.cs.model.tapn.RatBound;
import dk.aau.cs.model.tapn.TimeInterval;
import dk.aau.cs.util.IntervalOperations;
import dk.aau.cs.util.Require;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TimeInvariant {
    public static final TimeInvariant LESS_THAN_INFINITY = new TimeInvariant(false, Bound.Infinity);
    protected final boolean isUpperIncluded;
    private final Bound upper;

    public TimeInvariant(boolean isUpperIncluded, Bound upper) {
        Require.that(upper != null, "bound cannot be null");
        Require.that(isUpperIncluded || !isUpperIncluded && upper.value() != 0, "\"< 0\" is and invalid invariant.");
        Require.that(upper != Bound.Infinity || !isUpperIncluded, "\"<=inf\" is not a valid invariant");
        this.isUpperIncluded = isUpperIncluded;
        this.upper = upper;
    }

    public Bound upperBound() {
        return this.upper;
    }

    public boolean isUpperNonstrict() {
        return this.isUpperIncluded;
    }

    public boolean isSatisfied(BigDecimal age) {
        if (this.upper instanceof Bound.InfBound) {
            return true;
        }
        int comparison = age.compareTo(new BigDecimal(this.upper.value()));
        return this.isUpperIncluded ? comparison <= 0 : comparison < 0;
    }

    public static TimeInvariant parse(String invariant, ConstantStore constants) {
        Pattern pattern = Pattern.compile("^(<|<=)\\s*(\\w+)$");
        Matcher matcher = pattern.matcher(invariant);
        matcher.find();
        String operator = matcher.group(1);
        String boundAsString = matcher.group(2);
        if (operator.equals("<") && boundAsString.equals("0")) {
            return null;
        }
        if (operator.equals("<=") && boundAsString.equals("inf")) {
            return null;
        }
        Bound bound = null;
        if (boundAsString.equals("inf")) {
            bound = Bound.Infinity;
        } else {
            try {
                int intBound = Integer.parseInt(boundAsString);
                bound = new IntBound(intBound);
            }
            catch (NumberFormatException e) {
                if (constants.containsConstantByName(boundAsString)) {
                    bound = new ConstantBound(constants.getConstantByName(boundAsString));
                }
                throw new RuntimeException("A constant which was not declared was used in an invariant.");
            }
        }
        return new TimeInvariant(operator.equals("<="), bound);
    }

    public TimeInvariant copy() {
        return new TimeInvariant(this.isUpperIncluded, this.upper.copy());
    }

    public TimeInterval subtractToken(BigDecimal age) {
        BigDecimal iUp = IntervalOperations.getRatBound(this.upperBound()).getBound();
        if (iUp.compareTo(BigDecimal.ZERO) < 0) {
            return new TimeInterval(true, new IntBound(0), Bound.Infinity, false);
        }
        BigDecimal newUpper = iUp.subtract(age, new MathContext(9));
        return new TimeInterval(true, new IntBound(0), new RatBound(newUpper), this.isUpperNonstrict());
    }

    public TimeInterval asIterval() {
        return new TimeInterval(true, new IntBound(0), this.upperBound(), this.isUpperNonstrict());
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.isUpperIncluded ? "<=" : "<");
        buffer.append(' ');
        buffer.append(this.upper);
        return buffer.toString();
    }

    public String toString(boolean displayConstantNames) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.isUpperIncluded ? "<=" : "<");
        buffer.append(' ');
        buffer.append(displayConstantNames || this.upper instanceof Bound.InfBound ? this.upper : Integer.valueOf(this.upper.value()));
        return buffer.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.isUpperIncluded ? 1231 : 1237);
        result = 31 * result + (this.upper == null ? 0 : this.upper.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimeInvariant)) {
            return false;
        }
        TimeInvariant other = (TimeInvariant)obj;
        if (this.isUpperIncluded != other.isUpperIncluded) {
            return false;
        }
        return !(this.upper == null ? other.upper != null : !this.upper.equals(other.upper));
    }
}

