/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.model.tapn;

import dk.aau.cs.model.tapn.Bound;
import dk.aau.cs.model.tapn.ConstantBound;
import dk.aau.cs.model.tapn.ConstantStore;
import dk.aau.cs.model.tapn.IntBound;
import dk.aau.cs.model.tapn.TimeInvariant;
import dk.aau.cs.util.IntervalOperations;
import dk.aau.cs.util.Require;
import java.math.BigDecimal;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TimeInterval {
    public static final TimeInterval ZERO_INF = new TimeInterval(true, new IntBound(0), Bound.Infinity, false);
    protected final boolean isLowerIncluded;
    private Bound lower;
    private Bound upper;
    protected final boolean isUpperIncluded;

    public TimeInterval(boolean isLowerIncluded, Bound lower, Bound upper, boolean isUpperIncluded) {
        Require.that(lower != null, "Lower bound cannot be null");
        Require.that(upper != null, "Upper bound cannot be null");
        this.isLowerIncluded = isLowerIncluded;
        this.lower = lower;
        this.upper = upper;
        this.isUpperIncluded = isUpperIncluded;
        Require.that(this.isValidInterval(), "The constructed interval " + String.valueOf(this) + " is empty.");
    }

    public TimeInterval(TimeInterval interval) {
        Require.that(interval != null, "Interval cannot be null");
        this.isLowerIncluded = interval.isLowerIncluded;
        this.isUpperIncluded = interval.isUpperIncluded;
        this.lower = interval.lower.copy();
        this.upper = interval.upper.copy();
    }

    private boolean isValidInterval() {
        boolean canBoundsBeEqual = this.isLowerIncluded && this.isUpperIncluded;
        boolean upperIsInfinity = this.upper instanceof Bound.InfBound;
        boolean equalBounds = !upperIsInfinity && IntervalOperations.getRatBound(this.lower).getBound().compareTo(IntervalOperations.getRatBound(this.upper).getBound()) == 0;
        boolean lowerIsNotInfinity = this.lower != Bound.Infinity;
        boolean lowerSmallerThanUpper = IntervalOperations.getRatBound(this.lower).getBound().compareTo(IntervalOperations.getRatBound(this.upper).getBound()) < 0;
        return lowerIsNotInfinity && (upperIsInfinity && !this.isUpperIncluded || lowerSmallerThanUpper || canBoundsBeEqual && equalBounds);
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean displayConstantNames) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.isLowerIncluded ? "[" : "(");
        buffer.append(displayConstantNames ? this.lower : Integer.valueOf(this.lower.value()));
        buffer.append(',');
        buffer.append(displayConstantNames || this.upper instanceof Bound.InfBound ? this.upper : Integer.valueOf(this.upper.value()));
        buffer.append(this.isUpperIncluded ? "]" : ")");
        return buffer.toString();
    }

    public boolean isIncluded(BigDecimal age) {
        return this.satisfiesLowerBound(age) && this.satisfiesUpperBound(age);
    }

    private boolean satisfiesLowerBound(BigDecimal value) {
        BigDecimal lowerAsBigDec = IntervalOperations.getRatBound(this.lower).getBound();
        int compare = value.compareTo(lowerAsBigDec);
        return this.isLowerIncluded ? compare >= 0 : compare > 0;
    }

    private boolean satisfiesUpperBound(BigDecimal value) {
        if (this.upper instanceof Bound.InfBound) {
            return true;
        }
        BigDecimal upperAsBigDec = IntervalOperations.getRatBound(this.upper).getBound();
        int compare = value.compareTo(upperAsBigDec);
        return this.isUpperIncluded ? compare <= 0 : compare < 0;
    }

    public Bound lowerBound() {
        return this.lower;
    }

    public void setLowerBound(Bound lower) {
        this.lower = lower;
    }

    public Bound upperBound() {
        return this.upper;
    }

    public void setUpperBound(Bound upper) {
        this.upper = upper;
    }

    public boolean isLowerBoundNonStrict() {
        return this.isLowerIncluded;
    }

    public boolean isUpperBoundNonStrict() {
        return this.isUpperIncluded;
    }

    public static TimeInterval parse(String interval, ConstantStore constants) {
        Pattern pattern = Pattern.compile("^(\\[|\\()\\s*(\\w+)\\s*,\\s*(\\w+)(\\]|\\))$");
        Matcher matcher = pattern.matcher(interval);
        matcher.find();
        String leftBracket = matcher.group(1);
        String lowerBoundAsString = matcher.group(2);
        String upperBoundAsString = matcher.group(3);
        String rightBracket = matcher.group(4);
        if (!leftBracket.equals("[") && !leftBracket.equals("(")) {
            return null;
        }
        if (!rightBracket.equals("]") && !rightBracket.equals(")")) {
            return null;
        }
        Bound lowerBound = null;
        try {
            int intLower = Integer.parseInt(lowerBoundAsString);
            lowerBound = new IntBound(intLower);
        }
        catch (NumberFormatException e) {
            if (constants.containsConstantByName(lowerBoundAsString)) {
                lowerBound = new ConstantBound(constants.getConstantByName(lowerBoundAsString));
            }
            throw new RuntimeException("A constant which was not declared was used in an time interval of an arc.");
        }
        Bound upperBound = null;
        if (upperBoundAsString.equals("inf")) {
            upperBound = Bound.Infinity;
        } else {
            try {
                int intBound = Integer.parseInt(upperBoundAsString);
                upperBound = new IntBound(intBound);
            }
            catch (NumberFormatException e) {
                if (constants.containsConstantByName(upperBoundAsString)) {
                    upperBound = new ConstantBound(constants.getConstantByName(upperBoundAsString));
                }
                throw new RuntimeException("A constant which was not declared was used in an time interval of an arc.");
            }
        }
        return new TimeInterval(leftBracket.equals("["), lowerBound, upperBound, rightBracket.equals("]"));
    }

    public TimeInterval copy() {
        return new TimeInterval(this);
    }

    public TimeInterval intersect(TimeInvariant invariant) {
        if (invariant.equals(TimeInvariant.LESS_THAN_INFINITY)) {
            return this.copy();
        }
        int invariantUpper = invariant.upperBound().value();
        if (invariantUpper < this.lower.value() || invariantUpper == this.lower.value() && !this.isLowerIncluded || invariantUpper == this.lower.value() && !invariant.isUpperNonstrict()) {
            return new TimeInterval(false, new IntBound(0), new IntBound(0), false);
        }
        if (invariantUpper > this.upper.value() && !this.upper.equals(Bound.Infinity) || invariantUpper == this.upper.value() && !this.upper.equals(Bound.Infinity) && !this.isUpperIncluded) {
            return this.copy();
        }
        return new TimeInterval(this.isLowerIncluded, this.lower.copy(), invariant.upperBound().copy(), invariant.isUpperNonstrict());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimeInterval)) {
            return false;
        }
        TimeInterval other = (TimeInterval)obj;
        if (this.isLowerIncluded != other.isLowerIncluded) {
            return false;
        }
        if (this.lower == null ? other.lower != null : !this.lower.equals(other.lower)) {
            return false;
        }
        if (this.isUpperIncluded != other.isUpperIncluded) {
            return false;
        }
        return !(this.upper == null ? other.upper != null : !this.upper.equals(other.upper));
    }
}

