/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.model.tapn;

import dk.aau.cs.TCTL.LTLANode;
import dk.aau.cs.TCTL.LTLENode;
import dk.aau.cs.TCTL.LTLFNode;
import dk.aau.cs.TCTL.LTLGNode;
import dk.aau.cs.TCTL.TCTLAFNode;
import dk.aau.cs.TCTL.TCTLAbstractProperty;
import dk.aau.cs.TCTL.TCTLEFNode;
import dk.aau.cs.TCTL.TCTLEGNode;
import dk.aau.cs.TCTL.visitors.HasDeadlockVisitor;
import dk.aau.cs.verification.QueryType;
import dk.aau.cs.verification.SMCSettings;
import dk.aau.cs.verification.observations.Observation;
import java.util.ArrayList;
import java.util.List;
import net.tapaal.gui.petrinet.verification.TAPNQuery;

public class TAPNQuery {
    private TCTLAbstractProperty property;
    private int extraTokens = 0;
    private TAPNQuery.QueryCategory queryCategory = TAPNQuery.QueryCategory.Default;
    private ArrayList<String> traceList;
    private SMCSettings smcSettings;
    private TAPNQuery.VerificationType smcVerificationType;

    public TCTLAbstractProperty getProperty() {
        return this.property;
    }

    public TAPNQuery(TCTLAbstractProperty inputProperty, int extraTokens) {
        this.property = inputProperty;
        this.extraTokens = extraTokens;
        this.smcSettings = SMCSettings.Default();
    }

    public TAPNQuery(TCTLAbstractProperty inputProperty, int extraTokens, SMCSettings smcSettings) {
        this.property = inputProperty;
        this.extraTokens = extraTokens;
        this.smcSettings = smcSettings;
    }

    public int getExtraTokens() {
        return this.extraTokens;
    }

    public QueryType queryType() {
        if (this.property instanceof TCTLEFNode) {
            return QueryType.EF;
        }
        if (this.property instanceof TCTLEGNode) {
            return QueryType.EG;
        }
        if (this.property instanceof TCTLAFNode) {
            return QueryType.AF;
        }
        if (this.queryCategory == TAPNQuery.QueryCategory.SMC && this.property instanceof LTLFNode) {
            return QueryType.PF;
        }
        if (this.queryCategory == TAPNQuery.QueryCategory.SMC && this.property instanceof LTLGNode) {
            return QueryType.PG;
        }
        if (this.property instanceof LTLENode) {
            return QueryType.E;
        }
        if (this.property instanceof LTLANode) {
            return QueryType.A;
        }
        return QueryType.AG;
    }

    public boolean hasDeadlock() {
        return new HasDeadlockVisitor().hasDeadLock(this.getProperty());
    }

    public String toString() {
        return this.property.toString();
    }

    public void setProperty(TCTLAbstractProperty newProperty) {
        this.property = newProperty;
    }

    public void setCategory(TAPNQuery.QueryCategory category) {
        this.queryCategory = category;
    }

    public TAPNQuery.QueryCategory getCategory() {
        return this.queryCategory;
    }

    public void setVerificationType(TAPNQuery.VerificationType smcVerificationType) {
        this.smcVerificationType = smcVerificationType;
    }

    public TAPNQuery.VerificationType getVerificationType() {
        return this.smcVerificationType;
    }

    public boolean isSimulate() {
        return this.smcVerificationType.equals((Object)TAPNQuery.VerificationType.SIMULATE);
    }

    public void setTraceList(ArrayList<String> traces) {
        this.traceList = traces;
    }

    public ArrayList<String> getTraceList() {
        return this.traceList;
    }

    public void setSMCSettings(SMCSettings settings) {
        this.smcSettings = settings;
    }

    public SMCSettings getSMCSettings() {
        return this.smcSettings;
    }

    public List<Observation> getObservations() {
        return this.smcSettings.getObservations();
    }
}

