/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.model.tapn;

import dk.aau.cs.model.tapn.SMCDistribution;
import java.util.LinkedHashMap;

public class SMCTriangularDistribution
extends SMCDistribution {
    public static final String NAME = "triangular";
    public double a;
    public double b;
    public double c;

    public SMCTriangularDistribution(double x, double y, double z) {
        this.a = x;
        this.b = y;
        this.c = z;
    }

    @Override
    public String distributionName() {
        return NAME;
    }

    @Override
    public LinkedHashMap<String, Double> getParameters() {
        LinkedHashMap<String, Double> params = new LinkedHashMap<String, Double>();
        params.put("a", this.a);
        params.put("b", this.b);
        params.put("c", this.c);
        return params;
    }

    @Override
    public Double getMean() {
        return (this.a + this.b + this.c) / 3.0;
    }

    @Override
    public String explanation() {
        return "<html>Distribution between two reals A and B with A \u2264 C \u2264 B, <br/>in which the density function increases linearly from A to C <br/>and then decreases from C to B</html>";
    }

    public static SMCTriangularDistribution defaultDistribution() {
        return new SMCTriangularDistribution(0.0, 1.0, 0.5);
    }
}

