/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.model.tapn;

import dk.aau.cs.model.tapn.SMCDistribution;
import java.util.LinkedHashMap;

public class SMCLogNormalDistribution
extends SMCDistribution {
    public static final String NAME = "log normal";
    public double logMean;
    public double logStddev;

    public SMCLogNormalDistribution(double mu, double sigma) {
        this.logMean = mu;
        this.logStddev = sigma;
    }

    @Override
    public String distributionName() {
        return NAME;
    }

    @Override
    public LinkedHashMap<String, Double> getParameters() {
        LinkedHashMap<String, Double> params = new LinkedHashMap<String, Double>();
        params.put("logMean", this.logMean);
        params.put("logStddev", this.logStddev);
        return params;
    }

    @Override
    public Double getMean() {
        return Math.exp(this.logMean + Math.pow(this.logStddev, 2.0) / 2.0);
    }

    @Override
    public String explanation() {
        return "<html>Distribution which Log is normally distributed, <br/>meaning if X follows a log-normal distribution, <br/>ln(X) follows a normal distribution. <br/>The distribution is parameterized by the mean and the std. dev. of its logarithm.</html>";
    }

    public static SMCLogNormalDistribution defaultDistribution() {
        return new SMCLogNormalDistribution(0.0, 1.0);
    }

    public double pdf(double x) {
        double exp_num = -Math.pow(Math.log(x) - this.logMean, 2.0);
        double exp_den = 2.0 * Math.pow(this.logStddev, 2.0);
        double exp = Math.exp(exp_num / exp_den);
        double fact = 1.0 / (x * this.logStddev * Math.sqrt(Math.PI * 2));
        return fact * exp;
    }
}

