/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.model.tapn;

import dk.aau.cs.model.tapn.SMCDistribution;
import java.util.LinkedHashMap;

public class SMCGammaDistribution
extends SMCDistribution {
    public static final String NAME = "gamma";
    public double shape;
    public double scale;

    public SMCGammaDistribution(double shape, double scale) {
        this.shape = shape;
        this.scale = scale;
    }

    @Override
    public String distributionName() {
        return NAME;
    }

    @Override
    public LinkedHashMap<String, Double> getParameters() {
        LinkedHashMap<String, Double> params = new LinkedHashMap<String, Double>();
        params.put("shape", this.shape);
        params.put("scale", this.scale);
        return params;
    }

    @Override
    public String explanation() {
        return "<html>Gamma distribution</html>";
    }

    @Override
    public Double getMean() {
        return this.shape * this.scale;
    }

    public static SMCGammaDistribution defaultDistribution() {
        return new SMCGammaDistribution(1.0, 1.0);
    }
}

