/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.model.tapn;

import dk.aau.cs.model.tapn.SMCDistribution;
import java.util.LinkedHashMap;

public class SMCExponentialDistribution
extends SMCDistribution {
    public static final String NAME = "exponential";
    public double rate;
    private final double mean;

    public SMCExponentialDistribution(double rate) {
        this.rate = rate;
        this.mean = 1.0 / rate;
    }

    @Override
    public String distributionName() {
        return NAME;
    }

    @Override
    public LinkedHashMap<String, Double> getParameters() {
        LinkedHashMap<String, Double> params = new LinkedHashMap<String, Double>();
        params.put("rate", this.rate);
        return params;
    }

    @Override
    public Double getMean() {
        return this.mean;
    }

    @Override
    public String explanation() {
        return "<html>Memoryless distribution, <br/>probability of the distance between events <br/>occurring according to a real rate.</html>";
    }

    public static SMCExponentialDistribution defaultDistribution() {
        return new SMCExponentialDistribution(0.1);
    }
}

