/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.model.tapn;

import dk.aau.cs.model.tapn.SMCConstantDistribution;
import dk.aau.cs.model.tapn.SMCDiscreteUniformDistribution;
import dk.aau.cs.model.tapn.SMCErlangDistribution;
import dk.aau.cs.model.tapn.SMCExponentialDistribution;
import dk.aau.cs.model.tapn.SMCGammaDistribution;
import dk.aau.cs.model.tapn.SMCGeometricDistribution;
import dk.aau.cs.model.tapn.SMCLogNormalDistribution;
import dk.aau.cs.model.tapn.SMCNormalDistribution;
import dk.aau.cs.model.tapn.SMCTriangularDistribution;
import dk.aau.cs.model.tapn.SMCUniformDistribution;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.w3c.dom.Element;

public abstract class SMCDistribution {
    public abstract String distributionName();

    public abstract LinkedHashMap<String, Double> getParameters();

    public abstract String explanation();

    public Double getMean() {
        return null;
    }

    public void writeToXml(Element target) {
        target.setAttribute("distribution", this.distributionName());
        for (Map.Entry<String, Double> entry : this.getParameters().entrySet()) {
            target.setAttribute(entry.getKey(), entry.getValue().toString());
        }
    }

    public String toString() {
        StringBuilder res = new StringBuilder("distribution=\"" + this.distributionName() + "\" ");
        for (Map.Entry<String, Double> entry : this.getParameters().entrySet()) {
            res.append(entry.getKey()).append("=\"").append(entry.getValue().toString()).append("\" ");
        }
        return res.toString();
    }

    public String summary() {
        StringBuilder res = new StringBuilder(this.distributionName() + "(");
        LinkedList<String> params = new LinkedList<String>();
        for (Map.Entry<String, Double> entry : this.getParameters().entrySet()) {
            params.add(entry.getValue().toString());
        }
        res.append(String.join((CharSequence)",", params));
        res.append(")");
        return res.toString();
    }

    public static SMCDistribution defaultDistribution() {
        return SMCConstantDistribution.defaultDistribution();
    }

    public static SMCDistribution defaultDistributionFor(String name) {
        switch (name) {
            case "constant": {
                return SMCConstantDistribution.defaultDistribution();
            }
            case "uniform": {
                return SMCUniformDistribution.defaultDistribution();
            }
            case "exponential": {
                return SMCExponentialDistribution.defaultDistribution();
            }
            case "normal": {
                return SMCNormalDistribution.defaultDistribution();
            }
            case "gamma": {
                return SMCGammaDistribution.defaultDistribution();
            }
            case "erlang": {
                return SMCErlangDistribution.defaultDistribution();
            }
            case "discrete uniform": {
                return SMCDiscreteUniformDistribution.defaultDistribution();
            }
            case "geometric": {
                return SMCGeometricDistribution.defaultDistribution();
            }
            case "triangular": {
                return SMCTriangularDistribution.defaultDistribution();
            }
            case "log normal": {
                return SMCLogNormalDistribution.defaultDistribution();
            }
        }
        return SMCDistribution.defaultDistribution();
    }

    public static SMCDistribution urgent() {
        return new SMCConstantDistribution(0.0);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.getParameters().equals(((SMCDistribution)o).getParameters());
    }

    public static SMCDistribution parseXml(Element elem) {
        String type = elem.getAttribute("distribution");
        try {
            switch (type) {
                case "constant": {
                    double value = Double.parseDouble(elem.getAttribute("value"));
                    return new SMCConstantDistribution(value);
                }
                case "uniform": {
                    double a = Double.parseDouble(elem.getAttribute("a"));
                    double b = Double.parseDouble(elem.getAttribute("b"));
                    return new SMCUniformDistribution(a, b);
                }
                case "exponential": {
                    double rate = Double.parseDouble(elem.getAttribute("rate"));
                    return new SMCExponentialDistribution(rate);
                }
                case "normal": {
                    double mean = Double.parseDouble(elem.getAttribute("mean"));
                    double stddev = Double.parseDouble(elem.getAttribute("stddev"));
                    return new SMCNormalDistribution(mean, stddev);
                }
                case "gamma": {
                    double shape = Double.parseDouble(elem.getAttribute("shape"));
                    double scale = Double.parseDouble(elem.getAttribute("scale"));
                    return new SMCGammaDistribution(shape, scale);
                }
                case "erlang": {
                    double e_shape = Double.parseDouble(elem.getAttribute("shape"));
                    double e_scale = Double.parseDouble(elem.getAttribute("scale"));
                    return new SMCErlangDistribution(e_shape, e_scale);
                }
                case "discrete uniform": {
                    double da = Double.parseDouble(elem.getAttribute("a"));
                    double db = Double.parseDouble(elem.getAttribute("b"));
                    return new SMCDiscreteUniformDistribution(da, db);
                }
                case "geometric": {
                    double p = Double.parseDouble(elem.getAttribute("p"));
                    return new SMCGeometricDistribution(p);
                }
                case "triangular": {
                    double t_a = Double.parseDouble(elem.getAttribute("a"));
                    double t_b = Double.parseDouble(elem.getAttribute("b"));
                    double t_c = Double.parseDouble(elem.getAttribute("c"));
                    return new SMCTriangularDistribution(t_a, t_b, t_c);
                }
                case "log normal": {
                    double logMean = Double.parseDouble(elem.getAttribute("logMean"));
                    double logStddev = Double.parseDouble(elem.getAttribute("logStddev"));
                    return new SMCLogNormalDistribution(logMean, logStddev);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return SMCDistribution.defaultDistribution();
    }
}

