/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.model.tapn;

import dk.aau.cs.model.tapn.Bound;
import dk.aau.cs.util.Require;
import java.math.BigDecimal;
import java.math.MathContext;

public class RatBound
implements Bound {
    private final BigDecimal bound;

    public RatBound(BigDecimal bound) {
        Require.that(bound.compareTo(new BigDecimal(-1, new MathContext(9))) >= 0, "Rational bounds must be non-negative or -1.");
        this.bound = bound;
    }

    public RatBound(RatBound bound) {
        Require.that(bound != null, "Rational bound cannot be null");
        this.bound = bound.bound;
    }

    @Override
    public int value() {
        return this.bound.intValue();
    }

    public BigDecimal getBound() {
        return this.bound;
    }

    public String toString() {
        return this.bound.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.bound.intValue();
        return result;
    }

    public int compareTo(RatBound b) {
        if (this.getBound().compareTo(BigDecimal.ZERO) < 0) {
            if (this.getBound().compareTo(b.getBound()) == 0) {
                return 0;
            }
            return 1;
        }
        if (b.getBound().compareTo(BigDecimal.ZERO) < 0) {
            return -1;
        }
        return this.getBound().compareTo(b.getBound());
    }

    @Override
    public RatBound copy() {
        return new RatBound(this);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RatBound)) {
            return false;
        }
        RatBound other = (RatBound)obj;
        return this.bound == other.bound;
    }
}

