/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.model.tapn;

import dk.aau.cs.model.NTA.trace.TraceToken;
import dk.aau.cs.model.tapn.LocalTimedPlace;
import dk.aau.cs.model.tapn.NetworkMarking;
import dk.aau.cs.model.tapn.TimeInvariant;
import dk.aau.cs.model.tapn.TimedMarking;
import dk.aau.cs.model.tapn.TimedPlace;
import dk.aau.cs.model.tapn.TimedToken;
import dk.aau.cs.model.tapn.TimedTransition;
import dk.aau.cs.model.tapn.simulation.FiringMode;
import dk.aau.cs.util.Require;
import dk.aau.cs.util.Tuple;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LocalTimedMarking
implements TimedMarking {
    private final HashMap<TimedPlace, List<TimedToken>> placesToTokensMap = new HashMap();
    private NetworkMarking parent;

    public void setNetworkMarking(NetworkMarking marking) {
        this.parent = marking;
    }

    public NetworkMarking getNetworkMarking() {
        return this.parent;
    }

    @Override
    public void add(TimedToken token) {
        if (token.place().isShared()) {
            this.parent.add(token);
        } else {
            if (!this.placesToTokensMap.containsKey(token.place())) {
                this.placesToTokensMap.put(token.place(), new ArrayList());
            }
            List<TimedToken> tokens = this.placesToTokensMap.get(token.place());
            tokens.add(token);
        }
    }

    private void add(List<TimedToken> producedTokens) {
        for (TimedToken token : producedTokens) {
            this.add(token);
        }
    }

    @Override
    public void remove(TimedToken token) {
        List<TimedToken> tokens;
        if (token.place().isShared()) {
            this.parent.remove(token);
        } else if (this.placesToTokensMap.containsKey(token.place()) && !(tokens = this.placesToTokensMap.get(token.place())).remove(token) && token instanceof TraceToken) {
            for (TimedToken t : tokens) {
                if (t.age().compareTo(token.age()) < 0) continue;
                tokens.remove(t);
                break;
            }
        }
    }

    private void remove(List<TimedToken> tokensToConsume) {
        for (TimedToken token : tokensToConsume) {
            this.remove(token);
        }
    }

    @Override
    public void removePlaceFromMarking(TimedPlace place) {
        if (place.isShared()) {
            this.parent.removePlaceFromMarking(place);
        } else {
            this.placesToTokensMap.remove(place);
        }
    }

    private List<TimedToken> getTokensFor(LocalTimedPlace place) {
        if (!this.placesToTokensMap.containsKey(place)) {
            return new ArrayList<TimedToken>();
        }
        return this.placesToTokensMap.get(place);
    }

    public Map<TimedPlace, List<TimedToken>> getPlacesToTokensMap() {
        return this.placesToTokensMap;
    }

    @Override
    public List<TimedToken> getTokensFor(TimedPlace place) {
        if (place.isShared()) {
            return this.parent.getTokensFor(place);
        }
        return this.getTokensFor((LocalTimedPlace)place);
    }

    @Override
    public boolean isDelayPossible(BigDecimal delay) {
        Require.that(delay.compareTo(BigDecimal.ZERO) >= 0, "cannot delay with negative numbers");
        for (Map.Entry<TimedPlace, List<TimedToken>> entry : this.placesToTokensMap.entrySet()) {
            for (TimedToken token : entry.getValue()) {
                TimeInvariant invariant = token.place().invariant();
                if (invariant.isSatisfied(token.age().add(delay))) continue;
                return false;
            }
        }
        return true;
    }

    public List<TimedPlace> getBlockingPlaces(BigDecimal delay) {
        Require.that(delay.compareTo(BigDecimal.ZERO) >= 0, "cannot delay with negative numbers");
        ArrayList<TimedPlace> result = new ArrayList<TimedPlace>();
        for (Map.Entry<TimedPlace, List<TimedToken>> entry : this.placesToTokensMap.entrySet()) {
            boolean blocked = false;
            for (TimedToken token : entry.getValue()) {
                TimeInvariant invariant = token.place().invariant();
                if (invariant.isSatisfied(token.age().add(delay))) continue;
                blocked = true;
            }
            if (!blocked) continue;
            result.add(entry.getKey());
        }
        return result;
    }

    @Override
    public LocalTimedMarking clone() {
        return this.delay(BigDecimal.ZERO);
    }

    @Override
    public LocalTimedMarking delay(BigDecimal amount) {
        Require.that(amount.compareTo(BigDecimal.ZERO) >= 0, "cannot delay with negative numbers");
        Require.that(this.isDelayPossible(amount), "The specified delay is not possible due to an invariant.");
        LocalTimedMarking clone = new LocalTimedMarking();
        for (Map.Entry<TimedPlace, List<TimedToken>> entry : this.placesToTokensMap.entrySet()) {
            ArrayList<TimedToken> newTokens = new ArrayList<TimedToken>(entry.getValue().size());
            for (TimedToken token : entry.getValue()) {
                newTokens.add(token.delay(amount));
            }
            clone.placesToTokensMap.put(entry.getKey(), newTokens);
        }
        clone.parent = this.parent;
        return clone;
    }

    @Override
    public LocalTimedMarking fireTransition(TimedTransition transition, List<TimedToken> tokensToConsume) {
        Require.that(transition != null, "transition must not be null");
        Require.that(transition.isEnabledBy(tokensToConsume), "Tokens do not enable transition");
        LocalTimedMarking clone = this.clone();
        List<TimedToken> producedTokens = transition.calculateProducedTokensFrom(tokensToConsume);
        clone.remove(tokensToConsume);
        clone.add(producedTokens);
        return clone;
    }

    public Tuple<LocalTimedMarking, List<TimedToken>> fireTransition(TimedTransition transition, FiringMode firingMode) {
        Require.that(transition != null, "transition must not be null");
        Require.that(transition.isEnabled(), "Transition must be enabled");
        List<TimedToken> tokensToConsume = transition.calculateConsumedTokens(firingMode);
        return new Tuple<TimedMarking, List<TimedToken>>(this.fireTransition(transition, (List)tokensToConsume), tokensToConsume);
    }

    @Override
    public int size() {
        int size = 0;
        for (List<TimedToken> tokens : this.placesToTokensMap.values()) {
            size += tokens.size();
        }
        return size;
    }

    public void clear() {
        this.placesToTokensMap.clear();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LocalTimedMarking)) {
            return false;
        }
        LocalTimedMarking other = (LocalTimedMarking)obj;
        if (this.placesToTokensMap.size() != other.placesToTokensMap.size()) {
            return false;
        }
        for (TimedPlace key : this.placesToTokensMap.keySet()) {
            if (other.placesToTokensMap.get(key) == null) {
                return false;
            }
            if (other.placesToTokensMap.get(key).size() != this.placesToTokensMap.get(key).size()) {
                return false;
            }
            int i = 0;
            for (TimedToken t : other.placesToTokensMap.get(key)) {
                if (t.equals(this.placesToTokensMap.get(key).get(i++))) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<TimedPlace, List<TimedToken>> entry : this.placesToTokensMap.entrySet()) {
            sb.append(entry.getKey().name()).append(" -> ");
            for (TimedToken token : entry.getValue()) {
                sb.append(token.toString()).append(" ");
            }
            sb.append("\n");
        }
        return sb.toString();
    }
}

